/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common.navigator.keywordNavigator;

import java.util.ArrayList;
import oracle.help.common.KeywordTopicTreeNode;
import oracle.help.common.Topic;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.View;
import oracle.help.common.navigator.keywordNavigator.EntryModelData;
import oracle.help.navigator.keywordNavigator.KeywordListItem;
import oracle.help.navigator.keywordNavigator.KeywordNodeInfo;

public class EntryModel {
    public static final int COLUMN_TITLE = 0;
    public static final int COLUMN_SOURCE = 1;
    private KeywordListItem _listItem;
    private EntryModelData _entryModelData;

    public EntryModel(EntryModelData entryModelData) {
        this._entryModelData = entryModelData;
        this._listItem = null;
    }

    public static Object getData(Object object, int n, int n2) {
        if (object != null) {
            if (n == 0) {
                Topic topic = (Topic)object;
                return topic.getLabel();
            }
            if (n == 1) {
                View view = (View)object;
                String string = view.getTitle();
                if (string == null) {
                    string = new String("");
                }
                return string;
            }
        }
        return null;
    }

    public EntryModelData getEntryModelData() {
        return this._entryModelData;
    }

    public Topic getTopicForRow(int n) {
        Topic topic = (Topic)this._entryModelData.getRealData(0, n);
        return topic;
    }

    public KeywordListItem getListItem() {
        return this._listItem;
    }

    public void populateModel(KeywordListItem keywordListItem) {
        this.resetModel();
        this._listItem = keywordListItem;
        if (keywordListItem != null) {
            int n = 0;
            while (n < keywordListItem.getNodeInfoCount()) {
                KeywordNodeInfo keywordNodeInfo = keywordListItem.getNodeInfoByIndex(n);
                this._addNodeEntries(keywordNodeInfo.node, keywordNodeInfo.view);
                ++n;
            }
        }
    }

    public void resetModel() {
        this._entryModelData.resetModel();
    }

    private void _addNodeEntries(TopicTreeNode topicTreeNode, View view) {
        if (topicTreeNode != null) {
            int n;
            Object object;
            ArrayList arrayList;
            this._entryModelData.addTopic(topicTreeNode.getTopic(), view);
            if (topicTreeNode instanceof KeywordTopicTreeNode && (arrayList = ((KeywordTopicTreeNode)(object = (KeywordTopicTreeNode)topicTreeNode)).getEntries()) != null) {
                n = 0;
                while (n < arrayList.size()) {
                    this._addNodeEntries((TopicTreeNode)arrayList.get(n), view);
                    ++n;
                }
            }
            if ((object = topicTreeNode.getChildren()) != null) {
                n = 0;
                while (n < ((ArrayList)object).size()) {
                    this._addNodeEntries((TopicTreeNode)((ArrayList)object).get(n), view);
                    ++n;
                }
            }
        }
    }
}

