/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common;

import java.util.ArrayList;
import oracle.help.common.Topic;

public class TopicTreeNode {
    private TopicTreeNode _parent;
    private ArrayList _children;
    private Topic _topic;
    private Object _clientData;

    public TopicTreeNode() {
        this._parent = null;
        this._topic = null;
        this._children = null;
        this._clientData = null;
    }

    public TopicTreeNode(Topic topic) {
        this._parent = null;
        this._topic = topic;
        this._children = null;
        this._clientData = null;
    }

    public TopicTreeNode(Topic topic, TopicTreeNode topicTreeNode) {
        this._parent = topicTreeNode;
        this._topic = topic;
        this._children = null;
        this._clientData = null;
    }

    public TopicTreeNode getParent() {
        return this._parent;
    }

    public void setParent(TopicTreeNode topicTreeNode) {
        this._parent = topicTreeNode;
    }

    public ArrayList getChildren() {
        return this._children;
    }

    public TopicTreeNode getChildByIndex(int n) throws IndexOutOfBoundsException {
        TopicTreeNode topicTreeNode = null;
        if (n >= this.getNumChildren()) {
            throw new IndexOutOfBoundsException("Child Index out of Bounds");
        }
        topicTreeNode = (TopicTreeNode)this._children.get(n);
        return topicTreeNode;
    }

    public boolean isBranch() {
        boolean bl = false;
        if (this.getNumChildren() > 0) {
            bl = true;
        }
        return bl;
    }

    public final int getNumChildren() {
        if (this._children == null) {
            return 0;
        }
        return this._children.size();
    }

    public Topic getTopic() {
        return this._topic;
    }

    public Topic[] getAllTopicsInSubTree() {
        ArrayList arrayList = new ArrayList();
        this._recursiveTopicHelper(this, arrayList);
        Topic[] topicArray = null;
        if (arrayList.size() > 0) {
            topicArray = new Topic[arrayList.size()];
            arrayList.toArray(topicArray);
        }
        return topicArray;
    }

    public void setTopic(Topic topic) {
        this._topic = topic;
    }

    public TopicTreeNode addChild(Topic topic) {
        return this.addChild(new TopicTreeNode(topic));
    }

    public TopicTreeNode addChild(TopicTreeNode topicTreeNode) {
        topicTreeNode.setParent(this);
        if (this._children == null) {
            this._children = new ArrayList(5);
        }
        this._children.add(topicTreeNode);
        return topicTreeNode;
    }

    public void clearChildren() {
        if (this._children != null) {
            this._children.clear();
        }
    }

    public void setClientData(Object object) {
        this._clientData = object;
    }

    public Object getClientData() {
        return this._clientData;
    }

    private void _recursiveTopicHelper(TopicTreeNode topicTreeNode, ArrayList arrayList) {
        if (topicTreeNode != null) {
            ArrayList arrayList2;
            Topic topic = topicTreeNode.getTopic();
            if (topic != null) {
                arrayList.add(topic);
            }
            if ((arrayList2 = topicTreeNode.getChildren()) != null) {
                int n = 0;
                while (n < arrayList2.size()) {
                    TopicTreeNode topicTreeNode2 = (TopicTreeNode)arrayList2.get(n);
                    this._recursiveTopicHelper(topicTreeNode2, arrayList);
                    ++n;
                }
            }
        }
    }
}

