/*
 * Decompiled with CFR 0.152.
 */
package oracle.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JToolBar;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.event.ListenerManager;
import oracle.help.DefaultWindowManager;
import oracle.help.common.SimpleTopic;
import oracle.help.common.SimpleURLTarget;
import oracle.help.common.Topic;
import oracle.help.common.WindowCoordinate;
import oracle.help.common.WindowType;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.java.util.ImageLoader;
import oracle.help.java.util.MenuUtils;
import oracle.help.topicDisplay.DocumentStack;
import oracle.help.topicDisplay.SimpleTopicDisplayPanel;
import oracle.help.topicDisplay.TopicDisplay;
import oracle.help.topicDisplay.TopicDisplayEvent;
import oracle.help.topicDisplay.TopicDisplayException;
import oracle.help.topicDisplay.TopicDisplayListener;
import oracle.help.topicDisplay.print.TopicPrintJob;

public class DefaultTopicPanel
extends JPanel
implements TopicDisplay,
ActionListener,
TopicDisplayListener {
    private static String GENERIC_RESOURCE_BUNDLE = "oracle.help.resource.Generic";
    private static String MENU_RESOURCE_BUNDLE = "oracle.help.resource.MenuLabels";
    private static String TOPIC_WINDOW_TITLE = "defaultTopicWindow.title";
    private TopicWindowMenuBar _menuBar;
    private SimpleTopicDisplayPanel _topicPanel;
    private JFrame _topicFrame;
    private JDialog _topicDialog;
    private boolean _inDialogState;
    private FrameTopicPanelReclaimer _frameListener;
    private DialogTopicPanelReclaimer _dialogListener;
    private String _defaultTitle;
    private DefaultWindowManager _manager;
    private WindowType _currentWindowType;
    private boolean _currentlyDocked;
    private TopicDisplay _topicDisplay;
    private JToolBar _toolBar;
    private Component _navSeparator;
    private Component _dockToolBarSeparator;
    private JButton _navigatorButton;
    private JButton _backButton;
    private JButton _forwardButton;
    private JButton _printButton;
    private JRadioButton _dockButton;
    private JRadioButton _undockButton;
    private DocumentStack _documentStack;
    private ListenerManager _listeners;
    private static ImageIcon _navImage;
    private static ImageIcon _larrowImage;
    private static ImageIcon _rarrowImage;
    private static ImageIcon _printImage;
    private static ImageIcon _dockImage;
    private static ImageIcon _undockImage;
    private JMenu _fileMenu;
    private JMenu _goMenu;
    private JMenu _toolsMenu;
    private JMenuItem _printItem;
    private JMenuItem _closeItem;
    private JMenuItem _exitItem;
    private JMenuItem _backItem;
    private JMenuItem _forwardItem;
    private JMenuItem _navigatorItem;
    private JMenuItem _findItem;
    private JPopupMenu.Separator _dockSeparator;
    private JMenuItem _dockItem;
    private JMenuItem _optionsItem;
    private JMenuItem _emptyItem;

    public DefaultTopicPanel(TopicDisplay topicDisplay, DefaultWindowManager defaultWindowManager) {
        Object object;
        if (topicDisplay == null) {
            throw new IllegalArgumentException("Default Topic Window:  Null argument passed in constructor");
        }
        this._manager = defaultWindowManager;
        this._topicDisplay = topicDisplay;
        this._topicDisplay.addDisplayListener(this);
        ResourceBundle resourceBundle = ResourceBundle.getBundle(GENERIC_RESOURCE_BUNDLE, StaticLocaleContext.getLocale());
        this._defaultTitle = resourceBundle.getString(TOPIC_WINDOW_TITLE);
        this._listeners = new ListenerManager();
        this.setLayout(new BorderLayout());
        this._menuBar = new TopicWindowMenuBar();
        this._toolBar = new JToolBar();
        Insets insets = new Insets(2, 2, 2, 2);
        if (_navImage == null) {
            this._loadImages();
        }
        if (this._manager != null) {
            this._navigatorButton = new JButton(_navImage);
            this._navigatorButton.setMargin(insets);
            this._toolBar.add(this._navigatorButton);
            this._navigatorButton.addActionListener(this);
            this._navigatorButton.setEnabled(true);
        }
        this._navSeparator = new JToolBar.Separator();
        this._toolBar.add(this._navSeparator);
        this._backButton = new JButton(_larrowImage);
        this._backButton.setMargin(insets);
        this._toolBar.add(this._backButton);
        this._backButton.addActionListener(this);
        this._backButton.setEnabled(false);
        this._forwardButton = new JButton(_rarrowImage);
        this._forwardButton.setMargin(insets);
        this._toolBar.add(this._forwardButton);
        this._forwardButton.addActionListener(this);
        this._forwardButton.setEnabled(false);
        this._toolBar.add(new JToolBar.Separator());
        this._printButton = new JButton(_printImage);
        this._printButton.setMargin(insets);
        this._toolBar.add(this._printButton);
        this._printButton.addActionListener(this);
        this._dockToolBarSeparator = new JToolBar.Separator();
        this._toolBar.add(this._dockToolBarSeparator);
        if (this._manager != null) {
            object = new ButtonGroup();
            this._dockButton = new JRadioButton(_dockImage);
            this._dockButton.setMargin(insets);
            ((ButtonGroup)object).add(this._dockButton);
            this._toolBar.add(this._dockButton);
            this._dockButton.addActionListener(this);
            this._dockButton.setSelected(false);
            this._undockButton = new JRadioButton(_undockImage);
            this._undockButton.setMargin(insets);
            ((ButtonGroup)object).add(this._undockButton);
            this._toolBar.add(this._undockButton);
            this._undockButton.addActionListener(this);
            this._undockButton.setSelected(true);
        }
        object = MenuUtils.removeSpecialMenuChars(MenuUtils.getDefaultMenuLabel("menu.Navigator"));
        this._navigatorButton.setToolTipText((String)object);
        String string = MenuUtils.removeSpecialMenuChars(MenuUtils.getDefaultMenuLabel("menu.Back"));
        this._backButton.setToolTipText(string);
        String string2 = MenuUtils.removeSpecialMenuChars(MenuUtils.getDefaultMenuLabel("menu.Forward"));
        this._forwardButton.setToolTipText(string2);
        String string3 = MenuUtils.removeSpecialMenuChars(MenuUtils.getDefaultMenuLabel("menu.PrintTopic"));
        this._printButton.setToolTipText(string3);
        String string4 = MenuUtils.removeSpecialMenuChars(MenuUtils.getDefaultMenuLabel("menu.Dock"));
        this._dockButton.setToolTipText(string4);
        String string5 = MenuUtils.removeSpecialMenuChars(MenuUtils.getDefaultMenuLabel("menu.Undock"));
        this._undockButton.setToolTipText(string5);
        this._topicFrame = null;
        this._topicDialog = null;
        this._setDialogState(false);
        this._frameListener = new FrameTopicPanelReclaimer();
        this._dialogListener = new DialogTopicPanelReclaimer();
        this._topicPanel = new SimpleTopicDisplayPanel(this._topicDisplay, this._menuBar, this._toolBar);
        this._documentStack = new DocumentStack(this._topicPanel);
        this._currentlyDocked = false;
        this.add((Component)this._topicPanel, "Center");
    }

    public JFrame createTopicWindowFrame() {
        if (this._topicDialog != null) {
            this.disposeTopicDialog();
        }
        if (this._topicFrame == null) {
            this._topicFrame = new JFrame();
            WindowUtils.registerWindow((Window)this._topicFrame);
            if (ImageLoader.getIconImage() != null) {
                ((Frame)this._topicFrame).setIconImage(ImageLoader.getIconImage());
            }
            this._topicFrame.getContentPane().setLayout(new BorderLayout());
            this._topicFrame.getContentPane().add((Component)this, "Center");
            this._topicFrame.addWindowListener(this._frameListener);
            this._topicFrame.setTitle(this._defaultTitle);
            ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.help.resource.Defaults", StaticLocaleContext.getLocale());
            String string = resourceBundle.getString("topicwin.width");
            String string2 = resourceBundle.getString("topicwin.height");
            ((Component)this._topicFrame).setSize(Integer.parseInt(string), Integer.parseInt(string2));
        }
        return this._topicFrame;
    }

    public JDialog createTopicWindowDialog(Dialog dialog) {
        if (this._topicFrame != null) {
            this.disposeTopicFrame();
        }
        if (this._topicDialog != null && this._topicDialog.getParent() != dialog) {
            this.disposeTopicDialog();
        }
        if (this._topicDialog == null) {
            this._topicDialog = new JDialog(dialog);
            WindowUtils.registerWindow((Window)this._topicDialog);
            this._topicDialog.getContentPane().setLayout(new BorderLayout());
            this._topicDialog.getContentPane().add((Component)this, "Center");
            this._topicDialog.addComponentListener(this._dialogListener);
            this._topicDialog.setTitle(this._defaultTitle);
            ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.help.resource.Defaults", StaticLocaleContext.getLocale());
            String string = resourceBundle.getString("topicwin.width");
            String string2 = resourceBundle.getString("topicwin.height");
            ((Component)this._topicDialog).setSize(Integer.parseInt(string), Integer.parseInt(string2));
        }
        return this._topicDialog;
    }

    public Window getCurrentTopicWindow() {
        if (this._topicFrame != null) {
            return this._topicFrame;
        }
        if (this._topicDialog != null) {
            return this._topicDialog;
        }
        return null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent != null) {
            if (actionEvent.getSource() == this._printButton) {
                try {
                    this.printDisplayedTopic();
                }
                catch (Exception exception) {}
            } else if (actionEvent.getSource() == this._navigatorButton) {
                if (this._manager != null) {
                    this._manager.showNavigatorWindow();
                }
            } else if (actionEvent.getSource() == this._forwardButton) {
                this._documentStack.goForward();
            } else if (actionEvent.getSource() == this._backButton) {
                this._documentStack.goBack();
            } else if (actionEvent.getSource() == this._dockButton) {
                this.dockTopicPanel();
            } else if (actionEvent.getSource() == this._undockButton) {
                this.undockTopicPanel();
            }
        }
    }

    public void topicDisplayChanged(TopicDisplayEvent topicDisplayEvent) {
        if (topicDisplayEvent.getID() == 2000) {
            Window window;
            if (topicDisplayEvent.getChangeType() == 0) {
                this._documentStack.addElement(topicDisplayEvent.getURL());
                this._backButton.setEnabled(this._documentStack.canGoBack());
                this._backItem.setEnabled(this._documentStack.canGoBack());
                this._forwardButton.setEnabled(this._documentStack.canGoForward());
                this._forwardItem.setEnabled(this._documentStack.canGoForward());
            } else if (topicDisplayEvent.getChangeType() == 1 && (window = this.getCurrentTopicWindow()) != null) {
                WindowType windowType = topicDisplayEvent.getWindowType();
                Rectangle rectangle = window.getBounds();
                if (windowType != this._currentWindowType) {
                    if (this._currentWindowType != null) {
                        this._currentWindowType.setBounds(rectangle);
                    }
                    this._currentWindowType = windowType;
                    if (windowType != null) {
                        WindowCoordinate windowCoordinate = windowType.getHeight();
                        if (windowCoordinate != null) {
                            rectangle.height = windowCoordinate.getValue(0, window);
                        }
                        if ((windowCoordinate = windowType.getWidth()) != null) {
                            rectangle.width = windowCoordinate.getValue(0, window);
                        }
                        if ((windowCoordinate = windowType.getX()) != null) {
                            rectangle.x = windowCoordinate.getValue(rectangle.width, window);
                        }
                        if ((windowCoordinate = windowType.getY()) != null) {
                            rectangle.y = windowCoordinate.getValue(rectangle.height, window);
                        }
                        ((Component)window).setBounds(rectangle);
                        window.validate();
                        String string = windowType.getTitle();
                        if (string == null) {
                            string = this._defaultTitle;
                        }
                        if (window instanceof Frame) {
                            ((Frame)window).setTitle(string);
                        } else if (window instanceof Dialog) {
                            ((Dialog)window).setTitle(string);
                        }
                    }
                } else if (window instanceof Frame) {
                    ((Frame)window).setTitle(this._defaultTitle);
                } else if (window instanceof Dialog) {
                    ((Dialog)window).setTitle(this._defaultTitle);
                }
            }
        }
    }

    public void dispose() {
        if (this._topicFrame != null) {
            this.disposeTopicFrame();
        }
        if (this._topicDialog != null) {
            this.disposeTopicDialog();
        }
        this._topicDisplay.removeDisplayListener(this);
        this._listeners = null;
        this._defaultTitle = null;
        this.clearDocumentStack();
        this._documentStack = null;
        this._menuBar.removeAll();
        this._menuBar = null;
        this._toolBar.removeAll();
        this._toolBar = null;
        this._manager = null;
        this._topicPanel.dispose();
        this._topicPanel = null;
        this._topicDisplay = null;
        this._frameListener = null;
        this._dialogListener = null;
        this.removeAll();
    }

    public void clear() {
        this._topicDisplay.clear();
    }

    public void clearDocumentStack() {
        this.clear();
        this._documentStack.clearStack();
        this._backButton.setEnabled(false);
        this._backItem.setEnabled(false);
        this._forwardButton.setEnabled(false);
        this._forwardItem.setEnabled(false);
    }

    public void displayTopic(Topic topic) throws TopicDisplayException {
        this._topicPanel.displayTopic(topic);
    }

    public TopicPrintJob getTopicPrintJob() {
        return this._topicPanel.getTopicPrintJob();
    }

    public void printDisplayedTopic() {
        TopicPrintJob topicPrintJob = this.getTopicPrintJob();
        URL uRL = this.getCurrentURL();
        if (uRL != null && topicPrintJob != null) {
            SimpleURLTarget simpleURLTarget = new SimpleURLTarget(null, uRL.toString());
            SimpleTopic simpleTopic = new SimpleTopic("", simpleURLTarget, null);
            topicPrintJob.printTopic(simpleTopic);
        }
    }

    public JPanel getDisplayContainer() {
        return this._topicPanel;
    }

    public URL getCurrentURL() {
        return this._topicPanel.getCurrentURL();
    }

    public void addDisplayListener(TopicDisplayListener topicDisplayListener) {
        this._topicPanel.addDisplayListener(topicDisplayListener);
    }

    public void removeDisplayListener(TopicDisplayListener topicDisplayListener) {
        this._topicPanel.removeDisplayListener(topicDisplayListener);
    }

    public void disposeTopicFrame() {
        if (this._topicFrame != null) {
            this._topicFrame.removeWindowListener(this._frameListener);
            ((Component)this._topicFrame).setVisible(false);
            this._topicFrame.remove(this);
            WindowUtils.unregisterWindow((Window)this._topicFrame);
            this._topicFrame.dispose();
            this._topicFrame = null;
        }
    }

    public void disposeTopicDialog() {
        if (this._topicDialog != null) {
            this._topicDialog.removeComponentListener(this._dialogListener);
            ((Component)this._topicDialog).setVisible(false);
            this._topicDialog.remove(this);
            WindowUtils.unregisterWindow((Window)this._topicDialog);
            this._topicDialog.dispose();
            this._topicDialog = null;
        }
    }

    public void dockTopicPanel() {
        if (this._manager != null && !this._currentlyDocked) {
            this._menuBar.setDockedState(true);
            this._dockButton.setSelected(true);
            this._toolBar.remove(this._navigatorButton);
            this._toolBar.remove(this._navSeparator);
            this._manager.dockTopicPanel(this);
            this._currentlyDocked = true;
        }
    }

    public void undockTopicPanel() {
        if (this._manager != null && this._currentlyDocked) {
            this._undockButton.setSelected(true);
            this._toolBar.add(this._navSeparator, 0);
            this._toolBar.add((Component)this._navigatorButton, 0);
            this._manager.undockTopicPanel();
            this._menuBar.setDockedState(false);
            this._currentlyDocked = false;
        }
    }

    public void reclaimTopicPanel() {
        Window window = this.getCurrentTopicWindow();
        if (window != null) {
            if (this._currentWindowType != null) {
                this._currentWindowType.setBounds(window.getBounds());
            }
            this._currentWindowType = null;
            if (window.isVisible()) {
                ((Component)window).setVisible(false);
            }
        }
        if (this._manager != null) {
            this._manager.reclaimTopicPanel(this);
        }
    }

    JMenu _getGoMenu() {
        return this._goMenu;
    }

    private void _setDialogState(boolean bl) {
        this._inDialogState = bl;
        if (this._inDialogState) {
            this._dockToolBarSeparator.setVisible(false);
            this._dockButton.setVisible(false);
            this._undockButton.setVisible(false);
        } else {
            this._dockToolBarSeparator.setVisible(true);
            this._dockButton.setVisible(true);
            this._undockButton.setVisible(true);
        }
        this._menuBar.setMenuDialogState(this._inDialogState);
    }

    public void runFindDialog() {
        this._topicDisplay.runFindDialog();
    }

    private void _loadImages() {
        try {
            _navImage = new ImageIcon(ImageLoader.loadImage(this.getClass(), "images/navigator.gif"));
            _larrowImage = new ImageIcon(ImageLoader.loadImage(this.getClass(), "images/leftarrow.gif"));
            _rarrowImage = new ImageIcon(ImageLoader.loadImage(this.getClass(), "images/rightarrow.gif"));
            _printImage = new ImageIcon(ImageLoader.loadImage(this.getClass(), "images/print.gif"));
            _dockImage = new ImageIcon(ImageLoader.loadImage(this.getClass(), "images/dock.gif"));
            _undockImage = new ImageIcon(ImageLoader.loadImage(this.getClass(), "images/undock.gif"));
        }
        catch (Exception exception) {
            System.err.println("DefaultTopicPanel:: Could not load toolbar images.");
        }
    }

    private class FrameTopicPanelReclaimer
    extends WindowAdapter {
        private FrameTopicPanelReclaimer() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            DefaultTopicPanel.this.reclaimTopicPanel();
        }
    }

    private class DialogTopicPanelReclaimer
    extends ComponentAdapter {
        private DialogTopicPanelReclaimer() {
        }

        public void componentHidden(ComponentEvent componentEvent) {
            if (componentEvent.getComponent() == DefaultTopicPanel.this.getCurrentTopicWindow()) {
                DefaultTopicPanel.this.reclaimTopicPanel();
            }
        }
    }

    private class TopicWindowMenuBar
    extends JMenuBar
    implements ActionListener {
        public TopicWindowMenuBar() {
            this._initMenuBar();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == DefaultTopicPanel.this._printItem) {
                try {
                    DefaultTopicPanel.this.printDisplayedTopic();
                }
                catch (Exception exception) {}
            } else if (actionEvent.getSource() == DefaultTopicPanel.this._closeItem) {
                DefaultTopicPanel.this.reclaimTopicPanel();
            } else if (actionEvent.getSource() == DefaultTopicPanel.this._exitItem) {
                if (DefaultTopicPanel.this._manager != null) {
                    DefaultTopicPanel.this._manager.hideAllWindows();
                } else {
                    DefaultTopicPanel.this.reclaimTopicPanel();
                }
            } else if (actionEvent.getSource() == DefaultTopicPanel.this._backItem) {
                DefaultTopicPanel.this._documentStack.goBack();
            } else if (actionEvent.getSource() == DefaultTopicPanel.this._forwardItem) {
                DefaultTopicPanel.this._documentStack.goForward();
            } else if (actionEvent.getSource() == DefaultTopicPanel.this._navigatorItem) {
                if (DefaultTopicPanel.this._manager != null) {
                    DefaultTopicPanel.this._manager.showNavigatorWindow();
                }
            } else if (actionEvent.getSource() == DefaultTopicPanel.this._findItem) {
                DefaultTopicPanel.this.runFindDialog();
            } else if (actionEvent.getSource() == DefaultTopicPanel.this._dockItem) {
                DefaultTopicPanel.this.dockTopicPanel();
            } else if (actionEvent.getSource() == DefaultTopicPanel.this._optionsItem) {
                // empty if block
            }
        }

        public void setDockedState(boolean bl) {
            if (bl) {
                DefaultTopicPanel.this._fileMenu.setVisible(false);
                DefaultTopicPanel.this._toolsMenu.setVisible(false);
                this.remove(DefaultTopicPanel.this._goMenu);
                this.add(DefaultTopicPanel.this._emptyItem);
            } else {
                this.remove(DefaultTopicPanel.this._emptyItem);
                this.remove(DefaultTopicPanel.this._toolsMenu);
                this.add(DefaultTopicPanel.this._goMenu);
                this.add(DefaultTopicPanel.this._toolsMenu);
                DefaultTopicPanel.this._fileMenu.setVisible(true);
                DefaultTopicPanel.this._toolsMenu.setVisible(true);
            }
            this.validate();
        }

        public void setMenuDialogState(boolean bl) {
            if (bl) {
                DefaultTopicPanel.this._toolsMenu.remove(DefaultTopicPanel.this._dockSeparator);
                DefaultTopicPanel.this._toolsMenu.remove(DefaultTopicPanel.this._dockItem);
            } else {
                DefaultTopicPanel.this._toolsMenu.add(DefaultTopicPanel.this._dockSeparator);
                DefaultTopicPanel.this._toolsMenu.add(DefaultTopicPanel.this._dockItem);
            }
            this.validate();
        }

        private void _initMenuBar() {
            this.add(this._createFileMenu());
            this.add(this._createGoMenu());
            this.add(this._createToolsMenu());
            DefaultTopicPanel.this._emptyItem = new JMenuItem(" ");
        }

        private JMenu _createFileMenu() {
            DefaultTopicPanel.this._fileMenu = new JMenu();
            String string = MenuUtils.getDefaultMenuLabel("menu.File");
            MenuUtils.setMenuAttributes(DefaultTopicPanel.this._fileMenu, string, false);
            String string2 = MenuUtils.getDefaultMenuLabel("menu.PrintTopic");
            DefaultTopicPanel.this._printItem = MenuUtils.createItem(string2, false);
            DefaultTopicPanel.this._printItem.addActionListener(this);
            DefaultTopicPanel.this._fileMenu.add(DefaultTopicPanel.this._printItem);
            DefaultTopicPanel.this._fileMenu.addSeparator();
            String string3 = MenuUtils.getDefaultMenuLabel("menu.Close");
            DefaultTopicPanel.this._closeItem = MenuUtils.createItem(string3, false);
            DefaultTopicPanel.this._closeItem.addActionListener(this);
            DefaultTopicPanel.this._fileMenu.add(DefaultTopicPanel.this._closeItem);
            String string4 = MenuUtils.getDefaultMenuLabel("menu.Exit");
            DefaultTopicPanel.this._exitItem = MenuUtils.createItem(string4, false);
            DefaultTopicPanel.this._exitItem.addActionListener(this);
            DefaultTopicPanel.this._fileMenu.add(DefaultTopicPanel.this._exitItem);
            DefaultTopicPanel.this._fileMenu.setEnabled(true);
            return DefaultTopicPanel.this._fileMenu;
        }

        private JMenu _createGoMenu() {
            DefaultTopicPanel.this._goMenu = new JMenu();
            String string = MenuUtils.getDefaultMenuLabel("menu.Go");
            MenuUtils.setMenuAttributes(DefaultTopicPanel.this._goMenu, string, false);
            String string2 = MenuUtils.getDefaultMenuLabel("menu.Back");
            DefaultTopicPanel.this._backItem = MenuUtils.createItem(string2, false);
            DefaultTopicPanel.this._backItem.addActionListener(this);
            DefaultTopicPanel.this._backItem.setEnabled(false);
            DefaultTopicPanel.this._goMenu.add(DefaultTopicPanel.this._backItem);
            String string3 = MenuUtils.getDefaultMenuLabel("menu.Forward");
            DefaultTopicPanel.this._forwardItem = MenuUtils.createItem(string3, false);
            DefaultTopicPanel.this._forwardItem.addActionListener(this);
            DefaultTopicPanel.this._forwardItem.setEnabled(false);
            DefaultTopicPanel.this._goMenu.add(DefaultTopicPanel.this._forwardItem);
            DefaultTopicPanel.this._goMenu.setEnabled(true);
            return DefaultTopicPanel.this._goMenu;
        }

        private JMenu _createToolsMenu() {
            DefaultTopicPanel.this._toolsMenu = new JMenu();
            String string = MenuUtils.getDefaultMenuLabel("menu.Tools");
            MenuUtils.setMenuAttributes(DefaultTopicPanel.this._toolsMenu, string, false);
            String string2 = MenuUtils.getDefaultMenuLabel("menu.Navigator");
            DefaultTopicPanel.this._navigatorItem = MenuUtils.createItem(string2, false);
            DefaultTopicPanel.this._navigatorItem.addActionListener(this);
            DefaultTopicPanel.this._toolsMenu.add(DefaultTopicPanel.this._navigatorItem);
            String string3 = MenuUtils.getDefaultMenuLabel("menu.Find");
            DefaultTopicPanel.this._findItem = MenuUtils.createItem(string3, false);
            DefaultTopicPanel.this._findItem.addActionListener(this);
            DefaultTopicPanel.this._toolsMenu.add(DefaultTopicPanel.this._findItem);
            DefaultTopicPanel.this._dockSeparator = new JPopupMenu.Separator();
            DefaultTopicPanel.this._toolsMenu.add(DefaultTopicPanel.this._dockSeparator);
            String string4 = MenuUtils.getDefaultMenuLabel("menu.Dock");
            DefaultTopicPanel.this._dockItem = MenuUtils.createItem(string4, false);
            DefaultTopicPanel.this._dockItem.addActionListener(this);
            DefaultTopicPanel.this._toolsMenu.add(DefaultTopicPanel.this._dockItem);
            String string5 = MenuUtils.getDefaultMenuLabel("menu.Preferences");
            DefaultTopicPanel.this._optionsItem = MenuUtils.createItem(string5, false);
            DefaultTopicPanel.this._optionsItem.addActionListener(this);
            DefaultTopicPanel.this._toolsMenu.setEnabled(true);
            return DefaultTopicPanel.this._toolsMenu;
        }
    }
}

