/*
 * Decompiled with CFR 0.152.
 */
package oracle.help;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.event.ListenerManager;
import oracle.help.DefaultTopicPanel;
import oracle.help.WindowManager;
import oracle.help.common.Topic;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.java.util.AboutBox;
import oracle.help.java.util.ImageLoader;
import oracle.help.java.util.MenuUtils;
import oracle.help.navigator.Navigator;
import oracle.help.navigator.NavigatorEvent;
import oracle.help.navigator.NavigatorListener;
import oracle.help.navigator.NavigatorTabPanel;
import oracle.help.navigator.NavigatorToolBar;
import oracle.help.navigator.SimpleNavigatorPanel;
import oracle.help.navigator.tocNavigator.TOCNavigator;

public class DefaultNavigatorPanel
extends JPanel
implements ActionListener,
NavigatorListener {
    private static String GENERIC_RESOURCE_BUNDLE = "oracle.help.resource.Generic";
    private static String MENU_RESOURCE_BUNDLE = "oracle.help.resource.MenuLabels";
    private static String NAVIGATOR_WINDOW_TITLE = "defaultNavigatorWindow.title";
    private static String VIEW_SELECT = "VIEW_SELECT";
    private NavigatorWindowMenuBar _menuBar;
    private SimpleNavigatorPanel _navPanel;
    private JSplitPane _splitter;
    private int _preferredDividerSize;
    private JFrame _navFrame;
    private JDialog _navDialog;
    private String _defaultTitle;
    private boolean _inDialogState;
    private boolean _hasDockedTopicPanel;
    private DefaultTopicPanel _dockedPanel;
    private WindowManager _manager;
    private FrameNavigatorPanelHider _frameListener = null;
    private DialogNavigatorPanelHider _dialogListener = null;
    private Rectangle _navigatorWindowBounds = null;
    private NavigatorToolBar _toolBar;
    private JButton _displayButton;
    private JButton _displayNewButton;
    private ListenerManager _listeners;
    private TabPanelChoiceModel _tabPanelModel;
    private TabPanelChoiceListener _choiceListener;
    private NavigatorTabPanel _activeTabPanel;
    private JComboBox _tabPanelChoice;
    private boolean _choiceAdded;
    private Component _choiceSeparator;
    private JMenu _fileMenu;
    private JPopupMenu _fileSubMenu;
    private JMenuItem _displayItem;
    private JMenuItem _displayNewItem;
    private JMenuItem _printTopicItem;
    private JMenuItem _printMultipleTopicsItem;
    private JMenuItem _printTreeItem;
    private JMenuItem _closeItem;
    private JMenuItem _exitItem;
    private JMenu _viewMenu;
    private JPopupMenu _viewSubMenu;
    private ButtonGroup _viewTabGroup;
    private JMenu _toolsMenu;
    private JMenuItem _undockItem;
    private JMenuItem _findItem;
    private JMenuItem _optionsItem;
    private JMenu _helpMenu;
    private JMenuItem _helpOnHelpItem;
    private JMenuItem _aboutItem;
    private JMenu _sharedGoMenu;
    private Topic _helpOnHelpTopic;

    public DefaultNavigatorPanel() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(GENERIC_RESOURCE_BUNDLE, StaticLocaleContext.getLocale());
        this._defaultTitle = resourceBundle.getString(NAVIGATOR_WINDOW_TITLE);
        this._listeners = new ListenerManager();
        this.setLayout(new BorderLayout());
        Color color = UIManager.getColor("darkLook");
        if (color != null) {
            this.setBackground(color);
        }
        this._helpOnHelpTopic = null;
        this._menuBar = new NavigatorWindowMenuBar();
        this._toolBar = new NavigatorToolBar();
        this.addNavigatorWindowListener(this._toolBar);
        Insets insets = new Insets(2, 2, 2, 2);
        this._tabPanelModel = new TabPanelChoiceModel();
        this._tabPanelChoice = new MinimumSizedComboBox(this._tabPanelModel);
        this._tabPanelChoice.setEditable(false);
        this._choiceListener = new TabPanelChoiceListener();
        this._tabPanelChoice.addItemListener(this._choiceListener);
        this._choiceAdded = false;
        ImageIcon imageIcon = new ImageIcon(ImageLoader.loadImage(this.getClass(), "images/display.gif"));
        this._displayButton = new JButton(imageIcon);
        this._displayButton.setMargin(insets);
        this._toolBar.addItem(this._displayButton, null, true);
        this._displayButton.addActionListener(this);
        ImageIcon imageIcon2 = new ImageIcon(ImageLoader.loadImage(this.getClass(), "images/diswin.gif"));
        this._displayNewButton = new JButton(imageIcon2);
        this._displayNewButton.setMargin(insets);
        this._toolBar.addItem(this._displayNewButton, null, true);
        this._displayNewButton.addActionListener(this);
        this._choiceSeparator = new JToolBar.Separator();
        String string = MenuUtils.removeSpecialMenuChars(MenuUtils.getDefaultMenuLabel("menu.Display"));
        this._displayButton.setToolTipText(string);
        String string2 = MenuUtils.removeSpecialMenuChars(MenuUtils.getDefaultMenuLabel("menu.Display_New"));
        this._displayNewButton.setToolTipText(string2);
        this._navFrame = null;
        this._navDialog = null;
        this._setDialogState(false);
        this._frameListener = new FrameNavigatorPanelHider();
        this._dialogListener = new DialogNavigatorPanelHider();
        this._navPanel = new SimpleNavigatorPanel(null, this._menuBar, this._toolBar);
        this._hasDockedTopicPanel = false;
        this._dockedPanel = null;
        this._manager = null;
        this._splitter = new JSplitPane(1);
        this._splitter.setLeftComponent(this._navPanel);
        this._preferredDividerSize = this._splitter.getDividerSize();
        this._splitter.setDividerSize(0);
        this.add((Component)this._splitter, "Center");
    }

    public JFrame createNavigatorFrame() {
        if (this._navDialog != null) {
            this.disposeNavigatorDialog();
        }
        if (this._navFrame == null) {
            this._navFrame = new JFrame();
            WindowUtils.registerWindow((Window)this._navFrame);
            if (ImageLoader.getIconImage() != null) {
                ((Frame)this._navFrame).setIconImage(ImageLoader.getIconImage());
            }
            this._navFrame.getContentPane().setLayout(new BorderLayout());
            this._navFrame.getContentPane().add((Component)this, "Center");
            this._navFrame.addWindowListener(this._frameListener);
            this._navFrame.setTitle(this._defaultTitle);
            if (this._navigatorWindowBounds == null) {
                ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.help.resource.Defaults", StaticLocaleContext.getLocale());
                int n = Integer.parseInt(resourceBundle.getString("navigator.width"));
                int n2 = Integer.parseInt(resourceBundle.getString("navigator.height"));
                ((Component)this._navFrame).setSize(n, n2);
                int n3 = Integer.parseInt(resourceBundle.getString("topicwin.width"));
                int n4 = Integer.parseInt(resourceBundle.getString("topicwin.height"));
                Toolkit toolkit = this._navFrame.getToolkit();
                Dimension dimension = toolkit.getScreenSize();
                int n5 = (dimension.width - (n + 20 + n3)) / 2;
                if (n5 < 0) {
                    n5 = 20;
                }
                WindowUtils.centerWindow((Window)this._navFrame);
                ((Component)this._navFrame).setLocation(n5, this._navFrame.getLocation().y);
            } else {
                ((Component)this._navFrame).setBounds(this._navigatorWindowBounds);
            }
        }
        return this._navFrame;
    }

    public JDialog createNavigatorDialog(Dialog dialog) {
        if (this._navFrame != null) {
            this.disposeNavigatorFrame();
        }
        if (this._navDialog != null && this._navDialog.getParent() != dialog) {
            this.disposeNavigatorDialog();
        }
        if (this._navDialog == null) {
            this._navDialog = new JDialog(dialog);
            WindowUtils.registerWindow((Window)this._navDialog);
            this._navDialog.getContentPane().setLayout(new BorderLayout());
            this._navDialog.getContentPane().add((Component)this, "Center");
            this._navDialog.addComponentListener(this._dialogListener);
            this._navDialog.setTitle(this._defaultTitle);
            if (this._navigatorWindowBounds == null) {
                ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.help.resource.Defaults", StaticLocaleContext.getLocale());
                int n = Integer.parseInt(resourceBundle.getString("navigator.width"));
                int n2 = Integer.parseInt(resourceBundle.getString("navigator.height"));
                ((Component)this._navDialog).setSize(n, n2);
                int n3 = Integer.parseInt(resourceBundle.getString("topicwin.width"));
                int n4 = Integer.parseInt(resourceBundle.getString("topicwin.height"));
                Toolkit toolkit = this._navDialog.getToolkit();
                Dimension dimension = toolkit.getScreenSize();
                int n5 = (dimension.width - (n + 20 + n3)) / 2;
                if (n5 < 0) {
                    n5 = 20;
                }
                WindowUtils.centerWindow((Window)this._navDialog);
                ((Component)this._navDialog).setLocation(n5, this._navDialog.getLocation().y);
            } else {
                ((Component)this._navDialog).setBounds(this._navigatorWindowBounds);
            }
        }
        return this._navDialog;
    }

    public Window getCurrentNavigatorWindow() {
        if (this._navFrame != null) {
            return this._navFrame;
        }
        if (this._navDialog != null) {
            return this._navDialog;
        }
        return null;
    }

    public void setWindowManager(WindowManager windowManager) {
        this._manager = windowManager;
    }

    public WindowManager getWindowManager() {
        return this._manager;
    }

    public void addNavigatorTabPanel(NavigatorTabPanel navigatorTabPanel, String string) {
        if (navigatorTabPanel != null) {
            this._tabPanelModel.addNavigatorTabPanel(navigatorTabPanel, string);
            navigatorTabPanel.addActiveNavigatorListener(this);
        }
        if (this._tabPanelModel.getSize() > 1) {
            if (!this._choiceAdded) {
                this._toolBar.addItem(this._tabPanelChoice, this._displayButton);
                this._toolBar.addItem(this._choiceSeparator, this._displayButton);
                this._choiceAdded = true;
            }
        } else if (this._tabPanelModel.getSize() == 1) {
            this._tabPanelChoice.setSelectedIndex(0);
        }
    }

    public void removeNavigatorTabPanel(NavigatorTabPanel navigatorTabPanel) {
        if (navigatorTabPanel != null) {
            this._tabPanelModel.removeNavigatorTabPanel(navigatorTabPanel);
            navigatorTabPanel.removeActiveNavigatorListener(this);
        }
        if (this._tabPanelModel.getSize() <= 1 && this._choiceAdded) {
            this._toolBar.removeItem(this._tabPanelChoice);
            this._toolBar.removeItem(this._choiceSeparator);
            this._choiceAdded = false;
        }
        if (navigatorTabPanel == this.getActiveNavigatorTabPanel()) {
            this._tabPanelChoice.setSelectedIndex(0);
        }
    }

    public void addNavigatorWindowListener(NavigatorListener navigatorListener) {
        if (navigatorListener != null) {
            this._listeners.addListener((EventListener)navigatorListener);
        }
    }

    public void removeNavigatorWindowListener(NavigatorListener navigatorListener) {
        if (navigatorListener != null) {
            this._listeners.removeListener((EventListener)navigatorListener);
        }
    }

    public NavigatorTabPanel getActiveNavigatorTabPanel() {
        return this._choiceListener.getActiveNavigatorTabPanel();
    }

    public NavigatorTabPanel[] getAllNavigatorTabPanels() {
        Object[] objectArray = null;
        Vector vector = this._tabPanelModel.getAllNavigatorTabPanels();
        if (vector != null) {
            objectArray = new NavigatorTabPanel[vector.size()];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    public Navigator getActiveNavigator() {
        Navigator navigator = null;
        NavigatorTabPanel navigatorTabPanel = this.getActiveNavigatorTabPanel();
        if (navigatorTabPanel != null) {
            navigator = navigatorTabPanel.getActiveNavigator();
        }
        return navigator;
    }

    public void setActiveNavigator(Navigator navigator) {
        if (navigator != null) {
            Vector vector = this._tabPanelModel.getAllNavigatorTabPanels();
            int n = 0;
            while (n < vector.size()) {
                Navigator[] navigatorArray;
                NavigatorTabPanel navigatorTabPanel = (NavigatorTabPanel)vector.elementAt(n);
                if (navigatorTabPanel != null && (navigatorArray = navigatorTabPanel.getNavigators()) != null) {
                    int n2 = 0;
                    while (n2 < navigatorArray.length) {
                        Navigator navigator2 = navigatorArray[n2];
                        if (navigator == navigator2) {
                            this._tabPanelChoice.setSelectedIndex(n);
                            navigatorTabPanel.setSelectedComponent(navigator2);
                            return;
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
    }

    public void setActiveNavigatorTabPanel(NavigatorTabPanel navigatorTabPanel) {
        if (navigatorTabPanel != null) {
            Vector vector = this._tabPanelModel.getAllNavigatorTabPanels();
            int n = 0;
            while (n < vector.size()) {
                NavigatorTabPanel navigatorTabPanel2 = (NavigatorTabPanel)vector.elementAt(n);
                if (navigatorTabPanel2 == navigatorTabPanel) {
                    this._tabPanelChoice.setSelectedIndex(n);
                    return;
                }
                ++n;
            }
        }
        this._tabPanelChoice.setSelectedIndex(0);
    }

    public Navigator[] getAllNavigators() {
        Object[] objectArray = null;
        Vector vector = this._tabPanelModel.getAllNavigators();
        if (vector != null) {
            objectArray = new Navigator[vector.size()];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    public void synchronizeNavigators(URL uRL) {
        Vector vector;
        if (uRL != null && (vector = this._tabPanelModel.getAllNavigators()) != null) {
            int n = 0;
            while (n < vector.size()) {
                Navigator navigator = (Navigator)vector.elementAt(n);
                if (navigator instanceof TOCNavigator) {
                    TOCNavigator tOCNavigator = (TOCNavigator)navigator;
                    tOCNavigator.selectMatchingTopic(uRL);
                }
                ++n;
            }
        }
    }

    public void setHelpOnHelpTopic(Topic topic) {
        this._helpOnHelpTopic = null;
        if (topic != null && topic.hasTarget()) {
            this._helpOnHelpTopic = topic;
        }
        if (this._helpOnHelpTopic == null) {
            this._menuBar.setHelpOnHelpVisible(false);
        } else {
            this._menuBar.setHelpOnHelpVisible(true);
        }
    }

    public void dockTopicPanel(DefaultTopicPanel defaultTopicPanel) {
        Window window = this.getCurrentNavigatorWindow();
        if (defaultTopicPanel != null && window != null) {
            int n;
            if (this.hasDockedTopicPanel()) {
                this.undockTopicPanel();
            }
            Dimension dimension = window.getSize();
            Dimension dimension2 = this._navPanel.getSize();
            Dimension dimension3 = defaultTopicPanel.getSize();
            try {
                ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.help.resource.Defaults", StaticLocaleContext.getLocale());
                n = Integer.parseInt(resourceBundle.getString("topicwin.width"));
                int n2 = Integer.parseInt(resourceBundle.getString("topicwin.height"));
                if (dimension2.width == 0) {
                    dimension2.width = dimension.width - 8;
                }
                if (dimension2.height == 0) {
                    dimension2.height = dimension.height - 27;
                }
                if (dimension3.width == 0) {
                    dimension3.width = n - 8;
                }
                if (dimension3.height == 0) {
                    dimension3.height = n2 - 27;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._splitter.setDividerSize(this._preferredDividerSize);
            this._splitter.setRightComponent(defaultTopicPanel);
            this._dockedPanel = defaultTopicPanel;
            this._hasDockedTopicPanel = true;
            int n3 = dimension.width + this._preferredDividerSize + dimension3.width;
            n = dimension3.height + (dimension.height - dimension2.height);
            if (dimension.height > n) {
                n = dimension.height;
            }
            ((Component)window).setSize(n3, n);
            window.validate();
            this._splitter.setDividerLocation(dimension2.width + 1);
            this._menuBar.setDockedState(true);
        }
    }

    public DefaultTopicPanel undockTopicPanel() {
        DefaultTopicPanel defaultTopicPanel = this._dockedPanel;
        if (this.hasDockedTopicPanel()) {
            Dimension dimension = this._dockedPanel.getSize();
            this._splitter.remove(this._dockedPanel);
            this._splitter.setDividerSize(0);
            Window window = this.getCurrentNavigatorWindow();
            if (window != null) {
                Dimension dimension2 = window.getSize();
                ((Component)window).setSize(dimension2.width - (dimension.width + this._preferredDividerSize), dimension2.height);
                window.validate();
            }
            this._dockedPanel = null;
            this._hasDockedTopicPanel = false;
            this._menuBar.setDockedState(false);
        }
        return defaultTopicPanel;
    }

    public boolean hasDockedTopicPanel() {
        return this._hasDockedTopicPanel;
    }

    public void hideNavigatorWindow() {
        Window window = this.getCurrentNavigatorWindow();
        if (window != null && window.isVisible()) {
            ((Component)window).setVisible(false);
        }
        if (this._manager != null) {
            this._manager.hideNavigatorWindow();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Topic topic;
        Navigator navigator;
        if (actionEvent != null && (navigator = this.getActiveNavigator()) != null && (topic = navigator.getCurrentSelection()) != null) {
            if (actionEvent.getSource() == this._displayButton) {
                this._fireNavigatorEvent(new NavigatorEvent(this, 2001, topic, 1));
            } else if (actionEvent.getSource() == this._displayNewButton) {
                this._fireNavigatorEvent(new NavigatorEvent(this, 2001, topic, 2));
            }
        }
    }

    public void topicSelected(NavigatorEvent navigatorEvent) {
        if (navigatorEvent != null && (navigatorEvent.getSource() == this.getActiveNavigatorTabPanel() || navigatorEvent.getSource() == this.getActiveNavigator())) {
            this._fireNavigatorEvent(navigatorEvent);
        }
    }

    public void topicActivated(NavigatorEvent navigatorEvent) {
        if (navigatorEvent != null && (navigatorEvent.getSource() == this.getActiveNavigatorTabPanel() || navigatorEvent.getSource() == this.getActiveNavigator())) {
            this._fireNavigatorEvent(navigatorEvent);
        }
    }

    public void dispose() {
        if (this._navFrame != null) {
            this.disposeNavigatorFrame();
        }
        if (this._navDialog != null) {
            this.disposeNavigatorDialog();
        }
        this.removeNavigatorWindowListener(this._toolBar);
        this._dialogListener = null;
        this._frameListener = null;
        this._tabPanelChoice.removeItemListener(this._choiceListener);
        this._tabPanelChoice.removeAll();
        this._tabPanelChoice = null;
        this._choiceListener = null;
        this._choiceSeparator = null;
        this._tabPanelModel = null;
        this._activeTabPanel = null;
        this._defaultTitle = null;
        this._listeners = null;
        this._menuBar.removeAll();
        this._menuBar = null;
        this._toolBar.removeAll();
        this._toolBar = null;
        this._navPanel.removeAll();
        this._navPanel = null;
        this._dockedPanel = null;
        this._splitter.removeAll();
        this._splitter = null;
        this._manager = null;
        this.removeAll();
    }

    public void disposeNavigatorFrame() {
        if (this._navFrame != null) {
            this._navFrame.removeWindowListener(this._frameListener);
            ((Component)this._navFrame).setVisible(false);
            this._navigatorWindowBounds = this._navFrame.getBounds();
            this._navFrame.remove(this);
            WindowUtils.unregisterWindow((Window)this._navFrame);
            this._navFrame.dispose();
            this._navFrame = null;
        }
    }

    public void disposeNavigatorDialog() {
        if (this._navDialog != null) {
            this._navDialog.removeComponentListener(this._dialogListener);
            ((Component)this._navDialog).setVisible(false);
            this._navigatorWindowBounds = this._navDialog.getBounds();
            this._navDialog.remove(this);
            WindowUtils.unregisterWindow((Window)this._navDialog);
            this._navDialog.dispose();
            this._navDialog = null;
        }
    }

    private void _setDialogState(boolean bl) {
        this._inDialogState = bl;
        if (this._inDialogState) {
            this._toolBar.enableItemBasedOnSelection(false, this._displayNewButton);
            this._displayNewButton.setEnabled(false);
        } else {
            this._toolBar.enableItemBasedOnSelection(true, this._displayNewButton);
        }
    }

    private void _fireNavigatorEvent(NavigatorEvent navigatorEvent) {
        Enumeration enumeration = this._listeners.getListeners();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                NavigatorListener navigatorListener = (NavigatorListener)enumeration.nextElement();
                if (navigatorEvent.getID() == 2000) {
                    navigatorListener.topicSelected(navigatorEvent);
                    continue;
                }
                navigatorListener.topicActivated(navigatorEvent);
            }
        }
    }

    private class FrameNavigatorPanelHider
    extends WindowAdapter {
        private FrameNavigatorPanelHider() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            DefaultNavigatorPanel.this.hideNavigatorWindow();
        }
    }

    private class DialogNavigatorPanelHider
    extends ComponentAdapter {
        private DialogNavigatorPanelHider() {
        }

        public void componentHidden(ComponentEvent componentEvent) {
            if (componentEvent.getComponent() == DefaultNavigatorPanel.this.getCurrentNavigatorWindow()) {
                DefaultNavigatorPanel.this.hideNavigatorWindow();
            }
        }
    }

    private class NavigatorWindowMenuBar
    extends JMenuBar
    implements ActionListener,
    PopupMenuListener {
        public NavigatorWindowMenuBar() {
            this._initMenuBar();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NavigatorTabPanel navigatorTabPanel = DefaultNavigatorPanel.this.getActiveNavigatorTabPanel();
            Navigator navigator = DefaultNavigatorPanel.this.getActiveNavigator();
            Topic topic = null;
            if (navigator != null) {
                topic = navigator.getCurrentSelection();
            }
            if (actionEvent.getSource() == DefaultNavigatorPanel.this._displayItem) {
                if (topic != null) {
                    DefaultNavigatorPanel.this._fireNavigatorEvent(new NavigatorEvent(this, 2001, topic, 1));
                }
            } else if (actionEvent.getSource() == DefaultNavigatorPanel.this._displayNewItem) {
                if (topic != null) {
                    DefaultNavigatorPanel.this._fireNavigatorEvent(new NavigatorEvent(this, 2001, topic, 2));
                }
            } else if (actionEvent.getSource() == DefaultNavigatorPanel.this._printTopicItem) {
                if (DefaultNavigatorPanel.this._dockedPanel != null) {
                    DefaultNavigatorPanel.this._dockedPanel.printDisplayedTopic();
                }
            } else if (actionEvent.getSource() == DefaultNavigatorPanel.this._printTreeItem) {
                if (navigator != null && navigator instanceof TOCNavigator) {
                    TOCNavigator tOCNavigator = (TOCNavigator)DefaultNavigatorPanel.this.getActiveNavigator();
                    tOCNavigator.printNavigator();
                }
            } else if (actionEvent.getSource() == DefaultNavigatorPanel.this._printMultipleTopicsItem) {
                TOCNavigator tOCNavigator;
                TopicTreeNode topicTreeNode;
                if (navigator != null && navigator instanceof TOCNavigator && (topicTreeNode = (tOCNavigator = (TOCNavigator)DefaultNavigatorPanel.this.getActiveNavigator()).getCurrentSelectionNode()) != null && DefaultNavigatorPanel.this._manager != null) {
                    DefaultNavigatorPanel.this._manager.printTopics(topicTreeNode.getAllTopicsInSubTree());
                }
            } else if (actionEvent.getSource() == DefaultNavigatorPanel.this._closeItem) {
                DefaultNavigatorPanel.this.hideNavigatorWindow();
            } else if (actionEvent.getSource() == DefaultNavigatorPanel.this._exitItem) {
                if (DefaultNavigatorPanel.this._manager != null) {
                    DefaultNavigatorPanel.this._manager.hideAllWindows();
                } else {
                    DefaultNavigatorPanel.this.hideNavigatorWindow();
                }
            } else if (actionEvent.getSource() == DefaultNavigatorPanel.this._aboutItem) {
                AboutBox aboutBox = new AboutBox(WindowUtils.parentFrame((Component)this));
                ((Component)aboutBox).setVisible(true);
            } else if (actionEvent.getSource() == DefaultNavigatorPanel.this._undockItem) {
                if (DefaultNavigatorPanel.this._dockedPanel != null) {
                    DefaultNavigatorPanel.this._dockedPanel.undockTopicPanel();
                }
            } else if (actionEvent.getSource() == DefaultNavigatorPanel.this._findItem) {
                DefaultNavigatorPanel.this._dockedPanel.runFindDialog();
            } else if (actionEvent.getSource() == DefaultNavigatorPanel.this._helpOnHelpItem) {
                if (DefaultNavigatorPanel.this._helpOnHelpTopic != null) {
                    DefaultNavigatorPanel.this._fireNavigatorEvent(new NavigatorEvent(this, 2001, DefaultNavigatorPanel.this._helpOnHelpTopic, 2));
                }
            } else if (VIEW_SELECT.equals(actionEvent.getActionCommand())) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                if (navigatorTabPanel != null) {
                    int n = 0;
                    while (n < navigatorTabPanel.getTabCount()) {
                        String string = navigatorTabPanel.getTitleAt(n);
                        if (string != null && string.equals(jMenuItem.getText())) {
                            navigatorTabPanel.setSelectedIndex(n);
                            break;
                        }
                        ++n;
                    }
                }
            }
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            NavigatorTabPanel navigatorTabPanel = DefaultNavigatorPanel.this.getActiveNavigatorTabPanel();
            Navigator navigator = DefaultNavigatorPanel.this.getActiveNavigator();
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            if (navigator != null) {
                Topic topic;
                if (navigator instanceof TOCNavigator) {
                    bl = true;
                }
                if ((topic = navigator.getCurrentSelection()) != null) {
                    bl2 = true;
                    if (topic.hasTarget()) {
                        bl3 = true;
                    }
                }
            }
            if (popupMenuEvent.getSource() == DefaultNavigatorPanel.this._fileSubMenu) {
                DefaultNavigatorPanel.this._displayItem.setEnabled(bl3);
                DefaultNavigatorPanel.this._displayNewItem.setEnabled(bl3 && !DefaultNavigatorPanel.this._inDialogState);
                DefaultNavigatorPanel.this._printTreeItem.setEnabled(bl);
                DefaultNavigatorPanel.this._printMultipleTopicsItem.setEnabled(bl && bl2);
            }
            if (popupMenuEvent.getSource() == DefaultNavigatorPanel.this._viewSubMenu) {
                DefaultNavigatorPanel.this._viewTabGroup = new ButtonGroup();
                DefaultNavigatorPanel.this._viewMenu.removeAll();
                if (navigatorTabPanel != null) {
                    int n = 0;
                    while (n < navigatorTabPanel.getTabCount()) {
                        boolean bl4;
                        String string = navigatorTabPanel.getTitleAt(n);
                        boolean bl5 = bl4 = navigatorTabPanel.getSelectedIndex() == n;
                        if (string != null) {
                            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string, bl4);
                            DefaultNavigatorPanel.this._viewTabGroup.add(jRadioButtonMenuItem);
                            jRadioButtonMenuItem.setActionCommand(VIEW_SELECT);
                            jRadioButtonMenuItem.addActionListener(this);
                            DefaultNavigatorPanel.this._viewMenu.add(jRadioButtonMenuItem);
                        }
                        ++n;
                    }
                }
            }
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        public void setDockedState(boolean bl) {
            if (bl) {
                DefaultNavigatorPanel.this._sharedGoMenu = DefaultNavigatorPanel.this._dockedPanel._getGoMenu();
                this.remove(DefaultNavigatorPanel.this._helpMenu);
                this.add(DefaultNavigatorPanel.this._sharedGoMenu);
                DefaultNavigatorPanel.this._toolsMenu.removeAll();
                if (!DefaultNavigatorPanel.this._inDialogState) {
                    DefaultNavigatorPanel.this._toolsMenu.add(DefaultNavigatorPanel.this._undockItem);
                }
                DefaultNavigatorPanel.this._toolsMenu.add(DefaultNavigatorPanel.this._findItem);
                this.add(DefaultNavigatorPanel.this._toolsMenu);
                this.add(DefaultNavigatorPanel.this._helpMenu);
                int n = 0;
                n = 0;
                while (n < DefaultNavigatorPanel.this._fileMenu.getItemCount()) {
                    if (DefaultNavigatorPanel.this._fileMenu.getItem(n) == DefaultNavigatorPanel.this._printTreeItem) break;
                    ++n;
                }
                DefaultNavigatorPanel.this._fileMenu.insert(DefaultNavigatorPanel.this._printTopicItem, n + 1);
            } else {
                this.remove(DefaultNavigatorPanel.this._sharedGoMenu);
                this.remove(DefaultNavigatorPanel.this._toolsMenu);
                DefaultNavigatorPanel.this._fileMenu.remove(DefaultNavigatorPanel.this._printTopicItem);
            }
            this.validate();
        }

        public void setHelpOnHelpVisible(boolean bl) {
            if (bl) {
                if (DefaultNavigatorPanel.this._helpOnHelpItem.getParent() == null) {
                    DefaultNavigatorPanel.this._helpMenu.insert(DefaultNavigatorPanel.this._helpOnHelpItem, 0);
                }
            } else if (DefaultNavigatorPanel.this._helpOnHelpItem.getParent() == DefaultNavigatorPanel.this._helpMenu) {
                DefaultNavigatorPanel.this._helpMenu.remove(DefaultNavigatorPanel.this._helpOnHelpItem);
            }
        }

        private void _initMenuBar() {
            this.add(this._createFileMenu());
            this.add(this._createViewMenu());
            this.add(this._createHelpMenu());
            this._createToolsMenu();
            DefaultNavigatorPanel.this._sharedGoMenu = null;
        }

        private JMenu _createFileMenu() {
            DefaultNavigatorPanel.this._fileMenu = new JMenu();
            DefaultNavigatorPanel.this._fileSubMenu = DefaultNavigatorPanel.this._fileMenu.getPopupMenu();
            DefaultNavigatorPanel.this._fileSubMenu.addPopupMenuListener(this);
            String string = MenuUtils.getDefaultMenuLabel("menu.File");
            MenuUtils.setMenuAttributes(DefaultNavigatorPanel.this._fileMenu, string, false);
            String string2 = MenuUtils.getDefaultMenuLabel("menu.Display");
            DefaultNavigatorPanel.this._displayItem = MenuUtils.createItem(string2, false);
            DefaultNavigatorPanel.this._displayItem.addActionListener(this);
            DefaultNavigatorPanel.this._fileMenu.add(DefaultNavigatorPanel.this._displayItem);
            String string3 = MenuUtils.getDefaultMenuLabel("menu.Display_New");
            DefaultNavigatorPanel.this._displayNewItem = MenuUtils.createItem(string3, false);
            DefaultNavigatorPanel.this._displayNewItem.addActionListener(this);
            DefaultNavigatorPanel.this._fileMenu.add(DefaultNavigatorPanel.this._displayNewItem);
            DefaultNavigatorPanel.this._fileMenu.addSeparator();
            String string4 = MenuUtils.getDefaultMenuLabel("menu.PrintTree");
            DefaultNavigatorPanel.this._printTreeItem = MenuUtils.createItem(string4, false);
            DefaultNavigatorPanel.this._printTreeItem.addActionListener(this);
            DefaultNavigatorPanel.this._fileMenu.add(DefaultNavigatorPanel.this._printTreeItem);
            String string5 = MenuUtils.getDefaultMenuLabel("menu.PrintTopic");
            DefaultNavigatorPanel.this._printTopicItem = MenuUtils.createItem(string5, false);
            DefaultNavigatorPanel.this._printTopicItem.addActionListener(this);
            String string6 = MenuUtils.getDefaultMenuLabel("menu.PrintTopics");
            DefaultNavigatorPanel.this._printMultipleTopicsItem = MenuUtils.createItem(string6, false);
            DefaultNavigatorPanel.this._printMultipleTopicsItem.addActionListener(this);
            DefaultNavigatorPanel.this._fileMenu.add(DefaultNavigatorPanel.this._printMultipleTopicsItem);
            DefaultNavigatorPanel.this._fileMenu.addSeparator();
            String string7 = MenuUtils.getDefaultMenuLabel("menu.Close");
            DefaultNavigatorPanel.this._closeItem = MenuUtils.createItem(string7, false);
            DefaultNavigatorPanel.this._closeItem.addActionListener(this);
            DefaultNavigatorPanel.this._fileMenu.add(DefaultNavigatorPanel.this._closeItem);
            String string8 = MenuUtils.getDefaultMenuLabel("menu.Exit");
            DefaultNavigatorPanel.this._exitItem = MenuUtils.createItem(string8, false);
            DefaultNavigatorPanel.this._exitItem.addActionListener(this);
            DefaultNavigatorPanel.this._fileMenu.add(DefaultNavigatorPanel.this._exitItem);
            DefaultNavigatorPanel.this._fileMenu.setEnabled(true);
            return DefaultNavigatorPanel.this._fileMenu;
        }

        private JMenu _createViewMenu() {
            DefaultNavigatorPanel.this._viewMenu = new JMenu();
            DefaultNavigatorPanel.this._viewSubMenu = DefaultNavigatorPanel.this._viewMenu.getPopupMenu();
            DefaultNavigatorPanel.this._viewSubMenu.addPopupMenuListener(this);
            String string = MenuUtils.getDefaultMenuLabel("menu.View");
            MenuUtils.setMenuAttributes(DefaultNavigatorPanel.this._viewMenu, string, false);
            DefaultNavigatorPanel.this._viewMenu.setEnabled(true);
            return DefaultNavigatorPanel.this._viewMenu;
        }

        private JMenu _createToolsMenu() {
            DefaultNavigatorPanel.this._toolsMenu = new JMenu();
            String string = MenuUtils.getDefaultMenuLabel("menu.Tools");
            MenuUtils.setMenuAttributes(DefaultNavigatorPanel.this._toolsMenu, string, false);
            String string2 = MenuUtils.getDefaultMenuLabel("menu.Undock");
            DefaultNavigatorPanel.this._undockItem = MenuUtils.createItem(string2, false);
            DefaultNavigatorPanel.this._undockItem.addActionListener(this);
            DefaultNavigatorPanel.this._toolsMenu.add(DefaultNavigatorPanel.this._undockItem);
            String string3 = MenuUtils.getDefaultMenuLabel("menu.Find");
            DefaultNavigatorPanel.this._findItem = MenuUtils.createItem(string3, false);
            DefaultNavigatorPanel.this._findItem.addActionListener(this);
            DefaultNavigatorPanel.this._toolsMenu.add(DefaultNavigatorPanel.this._findItem);
            String string4 = MenuUtils.getDefaultMenuLabel("menu.Preferences");
            DefaultNavigatorPanel.this._optionsItem = MenuUtils.createItem(string4, false);
            DefaultNavigatorPanel.this._optionsItem.addActionListener(this);
            DefaultNavigatorPanel.this._toolsMenu.setEnabled(true);
            return DefaultNavigatorPanel.this._toolsMenu;
        }

        private JMenu _createHelpMenu() {
            DefaultNavigatorPanel.this._helpMenu = new JMenu();
            String string = MenuUtils.getDefaultMenuLabel("menu.Help");
            MenuUtils.setMenuAttributes(DefaultNavigatorPanel.this._helpMenu, string, false);
            String string2 = MenuUtils.getDefaultMenuLabel("menu.HelpOnHelp");
            DefaultNavigatorPanel.this._helpOnHelpItem = MenuUtils.createItem(string2, false);
            DefaultNavigatorPanel.this._helpOnHelpItem.addActionListener(this);
            String string3 = MenuUtils.getDefaultMenuLabel("menu.About");
            DefaultNavigatorPanel.this._aboutItem = MenuUtils.createItem(string3, false);
            DefaultNavigatorPanel.this._aboutItem.addActionListener(this);
            DefaultNavigatorPanel.this._helpMenu.add(DefaultNavigatorPanel.this._aboutItem);
            DefaultNavigatorPanel.this._helpMenu.setEnabled(true);
            return DefaultNavigatorPanel.this._helpMenu;
        }
    }

    private class TabPanelChoiceListener
    implements ItemListener {
        private NavigatorTabPanel _activeTabPanel = null;

        TabPanelChoiceListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent != null && itemEvent.getStateChange() == 1) {
                int n = DefaultNavigatorPanel.this._tabPanelChoice.getSelectedIndex();
                this._selectImpl(n);
            }
        }

        public NavigatorTabPanel getActiveNavigatorTabPanel() {
            return this._activeTabPanel;
        }

        private void _selectImpl(int n) {
            this._activeTabPanel = DefaultNavigatorPanel.this._tabPanelModel.getTabPanel(n);
            DefaultNavigatorPanel.this._navPanel.setTabPanel(this._activeTabPanel);
            Navigator navigator = null;
            if (this._activeTabPanel != null) {
                navigator = this._activeTabPanel.getActiveNavigator();
            }
            if (navigator != null) {
                DefaultNavigatorPanel.this._fireNavigatorEvent(new NavigatorEvent(navigator, 2000, navigator.getCurrentSelection()));
            } else {
                DefaultNavigatorPanel.this._fireNavigatorEvent(new NavigatorEvent(this, 2000, null));
            }
        }
    }

    private class TabPanelChoiceModel
    extends DefaultComboBoxModel {
        public NavigatorTabPanel getTabPanel(int n) {
            NavigatorTabPanel navigatorTabPanel = null;
            try {
                TabPanelInfo tabPanelInfo = (TabPanelInfo)this.getElementAt(n);
                if (tabPanelInfo != null) {
                    navigatorTabPanel = tabPanelInfo.tabPanel;
                }
            }
            catch (Exception exception) {
                navigatorTabPanel = null;
            }
            return navigatorTabPanel;
        }

        public synchronized void addNavigatorTabPanel(NavigatorTabPanel navigatorTabPanel, String string) {
            TabPanelInfo tabPanelInfo = new TabPanelInfo(navigatorTabPanel, string);
            this.addElement(tabPanelInfo);
        }

        public synchronized void removeNavigatorTabPanel(NavigatorTabPanel navigatorTabPanel) {
            int n = this.getSize() - 1;
            while (n >= 0) {
                TabPanelInfo tabPanelInfo = (TabPanelInfo)this.getElementAt(n);
                if (tabPanelInfo.tabPanel == navigatorTabPanel) {
                    this.removeElement(tabPanelInfo);
                }
                --n;
            }
        }

        public synchronized Vector getAllNavigatorTabPanels() {
            Vector<NavigatorTabPanel> vector = new Vector<NavigatorTabPanel>();
            int n = 0;
            while (n < this.getSize()) {
                TabPanelInfo tabPanelInfo = (TabPanelInfo)this.getElementAt(n);
                if (tabPanelInfo != null) {
                    vector.addElement(tabPanelInfo.tabPanel);
                }
                ++n;
            }
            return vector;
        }

        public synchronized Vector getAllNavigators() {
            Vector<Navigator> vector = new Vector<Navigator>();
            int n = 0;
            while (n < this.getSize()) {
                Navigator[] navigatorArray;
                TabPanelInfo tabPanelInfo = (TabPanelInfo)this.getElementAt(n);
                if (tabPanelInfo.tabPanel != null && (navigatorArray = tabPanelInfo.tabPanel.getNavigators()) != null) {
                    int n2 = 0;
                    while (n2 < navigatorArray.length) {
                        vector.addElement(navigatorArray[n2]);
                        ++n2;
                    }
                }
                ++n;
            }
            return vector;
        }

        private class TabPanelInfo {
            public NavigatorTabPanel tabPanel = null;
            public String title = null;

            public TabPanelInfo(NavigatorTabPanel navigatorTabPanel, String string) {
                this.tabPanel = navigatorTabPanel;
                this.title = string;
            }

            public String toString() {
                return this.title;
            }
        }
    }

    private class MinimumSizedComboBox
    extends JComboBox {
        public MinimumSizedComboBox(ComboBoxModel comboBoxModel) {
            super(comboBoxModel);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }
}

