/*
 * Decompiled with CFR 0.152.
 */
package oracle.help;

import java.applet.AppletContext;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import oracle.help.DefaultNavigatorPanel;
import oracle.help.WindowManager;
import oracle.help.common.Topic;
import oracle.help.htmlBrowser.NativeBrowser;
import oracle.help.library.Library;
import oracle.help.topicDisplay.BrowserTopicDisplay;
import oracle.help.topicDisplay.TopicDisplayException;

public class AppletWindowManager
implements WindowManager {
    private DefaultNavigatorPanel _navigatorPanel;
    private AppletContext _appletContext;
    private BrowserTopicDisplay _nativeBrowserDisplay;
    private Library _library;

    public AppletWindowManager(AppletContext appletContext, String string, DefaultNavigatorPanel defaultNavigatorPanel, Library library) {
        this._appletContext = appletContext;
        this._navigatorPanel = defaultNavigatorPanel;
        this._navigatorPanel.setWindowManager(this);
        this._library = library;
        try {
            NativeBrowser nativeBrowser = new NativeBrowser(appletContext, string);
            this._nativeBrowserDisplay = new BrowserTopicDisplay(nativeBrowser, this._library);
        }
        catch (Exception exception) {
            System.err.println("Failed to create AppletContext based TopicDisplay");
            this._nativeBrowserDisplay = null;
        }
    }

    public void displayTopic(Topic topic, boolean bl, Point point, Dimension dimension) throws TopicDisplayException {
        if (this._nativeBrowserDisplay != null) {
            this._nativeBrowserDisplay.displayTopic(topic);
        }
    }

    public AppletContext getAppletContext() {
        return this._appletContext;
    }

    public void showNavigatorWindow() {
        Window window = this._navigatorPanel.getCurrentNavigatorWindow();
        if (window == null) {
            window = this._navigatorPanel.createNavigatorFrame();
        }
        ((Component)window).setVisible(true);
        this._ensureNotMinimized(window);
        window.toFront();
    }

    public void hideNavigatorWindow() {
        Window window = this._navigatorPanel.getCurrentNavigatorWindow();
        if (window != null) {
            ((Component)window).setVisible(false);
        }
    }

    public void hideAllWindows() {
        this.hideNavigatorWindow();
    }

    public boolean isNewWindowSupported() {
        return false;
    }

    public boolean isPrintingSupported() {
        return false;
    }

    public void printTopics(Topic[] topicArray) {
    }

    public synchronized void dispose() {
        this._navigatorPanel.dispose();
        this._nativeBrowserDisplay.dispose();
        this._appletContext = null;
    }

    private void _ensureNotMinimized(Window window) {
        Frame frame;
        if (window instanceof Frame && (frame = (Frame)window).getState() == 1) {
            frame.setState(0);
        }
    }
}

