package export;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;


public class ExportDataTool {
	
	public static final String ipValid = "^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){2}([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$|^([1-9]|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){2}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$|^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])){2}$|^(\\d|[1-9]\\d|1[013-9]\\d|12[0-689]|2[01]\\d|22[0-3])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.([1-9]|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$" ;
	
	private File[] files ;
	private String directoryPath;
	private List<String> ipList = new ArrayList<String>(); 
	private HashMap<String, List< File >> fileMap = new HashMap<String, List< File >>();
	
	private final String prefix = "aggregated";
	
	public ExportDataTool()
	{	
		System.out.println();
		getDirectoryPath();
		getIpList();

		if (ipList.isEmpty()){
			System.out.println("No available files");
		}
		else
		{
			getFileMap();
			for (String ipIterator : ipList){
				createIpFile(ipIterator);
			}
		}
		System.out.println();
	}
	
	private void getDirectoryPath() {
		JFileChooser fileChooser = new JFileChooser();
		fileChooser.setFileFilter(new FileFilter() {

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return false;
            }
            @Override
            public String getDescription() {
                return "Directories";
            }

        });
		fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileHidingEnabled(true);
        fileChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        fileChooser.setAcceptAllFileFilterUsed(false);
        if ( fileChooser.showOpenDialog( null ) == fileChooser.APPROVE_OPTION ){
				files = fileChooser.getSelectedFile().listFiles();
				directoryPath = fileChooser.getSelectedFile().getAbsolutePath();
				}else{
					System.out.println("No directory selected");
					System.exit( 0 );
				}
	}
	

	private void createIpFile( String ip ) {
		
		File file = new File( directoryPath + "\\" + prefix + "_" + ip + ".csv");
		try{
			file.createNewFile();
			CSVWriter writer = new CSVWriter(new FileWriter(file));
			writer.writeNext( new String[]{"Timestamp", "SU_NAME","SU_MAC","AU Id","SU Uplink SNR","SU Downlink SNR",
					"SU Uplink RSSI", "SU Downlink RSSI", "SU Uplink Rate", "SU Downlink Rate", "SU Tx Power"	});
			for (File fileIterator : fileMap.get(ip))
			{	
				aggregateFile(fileIterator, writer);
			}
			writer.close();
			System.out.println("Created file: " + file.getName());
			
		}catch (IOException e) {
			System.out.println( e.getMessage() );
		}
	}

	private void aggregateFile(File file, CSVWriter writer) {
		try{
			CSVReader reader = new CSVReader(new FileReader(file));
			String suName = getNameFromFile(file.getName());
			int[] index = new int[10];
			String[] header = reader.readNext();
			
			for (int i = 0 ; i<header.length; i++){
				if (header[i].equals("Timestamp"))
					index[0] = i;
				if (header[i].equals("SU_MAC"))
					index[1] = i;
				if (header[i].equals("AU Id"))
					index[2] = i;
				if (header[i].equals("SU Uplink SNR"))
					index[3] = i;
				if (header[i].equals("SU Downlink SNR"))
					index[4] = i;
				if (header[i].equals("SU Uplink RSSI"))
					index[5] = i;
				if (header[i].equals("SU Downlink RSSI"))
					index[6] = i;
				if (header[i].equals("SU Uplink Rate"))
					index[7] = i;
				if (header[i].equals("SU Downlink Rate"))
					index[8] = i;
				if (header[i].equals("SU Tx Power"))
					index[9] = i;
			}
			
			// if any counter is unavailable it will be given the -1 index and it will write in the file an empty string
			for (int i = 2 ; i < 10; i++){
				if ( index [i] == 0 )
					index [i] = -1;
			}
			
			String[] line = reader.readNext();
				while (line != null){
					writer.writeNext(new String[]{ 
							line[index[0]], 
							suName, 
							index[1] == -1 ? "" : line[index[1]], 
							index[2] == -1 ? "" : line[index[2]], 
							index[3] == -1 ? "" : line[index[3]], 
							index[4] == -1 ? "" : line[index[4]],	
							index[5] == -1 ? "" : line[index[5]],
							index[6] == -1 ? "" : line[index[6]], 
							index[7] == -1 ? "" : line[index[7]], 
							index[8] == -1 ? "" : line[index[8]], 
							index[9] == -1 ? "" : line[index[9]]});
					line = reader.readNext();
				}
		}catch (IOException e){
			System.out.println( e.getMessage() );
		}
	}

	private String getNameFromFile(String fileName) {
		
		int startIndex = fileName.indexOf(".") + 1;
		int lastIndex = fileName.lastIndexOf("-") - 15;
		String name = null;
		try{
			name = fileName.substring(startIndex, lastIndex); 
		}catch(Exception e){
		}
		return name;
	}

	private void getFileMap(){

		for (String ipIterator : ipList){
			List<File> fileList = new ArrayList<File>();
			
			for (int i = 0; i<files.length; i++){
				if (!files[i].getName().startsWith( prefix ))
				try{
					CSVReader reader = new CSVReader(new FileReader(files[i]));
					if ( reader.readNext()[2].equalsIgnoreCase("SU_MAC") ){
						String ip = (String)reader.readNext()[1];
						if (ipIterator.equals(ip))
							fileList.add(files[i]);
					}
				}catch (FileNotFoundException e){
					System.out.println( e.getMessage() );
				}
				catch (IOException ioe){
					System.out.println( ioe.getMessage() );
				}catch (Exception iob){
				}
			}
			
			fileMap.put(ipIterator, fileList);
			
		}
		
	}
		
	private void getIpList() {
		for (int i = 0; i<files.length; i++)
		{	
			if (!files[i].getName().startsWith( prefix ) && (files[i].getName().endsWith(".csv")))
			try{
				CSVReader reader = new CSVReader(new FileReader(files[i]));
				if ( reader.readNext()[2].equalsIgnoreCase("SU_MAC") ){
					String ip = (String)reader.readNext()[1];
				
					if (!ip.matches(ipValid)) 
						break;
					
					System.out.println( " Processed file : " + files[i].getName() );
					boolean ipUnique = true;
					for (String ipIterator : ipList){
						if (ipIterator.equals(ip)){	
							ipUnique = false;
							break;
							}
					}
					if (ipUnique) 
						ipList.add( ip );
				}
			}catch (FileNotFoundException e){
				System.out.println( e.getMessage() );
			}
			catch (IOException ioe){
				System.out.println( ioe.getMessage() );
			}catch (Exception iob){
			}
		}
		System.out.println();
	}
	
	
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		
		new ExportDataTool();

	}
	
}
