/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.symmetric;

import com.isnetworks.provider.symmetric.StreamCipherAlgorithm;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.CipherSpi;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class SymmetricStreamCipher
extends CipherSpi {
    protected StreamCipherAlgorithm mCipher;
    private byte[] mIV;

    public SymmetricStreamCipher(StreamCipherAlgorithm cipher) {
        this.mCipher = cipher;
    }

    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException("Stream Ciphers do not allow modes");
    }

    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        throw new NoSuchPaddingException("Stream Ciphers do not allow padding");
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec paramSpec, SecureRandom random) throws InvalidKeyException {
        if (!key.getAlgorithm().equalsIgnoreCase(this.mCipher.getAlgorithm())) {
            throw new InvalidKeyException("Cannot use a " + key.getAlgorithm() + " key with a " + this.mCipher.getAlgorithm() + " algorithm");
        }
        this.mCipher.setOpMode(opmode);
        if (paramSpec instanceof IvParameterSpec) {
            this.mIV = ((IvParameterSpec)paramSpec).getIV();
            this.mCipher.setKey(key.getEncoded(), this.mIV);
        } else {
            this.mCipher.setKey(key.getEncoded());
        }
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException {
        this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
    }

    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
    }

    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    protected int engineGetBlockSize() {
        return 8;
    }

    protected int engineGetOutputSize(int length) {
        return length;
    }

    protected byte[] engineGetIV() {
        return this.mIV;
    }

    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        if (this.mCipher.getOpMode() != 1 && this.mCipher.getOpMode() != 2) {
            throw new IllegalStateException("Cipher not initialized");
        }
        byte[] buffer = input;
        if (inputOffset != 0 || inputLen != input.length) {
            buffer = new byte[inputLen];
            System.arraycopy(input, inputOffset, buffer, 0, inputLen);
        }
        return this.mCipher.update(buffer);
    }

    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        if (output.length - outputOffset < this.engineGetOutputSize(inputLen)) {
            throw new ShortBufferException("Need " + inputLen + " bytes, had only " + (output.length - outputOffset));
        }
        byte[] outputBuffer = this.engineUpdate(input, inputOffset, inputLen);
        System.arraycopy(outputBuffer, 0, output, outputOffset, outputBuffer.length);
        return outputBuffer.length;
    }

    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) {
        byte[] result = this.engineUpdate(input, inputOffset, inputLen);
        this.mCipher.reset();
        return result;
    }

    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        int outputSize = this.engineUpdate(input, inputOffset, inputLen, output, outputOffset);
        this.mCipher.reset();
        return outputSize;
    }

    protected byte[] engineWrap(Key key) {
        byte[] keyEncoding = key.getEncoded();
        this.mCipher.setOpMode(1);
        byte[] result = this.engineDoFinal(keyEncoding, 0, keyEncoding.length);
        this.mCipher.setOpMode(3);
        return result;
    }

    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        this.mCipher.setOpMode(2);
        byte[] keyEncoding = this.engineDoFinal(wrappedKey, 0, wrappedKey.length);
        this.mCipher.setOpMode(4);
        if (wrappedKeyType == 3) {
            return new SecretKeySpec(keyEncoding, wrappedKeyAlgorithm);
        }
        if (wrappedKeyType == 1) {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyEncoding);
            KeyFactory kf = KeyFactory.getInstance(wrappedKeyAlgorithm);
            try {
                return kf.generatePublic(keySpec);
            }
            catch (InvalidKeySpecException e) {
                throw new InvalidKeyException(e.getMessage());
            }
        }
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyEncoding);
        KeyFactory kf = KeyFactory.getInstance(wrappedKeyAlgorithm);
        try {
            return kf.generatePrivate(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeyException(e.getMessage());
        }
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        return key.getEncoded().length;
    }
}

