/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.symmetric;

import com.isnetworks.provider.NoPadding;
import com.isnetworks.provider.PKCS5Padding;
import com.isnetworks.provider.Padding;
import com.isnetworks.provider.pbe.PBEKeyConvertor;
import com.isnetworks.provider.symmetric.BlockCipherAlgorithm;
import com.isnetworks.provider.symmetric.CBCMode;
import com.isnetworks.provider.symmetric.CFBMode;
import com.isnetworks.provider.symmetric.ECBMode;
import com.isnetworks.provider.symmetric.Mode;
import com.isnetworks.provider.symmetric.OFBMode;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class SymmetricBlockCipher
extends CipherSpi {
    protected BlockCipherAlgorithm mCipher;
    protected String mModeName = "ECB";
    protected int mModeChunkSize;
    protected Mode mMode;
    protected int mOpMode;
    protected Padding mPadding;
    protected AlgorithmParameters mAlgorithmParameters;
    protected AlgorithmParameterSpec mAlgorithmParameterSpec;
    protected PBEKeyConvertor mKeyConvertor = null;

    public SymmetricBlockCipher(BlockCipherAlgorithm cipher) {
        this.mCipher = cipher;
    }

    public SymmetricBlockCipher(BlockCipherAlgorithm cipher, PBEKeyConvertor keyConvertor) {
        this(cipher);
        this.mKeyConvertor = keyConvertor;
        this.mModeName = "CBC";
        this.mPadding = new PKCS5Padding();
    }

    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        block7: {
            if (this.mKeyConvertor != null && !mode.equals("CBC")) {
                throw new IllegalArgumentException("PBE implies the use of CBC");
            }
            this.mModeName = mode;
            if (!mode.equals("ECB") && !mode.equals("CBC")) {
                if (mode.startsWith("CFB") || mode.startsWith("OFB")) {
                    if (this.mPadding instanceof PKCS5Padding) {
                        throw new NoSuchAlgorithmException("Can't use PKCS5Padding with CFB or OFB");
                    }
                    try {
                        this.mModeName = mode.substring(0, "CFB".length());
                        int bitSize = Integer.parseInt(mode.substring("CFB".length()));
                        this.mModeChunkSize = bitSize / 8;
                        if (this.mModeChunkSize < 1 || this.mModeChunkSize > this.mCipher.getBlockSize() || bitSize % 8 != 0) {
                            throw new NoSuchAlgorithmException(mode.substring(3) + " block size must be between " + 8 + " and " + this.mCipher.getBlockSize() * 8);
                        }
                        break block7;
                    }
                    catch (NumberFormatException e) {
                        throw new NoSuchAlgorithmException("Unknown mode:" + mode);
                    }
                }
                throw new NoSuchAlgorithmException("Unknown mode:" + mode);
            }
        }
    }

    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        if (this.mKeyConvertor != null && !padding.equals("PKCS5Padding")) {
            throw new IllegalArgumentException("PBE implies the use of PKCS5Padding");
        }
        if (padding.equals("NoPadding")) {
            this.mPadding = new NoPadding();
        } else if (padding.equals("PKCS5Padding")) {
            this.mPadding = new PKCS5Padding();
        } else {
            throw new NoSuchPaddingException("Unknown padding: " + padding);
        }
    }

    protected Key makeKey(byte[] keyBytes, String algorithm) {
        return new SecretKeySpec(keyBytes, algorithm);
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec paramSpec, SecureRandom random) throws InvalidAlgorithmParameterException, InvalidKeyException {
        this.mAlgorithmParameterSpec = paramSpec;
        if (this.mKeyConvertor != null) {
            if (!(paramSpec instanceof PBEParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Must initialize PBE ciphers with a PBEParameterSpec");
            }
            byte[] keyBytes = this.mKeyConvertor.getKeyBytes(key, (PBEParameterSpec)paramSpec);
            byte[] ivBytes = this.mKeyConvertor.getIVBytes(key, (PBEParameterSpec)paramSpec);
            key = new SecretKeySpec(keyBytes, this.mCipher.getAlgorithm());
            paramSpec = new IvParameterSpec(ivBytes);
        }
        if (this.mPadding == null) {
            this.mPadding = this.mModeName.equals("CBC") || this.mModeName.equals("ECB") ? new PKCS5Padding() : new NoPadding();
        }
        if (!key.getAlgorithm().equalsIgnoreCase(this.mCipher.getAlgorithm())) {
            throw new InvalidKeyException("Cannot use a " + key.getAlgorithm() + " key with a " + this.mCipher.getAlgorithm() + " cipher.");
        }
        this.mCipher.setKey(key.getEncoded());
        this.mOpMode = opmode;
        int cipherOpMode = opmode;
        if (opmode == 3) {
            cipherOpMode = 1;
        } else if (opmode == 4) {
            cipherOpMode = 2;
        }
        if (this.mModeName.equals("ECB")) {
            this.mMode = new ECBMode(cipherOpMode, this.mCipher, this.mPadding);
        } else {
            byte[] iv = null;
            if (paramSpec == null && cipherOpMode == 1) {
                iv = new byte[this.mCipher.getBlockSize()];
                random.nextBytes(iv);
                this.mAlgorithmParameterSpec = new IvParameterSpec(iv);
            } else if (paramSpec instanceof IvParameterSpec) {
                iv = ((IvParameterSpec)paramSpec).getIV();
            } else if (paramSpec instanceof RC2ParameterSpec) {
                iv = ((RC2ParameterSpec)paramSpec).getIV();
            } else {
                throw new InvalidAlgorithmParameterException("Must pass in an AlgorithmParameterSpec for " + this.mModeName + " mode");
            }
            this.mMode = this.mModeName.equals("CBC") ? new CBCMode(cipherOpMode, this.mCipher, this.mPadding, iv) : (this.mModeName.startsWith("CFB") ? new CFBMode(cipherOpMode, this.mCipher, this.mModeChunkSize, iv) : new OFBMode(cipherOpMode, this.mCipher, this.mModeChunkSize, iv));
        }
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidAlgorithmParameterException, InvalidKeyException {
        this.mAlgorithmParameters = params;
        this.engineInit(opmode, key, this.getAlgorithmParameterSpec(params), random);
    }

    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException("InvalidAlgorithmParameterException");
        }
    }

    protected AlgorithmParameters engineGetParameters() {
        return this.mAlgorithmParameters;
    }

    protected int engineGetBlockSize() {
        return this.mMode.getBlockSize();
    }

    protected int engineGetOutputSize(int length) {
        return this.mMode.getOutputSize(length);
    }

    protected byte[] engineGetIV() {
        return this.mMode.getIV();
    }

    protected AlgorithmParameterSpec getAlgorithmParameterSpec(AlgorithmParameters params) throws InvalidAlgorithmParameterException {
        return null;
    }

    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        if (this.mOpMode != 1 && this.mOpMode != 2) {
            throw new IllegalStateException("Cipher is not in ENCRYPT_MODE or DECRYPT_MODE");
        }
        byte[] buffer = input;
        if (inputOffset != 0 || inputLen != input.length) {
            buffer = new byte[inputLen];
            System.arraycopy(input, inputOffset, buffer, 0, inputLen);
        }
        return this.mMode.update(buffer);
    }

    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        if (output.length - outputOffset < this.mMode.getUpdateOutputSize(inputLen)) {
            throw new ShortBufferException("Need " + this.mMode.getUpdateOutputSize(inputLen) + " bytes in the output array, only have " + (output.length - outputOffset));
        }
        byte[] outputBuffer = this.engineUpdate(input, inputOffset, inputLen);
        System.arraycopy(outputBuffer, 0, output, outputOffset, outputBuffer.length);
        return outputBuffer.length;
    }

    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws BadPaddingException, IllegalBlockSizeException {
        if (this.mOpMode != 1 && this.mOpMode != 2) {
            throw new IllegalStateException("Cipher is not in ENCRYPT_MODE or DECRYPT_MODE");
        }
        if (input == null) {
            input = new byte[]{};
        }
        byte[] buffer = input;
        if (inputOffset != 0 || inputLen != input.length) {
            buffer = new byte[inputLen];
            System.arraycopy(input, inputOffset, buffer, 0, inputLen);
        }
        byte[] result = this.mMode.doFinal(buffer);
        this.mMode.reset();
        return result;
    }

    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, BadPaddingException, IllegalBlockSizeException {
        if (output.length - outputOffset < this.mMode.getOutputSize(inputLen)) {
            throw new ShortBufferException("Need " + this.mMode.getOutputSize(inputLen) + " bytes in the output array, only have " + (output.length - outputOffset));
        }
        byte[] outputBuffer = this.engineDoFinal(input, inputOffset, inputLen);
        System.arraycopy(outputBuffer, 0, output, outputOffset, outputBuffer.length);
        return outputBuffer.length;
    }

    /*
     * WARNING - void declaration
     */
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        if (this.mOpMode != 3) {
            throw new IllegalStateException("Cipher is not in WRAP_MODE");
        }
        byte[] keyEncoding = key.getEncoded();
        try {
            void e;
            this.mOpMode = 1;
            byte[] result = this.engineDoFinal(keyEncoding, 0, keyEncoding.length);
            this.mOpMode = 3;
            return e;
        }
        catch (BadPaddingException e) {
            throw new IllegalBlockSizeException(e.getMessage());
        }
    }

    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        if (this.mOpMode != 4) {
            throw new IllegalStateException("Cipher is not in UNWRAP_MODE");
        }
        byte[] keyEncoding = null;
        try {
            this.mOpMode = 2;
            keyEncoding = this.engineDoFinal(wrappedKey, 0, wrappedKey.length);
            this.mOpMode = 4;
        }
        catch (IllegalBlockSizeException e) {
            throw new InvalidKeyException(e.getMessage());
        }
        catch (BadPaddingException e) {
            throw new InvalidKeyException(e.getMessage());
        }
        if (wrappedKeyType == 3) {
            return new SecretKeySpec(keyEncoding, wrappedKeyAlgorithm);
        }
        if (wrappedKeyType == 1) {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyEncoding);
            KeyFactory kf = KeyFactory.getInstance(wrappedKeyAlgorithm);
            try {
                return kf.generatePublic(keySpec);
            }
            catch (InvalidKeySpecException e) {
                throw new InvalidKeyException(e.getMessage());
            }
        }
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyEncoding);
        KeyFactory kf = KeyFactory.getInstance(wrappedKeyAlgorithm);
        try {
            return kf.generatePrivate(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeyException(e.getMessage());
        }
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        return key.getEncoded().length;
    }
}

