/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.symmetric;

import com.isnetworks.provider.Util;
import com.isnetworks.provider.symmetric.BlockCipherAlgorithm;
import java.security.InvalidKeyException;
import javax.crypto.IllegalBlockSizeException;

public class Rijndael
implements BlockCipherAlgorithm {
    private static final int DEFAULT_BLOCKSIZE = 128;
    private int mNr;
    private int mBlockSize;
    private byte[] mState;
    private byte[] mWorkingState;
    private int mNb;
    private byte[] mKeyBytes;
    private int[] mW;
    private int mNk;
    private byte[][] mRoundKey;
    private static final byte[] LOGTABLE = new byte[]{0, 0, 25, 1, 50, 2, 26, -58, 75, -57, 27, 104, 51, -18, -33, 3, 100, 4, -32, 14, 52, -115, -127, -17, 76, 113, 8, -56, -8, 105, 28, -63, 125, -62, 29, -75, -7, -71, 39, 106, 77, -28, -90, 114, -102, -55, 9, 120, 101, 47, -118, 5, 33, 15, -31, 36, 18, -16, -126, 69, 53, -109, -38, -114, -106, -113, -37, -67, 54, -48, -50, -108, 19, 92, -46, -15, 64, 70, -125, 56, 102, -35, -3, 48, -65, 6, -117, 98, -77, 37, -30, -104, 34, -120, -111, 16, 126, 110, 72, -61, -93, -74, 30, 66, 58, 107, 40, 84, -6, -123, 61, -70, 43, 121, 10, 21, -101, -97, 94, -54, 78, -44, -84, -27, -13, 115, -89, 87, -81, 88, -88, 80, -12, -22, -42, 116, 79, -82, -23, -43, -25, -26, -83, -24, 44, -41, 117, 122, -21, 22, 11, -11, 89, -53, 95, -80, -100, -87, 81, -96, 127, 12, -10, 111, 23, -60, 73, -20, -40, 67, 31, 45, -92, 118, 123, -73, -52, -69, 62, 90, -5, 96, -79, -122, 59, 82, -95, 108, -86, 85, 41, -99, -105, -78, -121, -112, 97, -66, -36, -4, -68, -107, -49, -51, 55, 63, 91, -47, 83, 57, -124, 60, 65, -94, 109, 71, 20, 42, -98, 93, 86, -14, -45, -85, 68, 17, -110, -39, 35, 32, 46, -119, -76, 124, -72, 38, 119, -103, -29, -91, 103, 74, -19, -34, -59, 49, -2, 24, 13, 99, -116, -128, -64, -9, 112, 7};
    private static final byte[] ALOGTABLE = new byte[]{1, 3, 5, 15, 17, 51, 85, -1, 26, 46, 114, -106, -95, -8, 19, 53, 95, -31, 56, 72, -40, 115, -107, -92, -9, 2, 6, 10, 30, 34, 102, -86, -27, 52, 92, -28, 55, 89, -21, 38, 106, -66, -39, 112, -112, -85, -26, 49, 83, -11, 4, 12, 20, 60, 68, -52, 79, -47, 104, -72, -45, 110, -78, -51, 76, -44, 103, -87, -32, 59, 77, -41, 98, -90, -15, 8, 24, 40, 120, -120, -125, -98, -71, -48, 107, -67, -36, 127, -127, -104, -77, -50, 73, -37, 118, -102, -75, -60, 87, -7, 16, 48, 80, -16, 11, 29, 39, 105, -69, -42, 97, -93, -2, 25, 43, 125, -121, -110, -83, -20, 47, 113, -109, -82, -23, 32, 96, -96, -5, 22, 58, 78, -46, 109, -73, -62, 93, -25, 50, 86, -6, 21, 63, 65, -61, 94, -30, 61, 71, -55, 64, -64, 91, -19, 44, 116, -100, -65, -38, 117, -97, -70, -43, 100, -84, -17, 42, 126, -126, -99, -68, -33, 122, -114, -119, -128, -101, -74, -63, 88, -24, 35, 101, -81, -22, 37, 111, -79, -56, 67, -59, 84, -4, 31, 33, 99, -91, -12, 7, 9, 27, 45, 119, -103, -80, -53, 70, -54, 69, -49, 74, -34, 121, -117, -122, -111, -88, -29, 62, 66, -58, 81, -13, 14, 18, 54, 90, -18, 41, 123, -115, -116, -113, -118, -123, -108, -89, -14, 13, 23, 57, 75, -35, 124, -124, -105, -94, -3, 28, 36, 108, -76, -57, 82, -10, 1};
    private static final byte[] S = new byte[]{99, 124, 119, 123, -14, 107, 111, -59, 48, 1, 103, 43, -2, -41, -85, 118, -54, -126, -55, 125, -6, 89, 71, -16, -83, -44, -94, -81, -100, -92, 114, -64, -73, -3, -109, 38, 54, 63, -9, -52, 52, -91, -27, -15, 113, -40, 49, 21, 4, -57, 35, -61, 24, -106, 5, -102, 7, 18, -128, -30, -21, 39, -78, 117, 9, -125, 44, 26, 27, 110, 90, -96, 82, 59, -42, -77, 41, -29, 47, -124, 83, -47, 0, -19, 32, -4, -79, 91, 106, -53, -66, 57, 74, 76, 88, -49, -48, -17, -86, -5, 67, 77, 51, -123, 69, -7, 2, 127, 80, 60, -97, -88, 81, -93, 64, -113, -110, -99, 56, -11, -68, -74, -38, 33, 16, -1, -13, -46, -51, 12, 19, -20, 95, -105, 68, 23, -60, -89, 126, 61, 100, 93, 25, 115, 96, -127, 79, -36, 34, 42, -112, -120, 70, -18, -72, 20, -34, 94, 11, -37, -32, 50, 58, 10, 73, 6, 36, 92, -62, -45, -84, 98, -111, -107, -28, 121, -25, -56, 55, 109, -115, -43, 78, -87, 108, 86, -12, -22, 101, 122, -82, 8, -70, 120, 37, 46, 28, -90, -76, -58, -24, -35, 116, 31, 75, -67, -117, -118, 112, 62, -75, 102, 72, 3, -10, 14, 97, 53, 87, -71, -122, -63, 29, -98, -31, -8, -104, 17, 105, -39, -114, -108, -101, 30, -121, -23, -50, 85, 40, -33, -116, -95, -119, 13, -65, -26, 66, 104, 65, -103, 45, 15, -80, 84, -69, 22};
    private static final byte[] Si = new byte[]{82, 9, 106, -43, 48, 54, -91, 56, -65, 64, -93, -98, -127, -13, -41, -5, 124, -29, 57, -126, -101, 47, -1, -121, 52, -114, 67, 68, -60, -34, -23, -53, 84, 123, -108, 50, -90, -62, 35, 61, -18, 76, -107, 11, 66, -6, -61, 78, 8, 46, -95, 102, 40, -39, 36, -78, 118, 91, -94, 73, 109, -117, -47, 37, 114, -8, -10, 100, -122, 104, -104, 22, -44, -92, 92, -52, 93, 101, -74, -110, 108, 112, 72, 80, -3, -19, -71, -38, 94, 21, 70, 87, -89, -115, -99, -124, -112, -40, -85, 0, -116, -68, -45, 10, -9, -28, 88, 5, -72, -77, 69, 6, -48, 44, 30, -113, -54, 63, 15, 2, -63, -81, -67, 3, 1, 19, -118, 107, 58, -111, 17, 65, 79, 103, -36, -22, -105, -14, -49, -50, -16, -76, -26, 115, -106, -84, 116, 34, -25, -83, 53, -123, -30, -7, 55, -24, 28, 117, -33, 110, 71, -15, 26, 113, 29, 41, -59, -119, 111, -73, 98, 14, -86, 24, -66, 27, -4, 86, 62, 75, -58, -46, 121, 32, -102, -37, -64, -2, 120, -51, 90, -12, 31, -35, -88, 51, -120, 7, -57, 49, -79, 18, 16, 89, 39, -128, -20, 95, 96, 81, 127, -87, 25, -75, 74, 13, 45, -27, 122, -97, -109, -55, -100, -17, -96, -32, 59, 77, -82, 42, -11, -80, -56, -21, -69, 60, -125, 83, -103, 97, 23, 43, 4, 126, -70, 119, -42, 38, -31, 105, 20, 99, 85, 33, 12, 125};
    private static final byte[][] iG = new byte[][]{{14, 9, 13, 11}, {11, 14, 9, 13}, {13, 11, 14, 9}, {9, 13, 11, 14}};
    private static final int[] RCON = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 27, 54, 108, 216, 171, 77, 154, 47, 94, 188, 99, 198, 151, 53, 106, 212, 179, 125, 250, 239, 197, 145};
    private static final int[] SHIFT4 = new int[]{0, 1, 2, 3};
    private static final int[] SHIFT6 = new int[]{0, 1, 2, 3};
    private static final int[] SHIFT8 = new int[]{0, 1, 3, 4};

    public Rijndael() {
        this(128);
    }

    public Rijndael(byte[] keyBytes) throws InvalidKeyException {
        this(128, keyBytes);
    }

    public Rijndael(int blockSize, byte[] keyBytes) throws InvalidKeyException {
        this(blockSize);
        this.setKey(keyBytes);
    }

    public Rijndael(int blockSize) {
        if (blockSize != 128 && blockSize != 192 && blockSize != 256) {
            throw new IllegalArgumentException("Rijndael supports only blocksizes of 128, 192, or 256 bits");
        }
        this.mBlockSize = blockSize / 8;
        this.mNb = this.mBlockSize * 8 / 32;
        this.mState = new byte[this.mBlockSize];
        this.mWorkingState = new byte[this.mBlockSize];
    }

    public void setKey(byte[] keyBytes) throws InvalidKeyException {
        if (keyBytes.length != 16 && keyBytes.length != 24 && keyBytes.length != 32) {
            throw new InvalidKeyException("Rijndael keys must be 128, 192, or 256 bits long");
        }
        this.mKeyBytes = new byte[keyBytes.length];
        System.arraycopy(keyBytes, 0, this.mKeyBytes, 0, this.mKeyBytes.length);
        this.mNk = keyBytes.length * 8 / 32;
        this.mNr = this.mNb == 8 || this.mNk == 8 ? 14 : (this.mNb == 6 || this.mNk == 6 ? 12 : 10);
        this.expandKey();
    }

    private void addRoundKey(int round) {
        int i = 0;
        while (i < this.mState.length) {
            this.mState[i] = (byte)(this.mState[i] ^ this.mRoundKey[round][i]);
            ++i;
        }
    }

    private void expandKey() {
        int temp;
        int i;
        this.mW = new int[this.mNb * (this.mNr + 1)];
        int i2 = 0;
        while (i2 < this.mNk) {
            this.mW[i2] = Util.bytesToInt(this.mKeyBytes, i2 * 4);
            ++i2;
        }
        if (this.mNk <= 6) {
            i = this.mNk;
            while (i < this.mNb * (this.mNr + 1)) {
                temp = this.mW[i - 1];
                if (i % this.mNk == 0) {
                    temp = this.subByte(this.rotByte(temp), S) ^ RCON[i / this.mNk - 1] << 24;
                }
                this.mW[i] = this.mW[i - this.mNk] ^ temp;
                ++i;
            }
        } else {
            i = this.mNk;
            while (i < this.mNb * (this.mNr + 1)) {
                temp = this.mW[i - 1];
                if (i % this.mNk == 0) {
                    temp = this.subByte(this.rotByte(temp), S) ^ RCON[i / this.mNk - 1] << 24;
                } else if (i % this.mNk == 4) {
                    temp = this.subByte(temp, S);
                }
                this.mW[i] = this.mW[i - this.mNk] ^ temp;
                ++i;
            }
        }
        this.mRoundKey = new byte[this.mNr + 1][];
        int round = 0;
        while (round < this.mNr + 1) {
            byte[] roundKey = new byte[4 * this.mNb];
            int roundKeyIndex = 0;
            while (roundKeyIndex < this.mNb) {
                byte[] temp2 = Util.intToBytes(this.mW[roundKeyIndex + round * this.mNb]);
                int i3 = 0;
                while (i3 < 4) {
                    roundKey[i3 * this.mNb + roundKeyIndex] = temp2[i3];
                    ++i3;
                }
                ++roundKeyIndex;
            }
            this.mRoundKey[round] = roundKey;
            ++round;
        }
    }

    private void mixColumn() {
        int j = 0;
        while (j < this.mNb) {
            int i = 0;
            while (i < 4) {
                byte first = this.mul((byte)2, this.mState[this.twoDToLinear(i, j)]);
                byte second = this.mul((byte)3, this.mState[this.twoDToLinear((i + 1) % 4, j)]);
                byte third = this.mState[this.twoDToLinear((i + 2) % 4, j)];
                byte fourth = this.mState[this.twoDToLinear((i + 3) % 4, j)];
                this.mWorkingState[this.twoDToLinear((int)i, (int)j)] = (byte)(first ^ second ^ third ^ fourth);
                ++i;
            }
            ++j;
        }
        System.arraycopy(this.mWorkingState, 0, this.mState, 0, this.mState.length);
    }

    private void invMixColumn() {
        int j = 0;
        while (j < this.mNb) {
            int i = 0;
            while (i < 4) {
                byte first = this.mul((byte)14, this.mState[this.twoDToLinear(i, j)]);
                byte second = this.mul((byte)11, this.mState[this.twoDToLinear((i + 1) % 4, j)]);
                byte third = this.mul((byte)13, this.mState[this.twoDToLinear((i + 2) % 4, j)]);
                byte fourth = this.mul((byte)9, this.mState[this.twoDToLinear((i + 3) % 4, j)]);
                this.mWorkingState[this.twoDToLinear((int)i, (int)j)] = (byte)(first ^ second ^ third ^ fourth);
                ++i;
            }
            ++j;
        }
        System.arraycopy(this.mWorkingState, 0, this.mState, 0, this.mState.length);
    }

    private void shiftRowRight() {
        int[] shift = null;
        shift = this.mNb == 4 ? SHIFT4 : (this.mNb == 6 ? SHIFT6 : SHIFT8);
        int row = 1;
        while (row < 4) {
            System.arraycopy(this.mState, row * this.mNb, this.mWorkingState, row * this.mNb + shift[row], this.mNb - shift[row]);
            System.arraycopy(this.mState, row * this.mNb + this.mNb - shift[row], this.mWorkingState, row * this.mNb, shift[row]);
            ++row;
        }
        System.arraycopy(this.mWorkingState, this.mNb, this.mState, this.mNb, this.mState.length - this.mNb);
    }

    private void shiftRowLeft() {
        int[] shift = null;
        shift = this.mNb == 4 ? SHIFT4 : (this.mNb == 6 ? SHIFT6 : SHIFT8);
        int row = 1;
        while (row < 4) {
            int shiftAmount = (this.mNb - shift[row]) % this.mNb;
            System.arraycopy(this.mState, row * this.mNb, this.mWorkingState, row * this.mNb + shiftAmount, this.mNb - shiftAmount);
            System.arraycopy(this.mState, row * this.mNb + this.mNb - shiftAmount, this.mWorkingState, row * this.mNb, shiftAmount);
            ++row;
        }
        System.arraycopy(this.mWorkingState, this.mNb, this.mState, this.mNb, this.mState.length - this.mNb);
    }

    private void byteSub(byte[] sbox) {
        int n = 0;
        while (n < this.mState.length) {
            this.mWorkingState[n] = sbox[Util.fixByte(this.mState[n])];
            ++n;
        }
        System.arraycopy(this.mWorkingState, 0, this.mState, 0, this.mState.length);
    }

    private int rotByte(int input) {
        int result = 0;
        result |= input >> 24 & 0xFF;
        result |= (input >> 16 & 0xFF) << 24;
        result |= (input >> 8 & 0xFF) << 16;
        return result |= (input >> 0 & 0xFF) << 8;
    }

    private int twoDToLinear(int i, int j) {
        return i * this.mNb + j;
    }

    private int subByte(int input, byte[] sbox) {
        byte[] result = new byte[4];
        byte[] inputBytes = Util.intToBytes(input);
        int i = 0;
        while (i < 4) {
            result[i] = sbox[Util.fixByte(inputBytes[i])];
            ++i;
        }
        return Util.bytesToInt(result, 0);
    }

    private byte mul(byte a, byte b) {
        if (a != 0 && b != 0) {
            int aLog = Util.fixByte(LOGTABLE[Util.fixByte(a)]);
            int bLog = Util.fixByte(LOGTABLE[Util.fixByte(b)]);
            int index = (aLog + bLog) % 255;
            return ALOGTABLE[index];
        }
        return 0;
    }

    public String getAlgorithm() {
        return "Rijndael";
    }

    public int getBlockSize() {
        return this.mBlockSize;
    }

    public byte[] encrypt(byte[] plaintext) throws IllegalBlockSizeException {
        int i;
        if (plaintext.length != this.mBlockSize) {
            throw new IllegalBlockSizeException("Rijndael in " + this.mBlockSize * 8 + "-bit mode");
        }
        int j = 0;
        while (j < this.mNb) {
            i = 0;
            while (i < 4) {
                this.mState[i * this.mNb + j] = plaintext[j * 4 + i];
                ++i;
            }
            ++j;
        }
        this.addRoundKey(0);
        i = 1;
        while (i < this.mNr) {
            this.byteSub(S);
            this.shiftRowLeft();
            this.mixColumn();
            this.addRoundKey(i);
            ++i;
        }
        this.byteSub(S);
        this.shiftRowLeft();
        this.addRoundKey(this.mNr);
        byte[] result = new byte[this.mState.length];
        int j2 = 0;
        while (j2 < this.mNb) {
            int i2 = 0;
            while (i2 < 4) {
                result[j2 * 4 + i2] = this.mState[i2 * this.mNb + j2];
                ++i2;
            }
            ++j2;
        }
        return result;
    }

    public byte[] decrypt(byte[] ciphertext) throws IllegalBlockSizeException {
        int i;
        if (ciphertext.length != this.mBlockSize) {
            throw new IllegalBlockSizeException("Rijndael in " + this.mBlockSize * 8 + "-bit mode");
        }
        int j = 0;
        while (j < this.mNb) {
            i = 0;
            while (i < 4) {
                this.mState[i * this.mNb + j] = ciphertext[j * 4 + i];
                ++i;
            }
            ++j;
        }
        this.addRoundKey(this.mNr);
        this.byteSub(Si);
        this.shiftRowRight();
        i = this.mNr - 1;
        while (i > 0) {
            this.addRoundKey(i);
            this.invMixColumn();
            this.byteSub(Si);
            this.shiftRowRight();
            --i;
        }
        this.addRoundKey(0);
        byte[] result = new byte[this.mState.length];
        int j2 = 0;
        while (j2 < this.mNb) {
            int i2 = 0;
            while (i2 < 4) {
                result[j2 * 4 + i2] = this.mState[i2 * this.mNb + j2];
                ++i2;
            }
            ++j2;
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        byte[] plaintext = new byte[16];
        while (true) {
            Rijndael rijndael = new Rijndael(new byte[16]);
            byte[] ciphertext = rijndael.encrypt(plaintext);
            rijndael.decrypt(ciphertext);
        }
    }
}

