/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.symmetric;

import com.isnetworks.provider.Util;
import com.isnetworks.provider.symmetric.BlockCipherAlgorithm;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;

public class RC2
implements BlockCipherAlgorithm {
    private int[] mKeyShorts;
    private int[] mK = new int[64];
    private int[] mR = new int[4];
    private static final int UNRESTRICTED = -1;
    private int mEffectiveKeyBits = -1;
    private static final int BLOCK_SIZE = 8;
    private static final byte[] P = new byte[]{-39, 120, -7, -60, 25, -35, -75, -19, 40, -23, -3, 121, 74, -96, -40, -99, -58, 126, 55, -125, 43, 118, 83, -114, 98, 76, 100, -120, 68, -117, -5, -94, 23, -102, 89, -11, -121, -77, 79, 19, 97, 69, 109, -115, 9, -127, 125, 50, -67, -113, 64, -21, -122, -73, 123, 11, -16, -107, 33, 34, 92, 107, 78, -126, 84, -42, 101, -109, -50, 96, -78, 28, 115, 86, -64, 20, -89, -116, -15, -36, 18, 117, -54, 31, 59, -66, -28, -47, 66, 61, -44, 48, -93, 60, -74, 38, 111, -65, 14, -38, 70, 105, 7, 87, 39, -14, 29, -101, -68, -108, 67, 3, -8, 17, -57, -10, -112, -17, 62, -25, 6, -61, -43, 47, -56, 102, 30, -41, 8, -24, -22, -34, -128, 82, -18, -9, -124, -86, 114, -84, 53, 77, 106, 42, -106, 26, -46, 113, 90, 21, 73, 116, 75, -97, -48, 94, 4, 24, -92, -20, -62, -32, 65, 110, 15, 81, -53, -52, 36, -111, -81, 80, -95, -12, 112, 57, -103, 124, 58, -123, 35, -72, -76, 122, -4, 2, 54, 91, 37, 85, -105, 49, 45, 93, -6, -104, -29, -118, -110, -82, 5, -33, 41, 16, 103, 108, -70, -55, -45, 0, -26, -49, -31, -98, -88, 44, 99, 22, 1, 63, 88, -30, -119, -87, 13, 56, 52, 27, -85, 51, -1, -80, -69, 72, 12, 95, -71, -79, -51, 46, -59, -13, -37, 71, -27, -91, -100, 119, 10, -90, 32, 104, -2, 127, -63, -83};

    public RC2() {
    }

    public RC2(int effectiveKeyBits) {
        this.mEffectiveKeyBits = effectiveKeyBits;
    }

    public String getAlgorithm() {
        return "RC2";
    }

    public RC2(byte[] keyBytes) throws InvalidKeyException {
        this.setKey(keyBytes);
    }

    public void setEffectiveKeyBits(int length) {
        this.mEffectiveKeyBits = length;
    }

    public void setKey(byte[] keyBytes) throws InvalidKeyException {
        int t;
        if (keyBytes.length < 1 || keyBytes.length > 128) {
            throw new InvalidKeyException("RC2 keys must be at least 8 bits in length and no more than 1024 bits");
        }
        if (this.mEffectiveKeyBits == -1) {
            this.mEffectiveKeyBits = keyBytes.length * 8;
        }
        int t8 = (this.mEffectiveKeyBits + 7) / 8;
        int tm = 255 % (int)Math.pow(2.0, 8 + this.mEffectiveKeyBits - 8 * t8);
        byte[] L = new byte[128];
        System.arraycopy(keyBytes, 0, L, 0, keyBytes.length);
        int i = t = keyBytes.length;
        while (i <= 127) {
            L[i] = P[(this.fixByte(L[i - 1]) + this.fixByte(L[i - t])) % 256];
            ++i;
        }
        L[128 - t8] = P[this.fixByte(L[128 - t8]) & tm];
        int i2 = 127 - t8;
        while (i2 >= 0) {
            L[i2] = P[this.fixByte(L[i2 + 1]) ^ this.fixByte(L[i2 + t8])];
            --i2;
        }
        int i3 = 0;
        while (i3 < this.mK.length) {
            this.mK[i3] = Util.bytesToShort(L, i3 * 2);
            ++i3;
        }
    }

    private int fixByte(byte b) {
        if (b >= 0) {
            return b;
        }
        return b + 256;
    }

    public void reset() {
    }

    public byte[] encrypt(byte[] plaintextBytes) throws IllegalBlockSizeException {
        if (plaintextBytes.length != 8) {
            throw new IllegalBlockSizeException("RC2 operates on 64 bit blocks");
        }
        int i = 0;
        while (i < 4) {
            this.mR[i] = Util.bytesToShort(plaintextBytes, i * 2);
            ++i;
        }
        int j = 0;
        int i2 = 0;
        while (i2 < 5) {
            j = this.mix(j);
            ++i2;
        }
        this.mash();
        int i3 = 0;
        while (i3 < 6) {
            j = this.mix(j);
            ++i3;
        }
        this.mash();
        int i4 = 0;
        while (i4 < 5) {
            j = this.mix(j);
            ++i4;
        }
        return Util.shortsToBytes(this.mR[0], this.mR[1], this.mR[2], this.mR[3]);
    }

    private int mix(int j) {
        this.mR[0] = this.mR[0] + this.mK[j] + (this.mR[3] & this.mR[2]) + (~this.mR[3] & this.mR[1]) & 0xFFFF;
        this.mR[0] = this.rotateLeft(this.mR[0], 1);
        this.mR[1] = this.mR[1] + this.mK[++j] + (this.mR[0] & this.mR[3]) + (~this.mR[0] & this.mR[2]) & 0xFFFF;
        this.mR[1] = this.rotateLeft(this.mR[1], 2);
        this.mR[2] = this.mR[2] + this.mK[++j] + (this.mR[1] & this.mR[0]) + (~this.mR[1] & this.mR[3]) & 0xFFFF;
        this.mR[2] = this.rotateLeft(this.mR[2], 3);
        this.mR[3] = this.mR[3] + this.mK[++j] + (this.mR[2] & this.mR[1]) + (~this.mR[2] & this.mR[0]) & 0xFFFF;
        this.mR[3] = this.rotateLeft(this.mR[3], 5);
        return ++j;
    }

    private void mash() {
        this.mR[0] = this.mR[0] + this.mK[this.mR[3] & 0x3F];
        this.mR[1] = this.mR[1] + this.mK[this.mR[0] & 0x3F];
        this.mR[2] = this.mR[2] + this.mK[this.mR[1] & 0x3F];
        this.mR[3] = this.mR[3] + this.mK[this.mR[2] & 0x3F];
    }

    private int rotateLeft(int s, int numBits) {
        return s << numBits | s >>> 16 - numBits;
    }

    private int rotateRight(int s, int numBits) {
        return (s &= 0xFFFF) >>> numBits | s << 16 - numBits & 0xFFFF;
    }

    public byte[] decrypt(byte[] ciphertextBytes) throws IllegalBlockSizeException {
        if (ciphertextBytes.length != 8) {
            throw new IllegalBlockSizeException("RC2 operates on 64 bit blocks");
        }
        int i = 0;
        while (i < 4) {
            this.mR[i] = Util.bytesToShort(ciphertextBytes, i * 2);
            ++i;
        }
        int j = 63;
        int i2 = 0;
        while (i2 < 5) {
            j = this.unmix(j);
            ++i2;
        }
        this.unmash();
        int i3 = 0;
        while (i3 < 6) {
            j = this.unmix(j);
            ++i3;
        }
        this.unmash();
        int i4 = 0;
        while (i4 < 5) {
            j = this.unmix(j);
            ++i4;
        }
        return Util.shortsToBytes(this.mR[0], this.mR[1], this.mR[2], this.mR[3]);
    }

    private int unmix(int j) {
        this.mR[3] = this.rotateRight(this.mR[3], 5);
        this.mR[3] = this.mR[3] - this.mK[j] - (this.mR[2] & this.mR[1]) - (~this.mR[2] & this.mR[0]) & 0xFFFF;
        this.mR[2] = this.rotateRight(this.mR[2], 3);
        this.mR[2] = this.mR[2] - this.mK[--j] - (this.mR[1] & this.mR[0]) - (~this.mR[1] & this.mR[3]) & 0xFFFF;
        this.mR[1] = this.rotateRight(this.mR[1], 2);
        this.mR[1] = this.mR[1] - this.mK[--j] - (this.mR[0] & this.mR[3]) - (~this.mR[0] & this.mR[2]) & 0xFFFF;
        this.mR[0] = this.rotateRight(this.mR[0], 1);
        this.mR[0] = this.mR[0] - this.mK[--j] - (this.mR[3] & this.mR[2]) - (~this.mR[3] & this.mR[1]) & 0xFFFF;
        return --j;
    }

    private void unmash() {
        this.mR[3] = this.mR[3] - this.mK[this.mR[2] & 0x3F];
        this.mR[2] = this.mR[2] - this.mK[this.mR[1] & 0x3F];
        this.mR[1] = this.mR[1] - this.mK[this.mR[0] & 0x3F];
        this.mR[0] = this.mR[0] - this.mK[this.mR[3] & 0x3F];
    }

    public void setAlgorithmParameterSpec(AlgorithmParameterSpec paramSpec) throws InvalidAlgorithmParameterException {
        if (paramSpec instanceof RC2ParameterSpec) {
            this.mEffectiveKeyBits = ((RC2ParameterSpec)paramSpec).getEffectiveKeyBits();
        } else {
            if (paramSpec == null) {
                return;
            }
            if (!(paramSpec instanceof IvParameterSpec)) {
                throw new InvalidAlgorithmParameterException("RC2 must get either an IvParameterSpec or RC2ParameterSpec");
            }
        }
    }

    public int getBlockSize() {
        return 8;
    }
}

