/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.symmetric;

import com.isnetworks.provider.Util;
import com.isnetworks.provider.symmetric.AbstractArbitraryBlockSizeMode;
import com.isnetworks.provider.symmetric.BlockCipherAlgorithm;
import javax.crypto.IllegalBlockSizeException;

public class OFBMode
extends AbstractArbitraryBlockSizeMode {
    public OFBMode(int operation, BlockCipherAlgorithm cipher, int chunkingSize, byte[] iv) {
        super(operation, cipher, chunkingSize, iv);
    }

    protected byte[] processBuffer() {
        byte[] result = null;
        try {
            if (this.mOperation == 1) {
                byte[] encryptedBytes = this.mCipher.encrypt(this.mFeedbackRegister);
                result = new byte[this.mChunkingSize];
                System.arraycopy(encryptedBytes, 0, result, 0, this.mChunkingSize);
                this.shiftFeedbackRegister(result);
                result = Util.xor(result, this.mBuffer);
            } else {
                byte[] encryptedBytes = this.mCipher.encrypt(this.mFeedbackRegister);
                result = new byte[this.mChunkingSize];
                System.arraycopy(encryptedBytes, 0, result, 0, this.mChunkingSize);
                this.shiftFeedbackRegister(result);
                result = Util.xor(result, this.mBuffer);
            }
            return result;
        }
        catch (IllegalBlockSizeException e) {
            throw new IllegalStateException("Problem with AbstractArbitraryBlockSizeMode, not blocking data into appropriate block sizes");
        }
    }
}

