/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.symmetric;

import com.isnetworks.provider.symmetric.BlockCipherAlgorithm;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;

public abstract class Mode {
    protected BlockCipherAlgorithm mCipher;
    protected byte[] mIV;
    protected byte[] mBuffer;
    protected int mBufferIndex;
    protected int mOperation;
    protected byte[] mFeedbackRegister;

    public Mode(int operation, BlockCipherAlgorithm cipher) {
        if (operation != 1 && operation != 2) {
            throw new IllegalArgumentException("Operation must be Cipher.ENCRYPT_MODE, or Cipher.DECRYPT_MODE");
        }
        this.mOperation = operation;
        this.mCipher = cipher;
    }

    public int getBlockSize() {
        return this.mCipher.getBlockSize();
    }

    public byte[] getIV() {
        byte[] result = new byte[this.mIV.length];
        System.arraycopy(this.mIV, 0, result, 0, this.mIV.length);
        return result;
    }

    public byte[] update(byte[] data) {
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream(data.length);
            int dataIndex = 0;
            while (dataIndex < data.length) {
                this.mBuffer[this.mBufferIndex++] = data[dataIndex];
                if (this.mBufferIndex == this.mBuffer.length) {
                    bOut.write(this.processBuffer());
                    this.mBufferIndex = 0;
                }
                ++dataIndex;
            }
            byte[] result = bOut.toByteArray();
            if (result.length == 0) {
                return null;
            }
            return result;
        }
        catch (IOException e) {
            throw new InternalError("You've got a really messed up ByteArrayOutputStream.");
        }
    }

    public void reset() {
        this.mBufferIndex = 0;
        System.arraycopy(this.mIV, 0, this.mFeedbackRegister, 0, this.mIV.length);
    }

    public abstract byte[] doFinal(byte[] var1) throws BadPaddingException, IllegalBlockSizeException;

    public abstract int getOutputSize(int var1);

    public abstract int getUpdateOutputSize(int var1);

    protected abstract byte[] processBuffer();
}

