/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.symmetric;

import com.isnetworks.provider.symmetric.BlockCipherAlgorithm;
import com.isnetworks.provider.symmetric.DES;
import java.security.InvalidKeyException;
import javax.crypto.IllegalBlockSizeException;

public class DESede
implements BlockCipherAlgorithm {
    private DES mDES1 = new DES();
    private DES mDES2 = new DES();
    private DES mDES3 = new DES();
    private static final int BLOCK_SIZE = 8;

    public DESede() {
    }

    public DESede(byte[] keyBytes) throws InvalidKeyException {
        this.setKey(keyBytes);
    }

    public String getAlgorithm() {
        return "DESede";
    }

    public void setKey(byte[] keyBytes) throws InvalidKeyException {
        if (keyBytes.length != 24) {
            throw new InvalidKeyException("DESede needs a 192 bit key, which it converts to 168 bits");
        }
        byte[] subkey = new byte[8];
        System.arraycopy(keyBytes, 0, subkey, 0, subkey.length);
        this.mDES1.setKey(subkey);
        System.arraycopy(keyBytes, 8, subkey, 0, subkey.length);
        this.mDES2.setKey(subkey);
        System.arraycopy(keyBytes, 16, subkey, 0, subkey.length);
        this.mDES3.setKey(subkey);
    }

    public byte[] encrypt(byte[] plaintextBytes) throws IllegalBlockSizeException {
        if (plaintextBytes.length != 8) {
            throw new IllegalBlockSizeException("DESede operates on 64 bit blocks");
        }
        byte[] working = this.mDES1.encrypt(plaintextBytes);
        working = this.mDES2.decrypt(working);
        return this.mDES3.encrypt(working);
    }

    public byte[] decrypt(byte[] ciphertextBytes) throws IllegalBlockSizeException {
        if (ciphertextBytes.length != 8) {
            throw new IllegalBlockSizeException("DESede operates on 64 bit blocks");
        }
        byte[] working = this.mDES3.decrypt(ciphertextBytes);
        working = this.mDES2.encrypt(working);
        return this.mDES1.decrypt(working);
    }

    public int getBlockSize() {
        return 8;
    }
}

