/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.symmetric;

import com.isnetworks.provider.Padding;
import com.isnetworks.provider.Util;
import com.isnetworks.provider.symmetric.AbstractBasicMode;
import com.isnetworks.provider.symmetric.BlockCipherAlgorithm;
import java.security.InvalidAlgorithmParameterException;
import javax.crypto.IllegalBlockSizeException;

public class CBCMode
extends AbstractBasicMode {
    public CBCMode(int operation, BlockCipherAlgorithm cipher, Padding padding, byte[] iv) throws InvalidAlgorithmParameterException {
        super(operation, cipher, padding);
        if (iv.length != cipher.getBlockSize()) {
            throw new InvalidAlgorithmParameterException("The IV must be the same length as the block size of the cipher");
        }
        this.mFeedbackRegister = new byte[iv.length];
        this.mIV = new byte[iv.length];
        System.arraycopy(iv, 0, this.mFeedbackRegister, 0, iv.length);
        System.arraycopy(iv, 0, this.mIV, 0, iv.length);
    }

    protected byte[] processBuffer() {
        byte[] result = null;
        try {
            if (this.mOperation == 1) {
                byte[] xoredBytes = Util.xor(this.mBuffer, this.mFeedbackRegister);
                result = this.mCipher.encrypt(xoredBytes);
                this.mFeedbackRegister = result;
            } else {
                byte[] xoredBytes = this.mCipher.decrypt(this.mBuffer);
                result = Util.xor(xoredBytes, this.mFeedbackRegister);
                System.arraycopy(this.mBuffer, 0, this.mFeedbackRegister, 0, this.mBuffer.length);
            }
            return result;
        }
        catch (IllegalBlockSizeException e) {
            throw new IllegalStateException("Problem with AbstractBasicMode, not blocking data into appropriate block sizes");
        }
    }
}

