/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.symmetric;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class BlowfishKeyGenerator
extends KeyGeneratorSpi {
    private SecureRandom mRandom = new SecureRandom();
    private int mKeySize = 128;

    protected SecretKey engineGenerateKey() {
        byte[] keyBytes = new byte[this.mKeySize / 8];
        this.mRandom.nextBytes(keyBytes);
        return new SecretKeySpec(keyBytes, "Blowfish");
    }

    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("Blowfish does not accept an AlgorithmParameterSpec");
        }
        this.mRandom = random;
    }

    protected void engineInit(int keysize, SecureRandom random) throws InvalidParameterException {
        this.mRandom = random;
        if (keysize < 32 || keysize > 448 || keysize % 8 != 0) {
            throw new InvalidParameterException("Blowfish keys must be between 32 and 448 bits in length, and a multiple of 8");
        }
        this.mKeySize = keysize;
    }

    protected void engineInit(SecureRandom random) {
        this.mRandom = random;
    }
}

