/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.symmetric;

import com.isnetworks.provider.symmetric.StreamCipherAlgorithm;
import java.security.InvalidKeyException;

public class ArcFour
implements StreamCipherAlgorithm {
    private byte[] sbox = new byte[256];
    private int mI;
    private int mJ;
    private byte[] oldSbox = new byte[256];
    private int mOpMode;

    public ArcFour() {
    }

    public ArcFour(byte[] keyBytes) throws InvalidKeyException {
        this.setKey(keyBytes);
    }

    public ArcFour(byte[] keyBytes, byte[] iv) throws InvalidKeyException {
        this.setKey(keyBytes, iv);
    }

    public String getAlgorithm() {
        return "RC4";
    }

    public void setOpMode(int opmode) {
        this.mOpMode = opmode;
    }

    public int getOpMode() {
        return this.mOpMode;
    }

    public void setKey(byte[] keyBytes, byte[] iv) throws InvalidKeyException {
        byte[] keyAndIvBytes = new byte[keyBytes.length + iv.length];
        System.arraycopy(keyBytes, 0, keyAndIvBytes, 0, keyBytes.length);
        System.arraycopy(iv, 0, keyAndIvBytes, keyBytes.length, iv.length);
        this.setKey(keyAndIvBytes);
    }

    public void setKey(byte[] keyBytes) throws InvalidKeyException {
        if (keyBytes.length == 0 || keyBytes.length > 256) {
            throw new InvalidKeyException("Key must be 8 to 2048 bits in length");
        }
        byte[] k = new byte[256];
        int i = 0;
        int j = 0;
        i = 0;
        while (i < 256) {
            this.sbox[i] = (byte)i;
            if (j == keyBytes.length) {
                j = 0;
            }
            k[i] = keyBytes[j];
            ++j;
            ++i;
        }
        j = 0;
        i = 0;
        while (i < 256) {
            if ((j = (j + this.sbox[i] + k[i]) % 256) < 0) {
                j += 256;
            }
            byte temp = this.sbox[i];
            this.sbox[i] = this.sbox[j];
            this.sbox[j] = temp;
            ++i;
        }
        System.arraycopy(this.sbox, 0, this.oldSbox, 0, this.sbox.length);
        this.mI = 0;
        this.mJ = 0;
    }

    public void reset() {
        System.arraycopy(this.oldSbox, 0, this.sbox, 0, this.oldSbox.length);
        this.mI = 0;
        this.mJ = 0;
    }

    public byte update(byte input) {
        this.mI = (this.mI + 1) % 256;
        if (this.mI < 0) {
            this.mI += 256;
        }
        this.mJ = (this.mJ + this.sbox[this.mI]) % 256;
        if (this.mJ < 0) {
            this.mJ += 256;
        }
        byte temp = this.sbox[this.mI];
        this.sbox[this.mI] = this.sbox[this.mJ];
        this.sbox[this.mJ] = temp;
        int t = (this.sbox[this.mI] + this.sbox[this.mJ]) % 256;
        if (t < 0) {
            t += 256;
        }
        byte k = this.sbox[t];
        return (byte)(input ^ k);
    }

    public byte[] update(byte[] input) {
        byte[] output = new byte[input.length];
        int i = 0;
        while (i < input.length) {
            output[i] = this.update(input[i]);
            ++i;
        }
        return output;
    }

    public byte encrypt(byte input) {
        return this.update(input);
    }

    public byte decrypt(byte input) {
        return this.update(input);
    }

    public byte[] encrypt(byte[] input) {
        return this.update(input);
    }

    public byte[] decrypt(byte[] input) {
        return this.update(input);
    }
}

