/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.symmetric;

import com.isnetworks.provider.NoPadding;
import com.isnetworks.provider.Padding;
import com.isnetworks.provider.symmetric.BlockCipherAlgorithm;
import com.isnetworks.provider.symmetric.Mode;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;

public abstract class AbstractBasicMode
extends Mode {
    protected Padding mPadding;

    public AbstractBasicMode(int operation, BlockCipherAlgorithm cipher, Padding padding) {
        super(operation, cipher);
        this.mPadding = padding;
        this.mBuffer = new byte[this.mCipher.getBlockSize()];
    }

    public int getUpdateOutputSize(int inputSize) {
        int result = (inputSize + this.mBufferIndex) / this.getBlockSize();
        return result * this.getBlockSize();
    }

    public int getOutputSize(int inputSize) {
        int result = (inputSize + this.mBufferIndex) / this.getBlockSize();
        if ((inputSize + this.mBufferIndex) % this.getBlockSize() != 0 || !(this.mPadding instanceof NoPadding)) {
            ++result;
        }
        return result * this.getBlockSize();
    }

    public byte[] doFinal(byte[] data) throws BadPaddingException, IllegalBlockSizeException {
        byte[] resultBuffer = this.update(data);
        if (this.mOperation == 1) {
            byte[] finalUnpaddedPlaintextBlock = new byte[this.mBufferIndex];
            System.arraycopy(this.mBuffer, 0, finalUnpaddedPlaintextBlock, 0, finalUnpaddedPlaintextBlock.length);
            byte[] paddedPlaintextBlock = this.mPadding.encode(finalUnpaddedPlaintextBlock, this.getBlockSize());
            if (paddedPlaintextBlock.length == 0) {
                return resultBuffer;
            }
            System.arraycopy(paddedPlaintextBlock, 0, this.mBuffer, 0, this.getBlockSize());
            byte[] finalCiphertextBlock = this.processBuffer();
            int resultBufferLength = resultBuffer == null ? 0 : resultBuffer.length;
            byte[] result = new byte[resultBufferLength + finalCiphertextBlock.length];
            if (resultBuffer != null) {
                System.arraycopy(resultBuffer, 0, result, 0, resultBuffer.length);
            }
            System.arraycopy(finalCiphertextBlock, 0, result, resultBufferLength, finalCiphertextBlock.length);
            return result;
        }
        if (this.mBufferIndex != 0) {
            throw new IllegalBlockSizeException("Ciphertext must be a multiple of the block size in length");
        }
        if (resultBuffer == null) {
            resultBuffer = new byte[]{};
        }
        byte[] paddedFinalBlock = new byte[this.getBlockSize()];
        if (resultBuffer.length >= this.getBlockSize()) {
            System.arraycopy(resultBuffer, resultBuffer.length - this.getBlockSize(), paddedFinalBlock, 0, this.getBlockSize());
        } else {
            System.arraycopy(resultBuffer, 0, paddedFinalBlock, 0, resultBuffer.length);
        }
        byte[] unpaddedFinalChunk = this.mPadding.decode(paddedFinalBlock);
        if (resultBuffer.length <= this.getBlockSize()) {
            return unpaddedFinalChunk;
        }
        byte[] result = new byte[resultBuffer.length - this.getBlockSize() + unpaddedFinalChunk.length];
        System.arraycopy(resultBuffer, 0, result, 0, resultBuffer.length - this.getBlockSize());
        System.arraycopy(unpaddedFinalChunk, 0, result, resultBuffer.length - this.getBlockSize(), unpaddedFinalChunk.length);
        return result;
    }
}

