/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.symmetric;

import com.isnetworks.provider.symmetric.BlockCipherAlgorithm;
import com.isnetworks.provider.symmetric.Mode;
import javax.crypto.IllegalBlockSizeException;

public abstract class AbstractArbitraryBlockSizeMode
extends Mode {
    protected int mChunkingSize;

    public AbstractArbitraryBlockSizeMode(int operation, BlockCipherAlgorithm cipher, int chunkingSize, byte[] iv) {
        super(operation, cipher);
        this.mChunkingSize = chunkingSize;
        this.mBuffer = new byte[this.mChunkingSize];
        this.mFeedbackRegister = new byte[iv.length];
        this.mIV = new byte[iv.length];
        System.arraycopy(iv, 0, this.mFeedbackRegister, 0, iv.length);
        System.arraycopy(iv, 0, this.mIV, 0, iv.length);
    }

    public int getOutputSize(int inputSize) {
        int result = (inputSize + this.mBufferIndex) / this.mChunkingSize;
        if ((inputSize + this.mBufferIndex) % this.mChunkingSize != 0) {
            ++result;
        }
        return result * this.mChunkingSize;
    }

    public int getUpdateOutputSize(int inputSize) {
        int result = (inputSize + this.mBufferIndex) / this.mChunkingSize;
        return result * this.mChunkingSize;
    }

    public byte[] doFinal(byte[] data) throws IllegalBlockSizeException {
        byte[] resultBuffer = this.update(data);
        if (this.mBufferIndex != 0) {
            throw new IllegalBlockSizeException("Input data must be a multiple of the mode's block size (" + this.mChunkingSize + ")");
        }
        return resultBuffer;
    }

    protected void shiftFeedbackRegister(byte[] newBytes) {
        System.arraycopy(this.mFeedbackRegister, newBytes.length, this.mFeedbackRegister, 0, this.mFeedbackRegister.length - newBytes.length);
        System.arraycopy(newBytes, 0, this.mFeedbackRegister, this.mFeedbackRegister.length - newBytes.length, newBytes.length);
    }

    public void reset() {
        System.arraycopy(this.mIV, 0, this.mFeedbackRegister, 0, this.mIV.length);
        this.mBufferIndex = 0;
    }
}

