/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.rsa;

import com.isnetworks.provider.Padding;
import com.isnetworks.provider.rsa.RSA;
import com.isnetworks.provider.rsa.Util;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.IllegalBlockSizeException;

public abstract class RSASignature
extends SignatureSpi {
    private static final int SIGN_MODE = 1;
    private static final int VERIFY_MODE = 2;
    private MessageDigest mHasher;
    private Padding mPadding;
    private int mOperatingMode;
    private Key mKey;
    private boolean mInitialized = false;

    protected void setMessageDigest(MessageDigest hasher) {
        this.mHasher = hasher;
    }

    protected void setPadding(Padding padding) {
        this.mPadding = padding;
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("Key must be an RSAPrivateKey");
        }
        this.mOperatingMode = 1;
        this.mHasher.reset();
        this.mKey = privateKey;
        this.mInitialized = true;
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.engineInitSign(privateKey);
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyException("Key must be an RSAPublicKey");
        }
        this.mOperatingMode = 2;
        this.mHasher.reset();
        this.mKey = publicKey;
        this.mInitialized = true;
    }

    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("RSASignature does not accept algorithm parameters");
    }

    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new InvalidParameterException("RSASignature does not accept algorithm parameters");
    }

    protected Object engineGetParameter(String param) {
        return null;
    }

    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        if (!this.mInitialized) {
            throw new SignatureException("Signature not initialized");
        }
        this.mHasher.update(b, off, len);
    }

    protected void engineUpdate(byte b) throws SignatureException {
        byte[] byteArray = new byte[]{b};
        this.engineUpdate(byteArray, 0, 1);
    }

    protected byte[] engineSign() throws SignatureException {
        if (!this.mInitialized) {
            throw new SignatureException("Signature not initialized");
        }
        if (this.mOperatingMode != 1) {
            throw new SignatureException("Signature not in signing mode");
        }
        int k = (((RSAPrivateKey)this.mKey).getModulus().bitLength() + 7) / 8;
        byte[] hash = this.mHasher.digest();
        byte[] S = null;
        try {
            byte[] EM = this.mPadding.encode(hash, k - 1);
            BigInteger m = new BigInteger(1, EM);
            BigInteger s = RSA.rsasp1((RSAPrivateKey)this.mKey, m);
            S = Util.I2OSP(s, k);
        }
        catch (IllegalBlockSizeException ibse) {
            throw new SignatureException(ibse.getMessage());
        }
        return S;
    }

    protected int engineSign(byte[] outbuf, int offset, int len) throws SignatureException {
        byte[] output = this.engineSign();
        if (output.length > len) {
            throw new SignatureException("buffer too small");
        }
        System.arraycopy(output, 0, outbuf, offset, output.length);
        return output.length;
    }

    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        if (!this.mInitialized) {
            throw new SignatureException("Signature not initialized");
        }
        if (this.mOperatingMode != 2) {
            throw new SignatureException("Signature not in verify mode");
        }
        int k = (((RSAPublicKey)this.mKey).getModulus().bitLength() + 7) / 8;
        BigInteger s = new BigInteger(1, sigBytes);
        byte[] EM = null;
        byte[] EMPrime = null;
        try {
            BigInteger m = RSA.rsavp1((RSAPublicKey)this.mKey, s);
            EM = Util.I2OSP(m, k - 1);
            byte[] hash = this.mHasher.digest();
            EMPrime = this.mPadding.encode(hash, k - 1);
        }
        catch (IllegalBlockSizeException ibse) {
            throw new SignatureException(ibse.getMessage());
        }
        if (EM.length != EMPrime.length) {
            return false;
        }
        int i = 0;
        while (i < EM.length) {
            if (EM[i] != EMPrime[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

