/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.rsa;

import com.isnetworks.provider.asn1.EncodeException;
import com.isnetworks.provider.asn1.pkcs1.Identifiers;
import com.isnetworks.provider.asn1.x509.RSAPublicKey;
import com.isnetworks.provider.asn1.x509.SubjectPublicKeyInfo;
import java.math.BigInteger;

public class RSAPublicKeyImpl
implements java.security.interfaces.RSAPublicKey {
    private BigInteger mModulus;
    private BigInteger mPublicExponent;

    protected RSAPublicKeyImpl(BigInteger modulus, BigInteger publicExponent) {
        this.mModulus = modulus;
        this.mPublicExponent = publicExponent;
    }

    public BigInteger getModulus() {
        return this.mModulus;
    }

    public BigInteger getPublicExponent() {
        return this.mPublicExponent;
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public String getFormat() {
        return "X509";
    }

    public byte[] getEncoded() {
        try {
            RSAPublicKey publicKey = new RSAPublicKey("public key");
            publicKey.getModulus().setValue(this.mModulus);
            publicKey.getPublicExponent().setValue(this.mPublicExponent);
            byte[] publicKeyBytes = publicKey.encode();
            SubjectPublicKeyInfo keyInfo = new SubjectPublicKeyInfo("public key info");
            keyInfo.getAlgorithm().getAlgorithm().setValue(Identifiers.rsaEncryption);
            keyInfo.getSubjectPublicKey().setValue(publicKeyBytes);
            return keyInfo.encode();
        }
        catch (EncodeException e) {
            return null;
        }
    }
}

