/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.rsa;

import com.isnetworks.provider.asn1.EncodeException;
import com.isnetworks.provider.asn1.Null;
import com.isnetworks.provider.asn1.pkcs1.Identifiers;
import com.isnetworks.provider.asn1.pkcs8.PrivateKeyInfo;
import com.isnetworks.provider.asn1.pkcs8.Version;
import com.isnetworks.provider.asn1.x509.RSAPrivateKey;
import com.isnetworks.provider.rsa.RSAPrivateKeyImpl;
import java.math.BigInteger;
import java.security.interfaces.RSAPrivateCrtKey;

public class RSAPrivateCrtKeyImpl
extends RSAPrivateKeyImpl
implements RSAPrivateCrtKey {
    private BigInteger mPublicExponent;
    private BigInteger mPrimeP;
    private BigInteger mPrimeQ;
    private BigInteger mPrimeExponentP;
    private BigInteger mPrimeExponentQ;
    private BigInteger mCrtCoefficient;

    protected RSAPrivateCrtKeyImpl(BigInteger modulus, BigInteger privateExponent, BigInteger publicExponent, BigInteger primeP, BigInteger primeQ) {
        super(modulus, privateExponent);
        this.mPublicExponent = publicExponent;
        this.mPrimeP = primeP;
        this.mPrimeQ = primeQ;
        this.mPrimeExponentP = super.getPrivateExponent().mod(this.mPrimeP.subtract(BigInteger.ONE));
        this.mPrimeExponentQ = super.getPrivateExponent().mod(this.mPrimeQ.subtract(BigInteger.ONE));
        this.mCrtCoefficient = this.mPrimeQ.modInverse(this.mPrimeP);
    }

    protected RSAPrivateCrtKeyImpl(BigInteger modulus, BigInteger privateExponent, BigInteger publicExponent, BigInteger primeP, BigInteger primeQ, BigInteger crtCoefficient) {
        super(modulus, privateExponent);
        this.mPublicExponent = publicExponent;
        this.mPrimeP = primeP;
        this.mPrimeQ = primeQ;
        this.mPrimeExponentP = super.getPrivateExponent().mod(this.mPrimeP.subtract(BigInteger.ONE));
        this.mPrimeExponentQ = super.getPrivateExponent().mod(this.mPrimeQ.subtract(BigInteger.ONE));
        this.mCrtCoefficient = crtCoefficient;
    }

    protected RSAPrivateCrtKeyImpl(BigInteger modulus, BigInteger privateExponent, BigInteger publicExponent, BigInteger primeP, BigInteger primeQ, BigInteger primeExponentP, BigInteger primeExponentQ, BigInteger crtCoefficient) {
        super(modulus, privateExponent);
        this.mPublicExponent = publicExponent;
        this.mPrimeP = primeP;
        this.mPrimeQ = primeQ;
        this.mPrimeExponentP = primeExponentP;
        this.mPrimeExponentQ = primeExponentQ;
        this.mCrtCoefficient = crtCoefficient;
    }

    public BigInteger getPublicExponent() {
        return this.mPublicExponent;
    }

    public BigInteger getPrimeP() {
        return this.mPrimeP;
    }

    public BigInteger getPrimeQ() {
        return this.mPrimeQ;
    }

    public BigInteger getPrimeExponentP() {
        return this.mPrimeExponentP;
    }

    public BigInteger getPrimeExponentQ() {
        return this.mPrimeExponentQ;
    }

    public BigInteger getCrtCoefficient() {
        return this.mCrtCoefficient;
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] getEncoded() {
        try {
            RSAPrivateKey privateKey = new RSAPrivateKey("private key");
            privateKey.getVersion().setValue(Version.v1);
            privateKey.getModulus().setValue(this.getModulus());
            privateKey.getPublicExponent().setValue(this.mPublicExponent);
            privateKey.getPrivateExponent().setValue(this.getPrivateExponent());
            privateKey.getPrime1().setValue(this.mPrimeP);
            privateKey.getPrime2().setValue(this.mPrimeQ);
            privateKey.getExponent1().setValue(this.mPrimeExponentP);
            privateKey.getExponent2().setValue(this.mPrimeExponentQ);
            privateKey.getCoefficient().setValue(this.mCrtCoefficient);
            byte[] privateKeyBytes = privateKey.encode();
            PrivateKeyInfo keyInfo = new PrivateKeyInfo("private key info");
            keyInfo.getVersion().setValue(Version.v1);
            keyInfo.getPrivateKeyAlgorithm().getAlgorithm().setValue(Identifiers.rsaEncryption);
            keyInfo.getPrivateKeyAlgorithm().getParameters().setActual(new Null("null"));
            keyInfo.getPrivateKey().setValue(privateKeyBytes);
            return keyInfo.encode();
        }
        catch (EncodeException e) {
            return null;
        }
    }
}

