/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.rsa;

import com.isnetworks.provider.rsa.RSAPrivateCrtKeyImpl;
import com.isnetworks.provider.rsa.RSAPublicKeyImpl;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;

public final class RSAKeyPairGenerator
extends KeyPairGeneratorSpi {
    private static final BigInteger E = BigInteger.valueOf(65537L);
    private static final int CERTAINTY = 85;
    private static final int DEFAULT_STRENGTH = 1024;
    private int mKeysize;
    private SecureRandom mSecureRandom;
    private BigInteger mPublicExponent;
    private boolean mInitialized = false;

    public void initialize(int keysize, SecureRandom random) {
        this.mKeysize = keysize;
        this.mSecureRandom = random;
        this.mInitialized = true;
    }

    public KeyPair generateKeyPair() {
        BigInteger q;
        BigInteger qMinus1;
        BigInteger p;
        BigInteger pMinus1;
        if (!this.mInitialized) {
            this.initialize(1024, new SecureRandom());
        }
        int pSize = this.mKeysize / 2;
        int qSize = this.mKeysize - pSize;
        while (true) {
            if (!(pMinus1 = (p = new BigInteger(pSize, 85, this.mSecureRandom)).subtract(BigInteger.ONE)).gcd(E).equals(BigInteger.ONE)) {
                continue;
            }
            while (!(qMinus1 = (q = new BigInteger(qSize, 85, this.mSecureRandom)).subtract(BigInteger.ONE)).gcd(E).equals(BigInteger.ONE)) {
            }
            if (p.multiply(q).bitLength() == this.mKeysize) break;
        }
        BigInteger phi = pMinus1.multiply(qMinus1);
        BigInteger n = p.multiply(q);
        BigInteger d = E.modInverse(phi);
        return new KeyPair(new RSAPublicKeyImpl(n, E), new RSAPrivateCrtKeyImpl(n, d, E, p, q));
    }
}

