/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.rsa;

import com.isnetworks.provider.asn1.pkcs8.PrivateKeyInfo;
import com.isnetworks.provider.asn1.x509.RSAPrivateKey;
import com.isnetworks.provider.asn1.x509.RSAPublicKey;
import com.isnetworks.provider.asn1.x509.SubjectPublicKeyInfo;
import com.isnetworks.provider.rsa.RSAPrivateCrtKeyImpl;
import com.isnetworks.provider.rsa.RSAPrivateKeyImpl;
import com.isnetworks.provider.rsa.RSAPublicKeyImpl;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class RSAKeyFactory
extends KeyFactorySpi {
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (!(keySpec instanceof PKCS8EncodedKeySpec)) {
            throw new InvalidKeySpecException("Not a PKCS8EncodedKeySpec");
        }
        PKCS8EncodedKeySpec encodedKeySpec = (PKCS8EncodedKeySpec)keySpec;
        try {
            PrivateKeyInfo keyInfo = new PrivateKeyInfo("private key info");
            keyInfo.decode(encodedKeySpec.getEncoded());
            RSAPrivateKey asnKey = new RSAPrivateKey("private key");
            asnKey.decode((byte[])keyInfo.getPrivateKey().getValue());
            BigInteger modulus = (BigInteger)asnKey.getModulus().getValue();
            BigInteger publicExponent = (BigInteger)asnKey.getPublicExponent().getValue();
            BigInteger privateExponent = (BigInteger)asnKey.getPrivateExponent().getValue();
            BigInteger primeP = (BigInteger)asnKey.getPrime1().getValue();
            BigInteger primeQ = (BigInteger)asnKey.getPrime2().getValue();
            BigInteger primeExponentP = (BigInteger)asnKey.getExponent1().getValue();
            BigInteger primeExponentQ = (BigInteger)asnKey.getExponent2().getValue();
            BigInteger crtCoefficient = (BigInteger)asnKey.getCoefficient().getValue();
            RSAPrivateCrtKeyImpl privateKey = new RSAPrivateCrtKeyImpl(modulus, privateExponent, publicExponent, primeP, primeQ, primeExponentP, primeExponentQ, crtCoefficient);
            return privateKey;
        }
        catch (Exception e) {
            throw new InvalidKeySpecException(e.getMessage());
        }
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (!(keySpec instanceof X509EncodedKeySpec)) {
            throw new InvalidKeySpecException("Not an X509EncodedKeySpec");
        }
        X509EncodedKeySpec encodedKeySpec = (X509EncodedKeySpec)keySpec;
        try {
            SubjectPublicKeyInfo keyInfo = new SubjectPublicKeyInfo("public key info");
            keyInfo.decode(encodedKeySpec.getEncoded());
            RSAPublicKey asnKey = new RSAPublicKey("public key");
            asnKey.decode((byte[])keyInfo.getSubjectPublicKey().getValue());
            BigInteger modulus = (BigInteger)asnKey.getModulus().getValue();
            BigInteger publicExponent = (BigInteger)asnKey.getPublicExponent().getValue();
            RSAPublicKeyImpl publicKey = new RSAPublicKeyImpl(modulus, publicExponent);
            return publicKey;
        }
        catch (Exception e) {
            throw new InvalidKeySpecException(e.getMessage());
        }
    }

    protected KeySpec engineGetKeySpec(Key key, Class keySpec) throws InvalidKeySpecException {
        if (key instanceof java.security.interfaces.RSAPublicKey) {
            return this.getKeySpecFromPublicKey((java.security.interfaces.RSAPublicKey)key, keySpec);
        }
        if (key instanceof java.security.interfaces.RSAPrivateKey) {
            return this.getKeySpecFromPrivateKey((java.security.interfaces.RSAPrivateKey)key, keySpec);
        }
        throw new InvalidKeySpecException("Key is not an RSA key");
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof java.security.interfaces.RSAPublicKey) {
            return new RSAPublicKeyImpl(((java.security.interfaces.RSAPublicKey)key).getModulus(), ((java.security.interfaces.RSAPublicKey)key).getPublicExponent());
        }
        if (key instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey crtKey = (RSAPrivateCrtKey)key;
            return new RSAPrivateCrtKeyImpl(crtKey.getModulus(), crtKey.getPrivateExponent(), crtKey.getPublicExponent(), crtKey.getPrimeP(), crtKey.getPrimeQ(), crtKey.getCrtCoefficient());
        }
        if (key instanceof java.security.interfaces.RSAPrivateKey) {
            return new RSAPrivateKeyImpl(((java.security.interfaces.RSAPrivateKey)key).getModulus(), ((java.security.interfaces.RSAPrivateKey)key).getPrivateExponent());
        }
        throw new InvalidKeyException("Key is not an RSA key");
    }

    private KeySpec getKeySpecFromPublicKey(java.security.interfaces.RSAPublicKey key, Class keySpec) throws InvalidKeySpecException {
        if (keySpec.getName().equals("java.security.spec.X509EncodedKeySpec")) {
            return new X509EncodedKeySpec(key.getEncoded());
        }
        if (keySpec.getName().equals("java.security.spec.RSAPublicKeySpec")) {
            return new RSAPublicKeySpec(key.getModulus(), key.getPublicExponent());
        }
        throw new InvalidKeySpecException("KeySpec not X509Encoded or RSAPublic");
    }

    private KeySpec getKeySpecFromPrivateKey(java.security.interfaces.RSAPrivateKey key, Class keySpec) throws InvalidKeySpecException {
        if (keySpec.getName().equals("java.security.spec.PKCS8EncodedKeySpec")) {
            return new PKCS8EncodedKeySpec(key.getEncoded());
        }
        if (keySpec.getName().equals("java.security.spec.RSAPrivateKeySpec")) {
            return new RSAPrivateKeySpec(key.getModulus(), key.getPrivateExponent());
        }
        if (keySpec.getName().equals("java.security.spec.RSAPrivateCrtKeySpec")) {
            if (!(key instanceof RSAPrivateCrtKey)) {
                throw new InvalidKeySpecException("Key is not CRT key");
            }
            RSAPrivateCrtKey crtKey = (RSAPrivateCrtKey)key;
            return new RSAPrivateCrtKeySpec(crtKey.getModulus(), crtKey.getPublicExponent(), crtKey.getPrivateExponent(), crtKey.getPrimeP(), crtKey.getPrimeQ(), crtKey.getPrimeExponentP(), crtKey.getPrimeExponentQ(), crtKey.getCrtCoefficient());
        }
        throw new InvalidKeySpecException("KeySpec not PKCS8Encoded, RSAPrivate, or RSAPrivateCrt");
    }
}

