/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.rsa;

import com.isnetworks.provider.Padding;
import com.isnetworks.provider.rsa.OAEPPadding;
import com.isnetworks.provider.rsa.PKCS1Padding;
import com.isnetworks.provider.rsa.RSA;
import com.isnetworks.provider.rsa.Util;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

public final class RSACipher
extends CipherSpi {
    private static final int PKCS1 = 1;
    private static final int OAEP = 2;
    private int mPaddingType;
    private Key mKey;
    private Padding mPadding;
    private int mOperatingMode;
    private ByteArrayOutputStream mBaos = new ByteArrayOutputStream();
    private int mKeysize;
    private AlgorithmParameters mAlgorithmParameters;

    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (!mode.equalsIgnoreCase("ECB")) {
            throw new NoSuchAlgorithmException("RSA supports only ECB mode");
        }
    }

    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        if (padding.equalsIgnoreCase("PKCS1") || padding.equalsIgnoreCase("PKCS#1") || padding.equalsIgnoreCase("PKCS1Padding")) {
            this.mPaddingType = 1;
        } else if (padding.equalsIgnoreCase("OAEP") || padding.equalsIgnoreCase("OAEPPadding")) {
            this.mPaddingType = 2;
        } else {
            throw new NoSuchPaddingException("Only PKCS1 and OAEP Padding supported");
        }
    }

    protected int engineGetBlockSize() {
        if (this.mOperatingMode == 1) {
            return this.mKeysize - 1;
        }
        return this.mKeysize;
    }

    protected int engineGetOutputSize(int inputLen) {
        if (this.mOperatingMode == 1) {
            return this.mKeysize;
        }
        return this.mKeysize - 1;
    }

    protected byte[] engineGetIV() {
        return null;
    }

    protected AlgorithmParameters engineGetParameters() {
        return this.mAlgorithmParameters;
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        int modulusLength = 0;
        if (key instanceof RSAPublicKey) {
            if (opmode != 1 && opmode != 3) {
                throw new InvalidKeyException("Public Keys can only be used for encrypting");
            }
            modulusLength = ((RSAPublicKey)key).getModulus().bitLength();
        } else if (key instanceof RSAPrivateKey) {
            if (opmode != 2 && opmode != 4) {
                throw new InvalidKeyException("Private Keys can only be used for decrypting");
            }
            modulusLength = ((RSAPrivateKey)key).getModulus().bitLength();
        } else {
            throw new InvalidKeyException("Key must be an RSA Key");
        }
        this.mKeysize = (modulusLength + 7) / 8;
        this.mPadding = this.mPaddingType == 2 ? (params == null ? new OAEPPadding(random) : new OAEPPadding(params, random)) : new PKCS1Padding(random);
        this.mAlgorithmParameters = params;
        this.mKey = key;
        this.mOperatingMode = opmode;
        this.mBaos.reset();
    }

    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, (AlgorithmParameters)null, random);
        }
        catch (InvalidAlgorithmParameterException iape) {
            iape.printStackTrace();
        }
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("This cipher does not accept AlgorithmParameterSpec");
    }

    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        if (input != null) {
            this.mBaos.write(input, inputOffset, inputLen);
        }
        return null;
    }

    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) {
        this.engineUpdate(input, inputOffset, inputLen);
        return 0;
    }

    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        this.engineUpdate(input, inputOffset, inputLen);
        byte[] output = this.mOperatingMode == 1 || this.mOperatingMode == 3 ? this.encrypt() : this.decrypt();
        this.mBaos.reset();
        return output;
    }

    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        byte[] buffer = this.engineDoFinal(input, inputOffset, inputLen);
        if (output.length - outputOffset < buffer.length) {
            throw new ShortBufferException("Output longer than buffer");
        }
        System.arraycopy(buffer, 0, output, outputOffset, buffer.length);
        return buffer.length;
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] keyEncoding = key.getEncoded();
        try {
            return this.engineDoFinal(keyEncoding, 0, keyEncoding.length);
        }
        catch (BadPaddingException e) {
            throw new IllegalBlockSizeException(e.getMessage());
        }
    }

    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] keyEncoding = null;
        try {
            keyEncoding = this.engineDoFinal(wrappedKey, 0, wrappedKey.length);
        }
        catch (IllegalBlockSizeException e) {
            throw new InvalidKeyException(e.getMessage());
        }
        catch (BadPaddingException e) {
            throw new InvalidKeyException(e.getMessage());
        }
        if (wrappedKeyType == 3) {
            SecretKeySpec keySpec = new SecretKeySpec(keyEncoding, wrappedKeyAlgorithm);
            return keySpec;
        }
        if (wrappedKeyType == 1) {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyEncoding);
            KeyFactory kf = KeyFactory.getInstance(wrappedKeyAlgorithm);
            try {
                return kf.generatePublic(keySpec);
            }
            catch (InvalidKeySpecException e) {
                throw new InvalidKeyException(e.getMessage());
            }
        }
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyEncoding);
        KeyFactory kf = KeyFactory.getInstance(wrappedKeyAlgorithm);
        try {
            return kf.generatePrivate(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeyException(e.getMessage());
        }
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (key instanceof RSAPublicKey) {
            RSAPublicKey publicKey = (RSAPublicKey)key;
            return publicKey.getModulus().bitLength();
        }
        if (key instanceof RSAPrivateKey) {
            RSAPrivateKey privateKey = (RSAPrivateKey)key;
            return privateKey.getModulus().bitLength();
        }
        throw new InvalidKeyException("Key must be an RSA key");
    }

    private byte[] encrypt() throws IllegalBlockSizeException {
        byte[] M = this.mBaos.toByteArray();
        int k = this.mKeysize;
        byte[] EM = this.mPadding.encode(M, k - 1);
        BigInteger m = new BigInteger(1, EM);
        BigInteger c = RSA.rsaep((RSAPublicKey)this.mKey, m);
        byte[] C = Util.I2OSP(c, k);
        return C;
    }

    private byte[] decrypt() throws BadPaddingException, IllegalBlockSizeException {
        int k = this.mKeysize;
        byte[] C = this.mBaos.toByteArray();
        if (k != C.length) {
            throw new IllegalBlockSizeException("decryption error");
        }
        BigInteger c = new BigInteger(1, C);
        BigInteger m = RSA.rsadp((RSAPrivateKey)this.mKey, c);
        byte[] EM = Util.I2OSP(m, k - 1);
        byte[] M = this.mPadding.decode(EM);
        return M;
    }
}

