/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.rsa;

import java.math.BigInteger;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.IllegalBlockSizeException;

public class RSA {
    public static BigInteger rsaep(RSAPublicKey publicKey, BigInteger m) throws IllegalBlockSizeException {
        BigInteger e = publicKey.getPublicExponent();
        BigInteger n = publicKey.getModulus();
        BigInteger nMinusOne = n.subtract(BigInteger.ONE);
        if (m.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalBlockSizeException("Ciphertext too small");
        }
        if (m.compareTo(nMinusOne) > 0) {
            throw new IllegalBlockSizeException("Ciphertext too large");
        }
        BigInteger c = m.modPow(e, n);
        return c;
    }

    public static BigInteger rsadp(RSAPrivateKey privateKey, BigInteger c) {
        if (!(privateKey instanceof RSAPrivateCrtKey)) {
            BigInteger d = privateKey.getPrivateExponent();
            BigInteger n = privateKey.getModulus();
            BigInteger m = c.modPow(d, n);
            return m;
        }
        RSAPrivateCrtKey privateCrtKey = (RSAPrivateCrtKey)privateKey;
        BigInteger p = privateCrtKey.getPrimeP();
        BigInteger q = privateCrtKey.getPrimeQ();
        BigInteger dP = privateCrtKey.getPrimeExponentP();
        BigInteger dQ = privateCrtKey.getPrimeExponentQ();
        BigInteger qInv = privateCrtKey.getCrtCoefficient();
        BigInteger m1 = c.modPow(dP, p);
        BigInteger m2 = c.modPow(dQ, q);
        BigInteger h = m1.subtract(m2);
        h = h.multiply(qInv);
        h = h.mod(p);
        BigInteger m = h.multiply(q);
        m = m.add(m2);
        return m;
    }

    public static BigInteger rsasp1(RSAPrivateKey privateKey, BigInteger m) throws IllegalBlockSizeException {
        BigInteger n = privateKey.getModulus();
        BigInteger nMinusOne = n.subtract(BigInteger.ONE);
        if (m.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalBlockSizeException("message too small");
        }
        if (m.compareTo(nMinusOne) > 0) {
            throw new IllegalBlockSizeException("message too large");
        }
        if (!(privateKey instanceof RSAPrivateCrtKey)) {
            BigInteger d = privateKey.getPrivateExponent();
            BigInteger s = m.modPow(d, n);
            return s;
        }
        RSAPrivateCrtKey K = (RSAPrivateCrtKey)privateKey;
        BigInteger p = K.getPrimeP();
        BigInteger q = K.getPrimeQ();
        BigInteger dP = K.getPrimeExponentP();
        BigInteger dQ = K.getPrimeExponentQ();
        BigInteger qInv = K.getCrtCoefficient();
        BigInteger s1 = m.modPow(dP, p);
        BigInteger s2 = m.modPow(dQ, q);
        BigInteger h = s1.subtract(s2);
        h = h.multiply(qInv);
        h = h.mod(p);
        BigInteger s = h.multiply(q);
        s = s.add(s2);
        return s;
    }

    public static BigInteger rsavp1(RSAPublicKey publicKey, BigInteger s) throws IllegalBlockSizeException {
        BigInteger n = publicKey.getModulus();
        BigInteger nMinusOne = n.subtract(BigInteger.ONE);
        if (s.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalBlockSizeException("message too small");
        }
        if (s.compareTo(nMinusOne) > 0) {
            throw new IllegalBlockSizeException("message too large");
        }
        BigInteger e = publicKey.getPublicExponent();
        BigInteger m = s.modPow(e, n);
        return m;
    }
}

