/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.rsa;

import com.isnetworks.provider.Padding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.crypto.IllegalBlockSizeException;

public class PKCS1SignaturePadding
implements Padding {
    private int mHLen;
    private byte[] mTDefault;
    public static final int SHA1 = 1;
    public static final int MD5 = 2;
    private static final byte[] SHA1_DIGEST_INFO = new byte[]{48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] MD5_DIGEST_INFO = new byte[]{48, 32, 48, 12, 6, 8, 42, -122, 72, -122, -9, 13, 2, 5, 5, 0, 4, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public PKCS1SignaturePadding(int hashAlgorithm) {
        String algorithmName = null;
        if (hashAlgorithm == 2) {
            algorithmName = "MD5";
            this.mTDefault = new byte[MD5_DIGEST_INFO.length];
            System.arraycopy(MD5_DIGEST_INFO, 0, this.mTDefault, 0, this.mTDefault.length);
            this.mHLen = 16;
        } else {
            algorithmName = "SHA";
            this.mTDefault = new byte[SHA1_DIGEST_INFO.length];
            System.arraycopy(SHA1_DIGEST_INFO, 0, this.mTDefault, 0, this.mTDefault.length);
            this.mHLen = 20;
        }
    }

    public PKCS1SignaturePadding() {
        this(1);
    }

    public byte[] encode(byte[] H, int emLen) throws IllegalBlockSizeException {
        if (emLen < this.mTDefault.length + 10) {
            throw new IllegalBlockSizeException("encoding too short");
        }
        byte[] T = new byte[this.mTDefault.length];
        System.arraycopy(this.mTDefault, 0, T, 0, T.length);
        System.arraycopy(H, 0, T, T.length - this.mHLen, this.mHLen);
        byte[] PS = new byte[emLen - T.length - 2];
        int i = 0;
        while (i < PS.length) {
            PS[i] = -1;
            ++i;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(1);
            baos.write(PS);
            baos.write(0);
            baos.write(T);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        byte[] EM = baos.toByteArray();
        return EM;
    }

    public byte[] decode(byte[] H) {
        throw new RuntimeException("Decode not used in PKCS1 Signature Padding");
    }
}

