/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.rsa;

import com.isnetworks.provider.Padding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;

public class PKCS1Padding
implements Padding {
    private SecureRandom mRandom;

    public PKCS1Padding(SecureRandom random) {
        this.mRandom = random;
    }

    public PKCS1Padding() {
        this(new SecureRandom());
    }

    public byte[] encode(byte[] M, int emLen) throws IllegalBlockSizeException {
        if (M.length > emLen - 10) {
            throw new IllegalBlockSizeException("message too long");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] PS = new byte[emLen - M.length - 2];
        int i = 0;
        while (i < PS.length) {
            PS[i] = (byte)(this.mRandom.nextInt(255) + 1);
            ++i;
        }
        try {
            baos.write(2);
            baos.write(PS);
            baos.write(0);
            baos.write(M);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        byte[] EM = baos.toByteArray();
        return EM;
    }

    public byte[] decode(byte[] EM) throws BadPaddingException {
        if (EM.length < 10) {
            throw new BadPaddingException("message too short");
        }
        if (EM[0] != 2) {
            throw new BadPaddingException("message not formatted properly");
        }
        int start = 0;
        while (EM[start] != 0) {
            if (++start < EM.length) continue;
            throw new BadPaddingException("bad padding");
        }
        if (++start < 10) {
            throw new BadPaddingException("bad padding");
        }
        byte[] M = new byte[EM.length - start];
        System.arraycopy(EM, start, M, 0, M.length);
        return M;
    }
}

