/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.rsa;

import com.isnetworks.provider.Padding;
import com.isnetworks.provider.rsa.MGF;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;

public class OAEPPadding
implements Padding {
    private MessageDigest mHasher;
    private int mHLen;
    private SecureRandom mRandom;
    private MGF mMask;
    private byte[] mPBytes;

    public OAEPPadding(SecureRandom random) {
        try {
            this.mHasher = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException nsae) {
            nsae.printStackTrace();
            throw new RuntimeException("No SHA-1 implementation found");
        }
        this.mHLen = this.mHasher.getDigestLength();
        this.mRandom = random;
        this.mMask = new MGF();
    }

    public OAEPPadding() {
        this(new SecureRandom());
    }

    public OAEPPadding(AlgorithmParameters P, SecureRandom random) throws InvalidAlgorithmParameterException {
        this(random);
        if (P != null) {
            try {
                this.mPBytes = P.getEncoded();
            }
            catch (IOException ioe) {
                throw new InvalidAlgorithmParameterException("Bad AlgorithmParameters");
            }
        }
    }

    public OAEPPadding(AlgorithmParameters P) throws InvalidAlgorithmParameterException {
        this(P, new SecureRandom());
    }

    public byte[] encode(byte[] M, int length) throws IllegalBlockSizeException {
        if (this.mPBytes == null) {
            this.mPBytes = new byte[0];
        }
        if (M.length > length - 2 * this.mHLen - 1) {
            throw new IllegalBlockSizeException("message too long");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] PS = new byte[length - M.length - 2 * this.mHLen - 1];
        this.mHasher.reset();
        byte[] pHash = this.mHasher.digest(this.mPBytes);
        try {
            baos.write(pHash);
            baos.write(PS);
            baos.write(1);
            baos.write(M);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        byte[] DB = baos.toByteArray();
        byte[] seed = new byte[this.mHLen];
        this.mRandom.nextBytes(seed);
        byte[] dbMask = this.mMask.generateMask(seed, length - this.mHLen);
        byte[] maskedDB = this.xor(DB, dbMask);
        byte[] seedMask = this.mMask.generateMask(maskedDB, this.mHLen);
        byte[] maskedSeed = this.xor(seed, seedMask);
        baos.reset();
        try {
            baos.write(maskedSeed);
            baos.write(maskedDB);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        byte[] EM = baos.toByteArray();
        return EM;
    }

    public byte[] decode(byte[] EM) throws BadPaddingException {
        if (EM.length < 2 * this.mHLen + 1) {
            throw new BadPaddingException("decoding error");
        }
        if (this.mPBytes == null) {
            this.mPBytes = new byte[0];
        }
        byte[] maskedSeed = new byte[this.mHLen];
        System.arraycopy(EM, 0, maskedSeed, 0, this.mHLen);
        byte[] maskedDB = new byte[EM.length - this.mHLen];
        System.arraycopy(EM, this.mHLen, maskedDB, 0, EM.length - this.mHLen);
        byte[] seedMask = this.mMask.generateMask(maskedDB, this.mHLen);
        byte[] seed = this.xor(maskedSeed, seedMask);
        byte[] dbMask = this.mMask.generateMask(seed, EM.length - this.mHLen);
        byte[] DB = this.xor(maskedDB, dbMask);
        this.mHasher.reset();
        byte[] pHash = this.mHasher.digest(this.mPBytes);
        byte[] pHashPrime = new byte[this.mHLen];
        System.arraycopy(DB, 0, pHashPrime, 0, this.mHLen);
        if (!this.areHashesEqual(pHash, pHashPrime)) {
            throw new BadPaddingException("hashing error");
        }
        int pos = this.mHLen;
        while (DB[pos] != 1 && DB[pos] == 0) {
            if (++pos < DB.length) continue;
            throw new BadPaddingException("no message found");
        }
        byte[] M = new byte[DB.length - ++pos];
        System.arraycopy(DB, pos, M, 0, DB.length - pos);
        return M;
    }

    private byte[] xor(byte[] firstArray, byte[] secondArray) {
        int length = Math.max(firstArray.length, secondArray.length);
        byte[] result = new byte[length];
        int i = 0;
        while (i < length) {
            result[i] = (byte)(firstArray[i] ^ secondArray[i]);
            ++i;
        }
        return result;
    }

    private boolean areHashesEqual(byte[] hash1, byte[] hash2) {
        int i = 0;
        while (i < hash1.length) {
            if (hash1[i] != hash2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

