/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.rsa;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MGF {
    private MessageDigest mHasher;
    private int mHLen;

    public MGF() {
        try {
            this.mHasher = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException nsae) {
            nsae.printStackTrace();
            throw new RuntimeException("No SHA-1 implementation found");
        }
        this.mHLen = this.mHasher.getDigestLength();
    }

    public byte[] generateMask(byte[] Z, int length) {
        int iterations = (int)Math.ceil((double)length / (double)this.mHLen);
        byte[] T = new byte[iterations * this.mHLen];
        this.mHasher.reset();
        int counter = 0;
        while (counter < iterations) {
            byte[] C = MGF.intToBytes(counter);
            this.mHasher.update(Z);
            this.mHasher.update(C);
            byte[] hash = this.mHasher.digest();
            System.arraycopy(hash, 0, T, counter * this.mHLen, this.mHLen);
            ++counter;
        }
        byte[] bytesToReturn = new byte[length];
        System.arraycopy(T, 0, bytesToReturn, 0, length);
        return bytesToReturn;
    }

    private static byte[] intToBytes(int i) {
        byte[] bytesToReturn = new byte[]{(byte)(i >>> 24), (byte)(i >>> 16), (byte)(i >>> 8), (byte)i};
        return bytesToReturn;
    }
}

