/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.pki;

import com.isnetworks.provider.asn1.AsnInteger;
import com.isnetworks.provider.asn1.DecodeException;
import com.isnetworks.provider.asn1.EncodeException;
import com.isnetworks.provider.asn1.OctetString;
import com.isnetworks.provider.asn1.pkcs1.Identifiers;
import com.isnetworks.provider.asn1.pkcs12.AuthenticatedSafe;
import com.isnetworks.provider.asn1.pkcs12.CertBag;
import com.isnetworks.provider.asn1.pkcs12.MacData;
import com.isnetworks.provider.asn1.pkcs12.PFX;
import com.isnetworks.provider.asn1.pkcs12.PKCS8ShroudedKeyBag;
import com.isnetworks.provider.asn1.pkcs12.SafeBag;
import com.isnetworks.provider.asn1.pkcs12.SafeContents;
import com.isnetworks.provider.asn1.pkcs7.ContentInfo;
import com.isnetworks.provider.asn1.pkcs7.Data;
import com.isnetworks.provider.asn1.pkcs9.LocalKeyId;
import com.isnetworks.provider.pkcs7.EncryptedDataContentInfo;
import com.isnetworks.provider.pki.AlgorithmMapperKojak;
import com.isnetworks.provider.pki.EncryptedPrivateKeyInfoWrapper;
import com.isnetworks.provider.pki.PKIException;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class PKCS12Wrapper {
    private PFX mPFX;
    private static final String DEFAULT_PBE_HMAC_ALGORITHM = "PBEWithHmacSHA1";

    public PKCS12Wrapper(PFX pfx) {
        this.mPFX = pfx;
    }

    public PKCS12Wrapper(byte[] pfxBytes) throws PKIException {
        try {
            this.mPFX = new PFX("pfx");
            this.mPFX.decode(pfxBytes);
        }
        catch (DecodeException e) {
            throw new PKIException("Unable to decode PKCS12", e);
        }
    }

    public PKCS12Wrapper(PrivateKey privateKey, Certificate certificate, char[] password) throws PKIException {
        this(privateKey, certificate, password, true);
    }

    public PKCS12Wrapper(PrivateKey privateKey, Certificate certificate, char[] password, boolean encryptCertificate) throws PKIException {
        this.mPFX = new PFX("pfx");
        this.mPFX.getVersion().setValue(AsnInteger.makeValue(3));
        this.addPrivateKey(privateKey, password);
        if (encryptCertificate) {
            this.addCertificate(certificate, password);
        } else {
            this.addCertificate(certificate);
        }
        this.createMAC(password);
    }

    public boolean hasMAC() {
        return !this.mPFX.getMacData().isDefaultValue();
    }

    public boolean verifyMAC(char[] password) throws PKIException {
        try {
            MacData macData = this.mPFX.getMacData();
            String algorithm = "PBEWithHmac" + AlgorithmMapperKojak.getJavaAlgorithm(macData.getMac().getDigestAlgorithm());
            Mac mac = Mac.getInstance(algorithm);
            int iterations = ((BigInteger)macData.getIterations().getDefaultValue()).intValue();
            if (!macData.getIterations().isDefaultValue()) {
                iterations = macData.getIterations().getIntValue();
            }
            PBEParameterSpec parameterSpec = new PBEParameterSpec((byte[])macData.getMacSalt().getValue(), iterations);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(algorithm);
            SecretKey secretKey = keyFactory.generateSecret(new PBEKeySpec(password));
            mac.init(secretKey, parameterSpec);
            byte[] contentsByte = (byte[])this.mPFX.getAuthSafe().getContent().getActual().getValue();
            byte[] macResult = mac.doFinal(contentsByte);
            byte[] desired = (byte[])macData.getMac().getDigest().getValue();
            return Arrays.equals(macResult, (byte[])macData.getMac().getDigest().getValue());
        }
        catch (NoSuchAlgorithmException e) {
            throw new PKIException("Couldn't find HMac algorithm", e);
        }
        catch (InvalidKeySpecException e) {
            throw new PKIException("SecretKeyFactory didn't like the PBEKeySpec", e);
        }
        catch (InvalidKeyException e) {
            throw new PKIException("MAC didn't like the key from the SecretKeyFactory", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new PKIException("MAC didn't like the PBEParameterSpec", e);
        }
    }

    public PrivateKey getPrivateKey(char[] password) throws PKIException {
        try {
            AuthenticatedSafe safe = this.mPFX.getAuthenticatedSafe();
            SafeBag safeBag = safe.getSafeBagInData(com.isnetworks.provider.asn1.pkcs12.Identifiers.pkcs8ShroudedKeyBag);
            if (safeBag == null) {
                return null;
            }
            EncryptedPrivateKeyInfoWrapper wrapper = new EncryptedPrivateKeyInfoWrapper((PKCS8ShroudedKeyBag)safeBag.getBagValue().getActual());
            return wrapper.getPrivateKey(password);
        }
        catch (DecodeException e) {
            throw new PKIException("Unable to ASN.1 decode a portion of the PFX", e);
        }
    }

    private void addAuthSafeContent(ContentInfo contentInfo) throws PKIException {
        try {
            if (this.mPFX.getAuthSafe().getContentType().getValue() == null) {
                this.mPFX.getAuthSafe().getContentType().copy(com.isnetworks.provider.asn1.pkcs7.Identifiers.data);
                Data data = new Data("data");
                this.mPFX.getAuthSafe().getContent().setActual(data);
            } else if (!this.mPFX.getAuthSafe().getContentType().equals(com.isnetworks.provider.asn1.pkcs7.Identifiers.data)) {
                throw new IllegalStateException("Adding more contents to a signed PFX is not currently supported");
            }
            this.clearMAC();
            AuthenticatedSafe safe = this.mPFX.getAuthenticatedSafe();
            safe.addComponent(contentInfo);
            this.mPFX.getAuthSafe().getContent().getActual().setValue(safe.encode());
        }
        catch (DecodeException e) {
            throw new PKIException("Unable to ASN.1 decode part of the PFX", e);
        }
        catch (EncodeException e) {
            throw new PKIException("Unable to ASN.1 encode the AuthenticatedSafe", e);
        }
    }

    private void addPrivateKey(PrivateKey privateKey, char[] password) throws PKIException {
        EncryptedPrivateKeyInfoWrapper wrapper = new EncryptedPrivateKeyInfoWrapper(privateKey, password);
        SafeBag safeBag = new SafeBag("safeBag");
        safeBag.getBagId().copy(com.isnetworks.provider.asn1.pkcs12.Identifiers.pkcs8ShroudedKeyBag);
        safeBag.getBagValue().setActual(wrapper.getEncryptedPrivateKeyInfo());
        byte[] localIdBytes = new byte[4];
        localIdBytes[0] = 1;
        LocalKeyId localId = new LocalKeyId("localKeyId");
        localId.setValue(localIdBytes);
        safeBag.addAttribute(com.isnetworks.provider.asn1.pkcs9.Identifiers.localKeyId, localId);
        SafeContents safeContents = new SafeContents("safeContents");
        safeContents.addComponent(safeBag);
        ContentInfo dataContentInfo = new ContentInfo("contentInfo");
        dataContentInfo.getContentType().copy(com.isnetworks.provider.asn1.pkcs7.Identifiers.data);
        try {
            Data content = new Data("data");
            content.setValue(safeContents.encode());
            dataContentInfo.getContent().setActual(content);
            this.addAuthSafeContent(dataContentInfo);
        }
        catch (EncodeException e) {
            throw new PKIException("Unable to ASN.1 encode the newly created SafeContents", e);
        }
    }

    private Certificate getCertificateFromSafeBag(SafeBag safeBag) throws PKIException {
        try {
            if (safeBag == null) {
                return null;
            }
            CertBag certBag = (CertBag)safeBag.getBagValue().getActual();
            if (!certBag.getCertId().equals(com.isnetworks.provider.asn1.pkcs12.Identifiers.x509Certificate)) {
                throw new PKIException("Unsupported certificate type");
            }
            byte[] certBytes = (byte[])((OctetString)certBag.getCertValue().getActual()).getValue();
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            return certFactory.generateCertificate(new ByteArrayInputStream(certBytes));
        }
        catch (CertificateException e) {
            throw new PKIException("Problem decoding the certificate, possibly a wrong password");
        }
    }

    public Certificate getCertificate() throws PKIException {
        try {
            AuthenticatedSafe safe = this.mPFX.getAuthenticatedSafe();
            SafeBag safeBag = safe.getSafeBagInData(com.isnetworks.provider.asn1.pkcs12.Identifiers.certBag);
            return this.getCertificateFromSafeBag(safeBag);
        }
        catch (DecodeException e) {
            throw new PKIException("Unable to ASN.1 decode the PKCS12 correctly", e);
        }
    }

    public Certificate getCertificate(char[] password) throws PKIException {
        try {
            AuthenticatedSafe safe = this.mPFX.getAuthenticatedSafe();
            ContentInfo contentInfo = safe.getFirstEncryptedData();
            if (contentInfo == null) {
                return null;
            }
            EncryptedDataContentInfo edci = new EncryptedDataContentInfo(contentInfo);
            byte[] plaintext = edci.getData(password);
            SafeContents contents = new SafeContents("safeContents");
            contents.decode(plaintext);
            SafeBag safeBag = contents.getSafeBag(com.isnetworks.provider.asn1.pkcs12.Identifiers.certBag);
            return this.getCertificateFromSafeBag(safeBag);
        }
        catch (DecodeException e) {
            throw new PKIException("Unable to ASN.1 decode part of the PFX", e);
        }
    }

    private SafeContents createCertificateSafeContents(Certificate cert) throws PKIException {
        try {
            OctetString certOctetString = new OctetString("certOctetString");
            certOctetString.setValue(cert.getEncoded());
            CertBag certBag = new CertBag("certBag");
            certBag.getCertId().copy(com.isnetworks.provider.asn1.pkcs12.Identifiers.x509Certificate);
            certBag.getCertValue().setActual(certOctetString);
            SafeBag safeBag = new SafeBag("safeBag");
            safeBag.getBagId().copy(com.isnetworks.provider.asn1.pkcs12.Identifiers.certBag);
            safeBag.getBagValue().setActual(certBag);
            byte[] localIdBytes = new byte[4];
            localIdBytes[0] = 1;
            LocalKeyId localId = new LocalKeyId("localKeyId");
            localId.setValue(localIdBytes);
            safeBag.addAttribute(com.isnetworks.provider.asn1.pkcs9.Identifiers.localKeyId, localId);
            SafeContents safeContents = new SafeContents("safeContents");
            safeContents.addComponent(safeBag);
            return safeContents;
        }
        catch (CertificateEncodingException e) {
            throw new PKIException("Unable to encode the certificate", e);
        }
    }

    private void addCertificate(Certificate cert) throws PKIException {
        try {
            SafeContents safeContents = this.createCertificateSafeContents(cert);
            Data data = new Data("data");
            data.setValue(safeContents.encode());
            ContentInfo contentInfo = new ContentInfo("contentInfo");
            contentInfo.getContentType().copy(com.isnetworks.provider.asn1.pkcs7.Identifiers.data);
            contentInfo.getContent().setActual(data);
            this.addAuthSafeContent(contentInfo);
        }
        catch (EncodeException e) {
            throw new PKIException("Unable to ASN.1 encode the newly created SafeContents", e);
        }
    }

    private void addCertificate(Certificate cert, char[] password) throws PKIException {
        try {
            SafeContents safeContents = this.createCertificateSafeContents(cert);
            EncryptedDataContentInfo edci = new EncryptedDataContentInfo();
            edci.setData(safeContents.encode(), password);
            this.addAuthSafeContent(edci.getContentInfo());
        }
        catch (EncodeException e) {
            throw new PKIException("Unable to ASN.1 encode the newly created SafeContents", e);
        }
    }

    private void createMAC(char[] password) throws PKIException {
        try {
            MacData macData = this.mPFX.getMacData();
            SecureRandom random = new SecureRandom();
            byte[] salt = new byte[8];
            random.nextBytes(salt);
            macData.getMacSalt().setValue(salt);
            macData.getIterations().setValue(AsnInteger.makeValue(1));
            PBEParameterSpec parameterSpec = new PBEParameterSpec(salt, 1);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(DEFAULT_PBE_HMAC_ALGORITHM);
            SecretKey secretKey = keyFactory.generateSecret(new PBEKeySpec(password));
            Mac mac = Mac.getInstance(DEFAULT_PBE_HMAC_ALGORITHM);
            mac.init(secretKey, parameterSpec);
            byte[] contentsByte = (byte[])this.mPFX.getAuthSafe().getContent().getActual().getValue();
            byte[] macResult = mac.doFinal(contentsByte);
            macData.getMac().getDigestAlgorithm().getAlgorithm().copy(Identifiers.id_SHA1);
            macData.getMac().getDigest().setValue(macResult);
        }
        catch (NoSuchAlgorithmException e) {
            throw new PKIException("Unable to find algorithm: PBEWithHmacSHA1");
        }
        catch (InvalidKeySpecException e) {
            throw new PKIException("SecretKeyFactory doesn't like the PBEKeySpec", e);
        }
        catch (InvalidKeyException e) {
            throw new PKIException("MAC doesn't like the key from the SecretKeyFactory", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new PKIException("MAC doesn't like the PBEParameterSpec", e);
        }
    }

    private void clearMAC() {
        MacData macData = new MacData("macData");
        this.mPFX.getMacData().copy(macData);
    }

    public byte[] encode() throws EncodeException {
        return this.mPFX.encode();
    }
}

