/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.pki;

import com.isnetworks.provider.asn1.AsnInteger;
import com.isnetworks.provider.asn1.DecodeException;
import com.isnetworks.provider.asn1.EncodeException;
import com.isnetworks.provider.asn1.pkcs12.PKCS12PBEParams;
import com.isnetworks.provider.asn1.pkcs8.EncryptedPrivateKeyInfo;
import com.isnetworks.provider.asn1.pkcs8.PrivateKeyInfo;
import com.isnetworks.provider.pki.AlgorithmMapperKojak;
import com.isnetworks.provider.pki.PKIException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class EncryptedPrivateKeyInfoWrapper {
    private EncryptedPrivateKeyInfo mEPKI;
    private static final int DEFAULT_ITERATION_COUNT = 2000;
    private static final String DEFAULT_PBE_ALGORITHM = "PBEWithSHA1AndTripleDES";

    public EncryptedPrivateKeyInfoWrapper(EncryptedPrivateKeyInfo epki) {
        this.mEPKI = epki;
    }

    public EncryptedPrivateKeyInfoWrapper(PrivateKey privateKey, char[] password) throws PKIException {
        this.mEPKI = new EncryptedPrivateKeyInfo("encryptedPrivateKeyInfo");
        if (!privateKey.getAlgorithm().equals("RSA")) {
            throw new IllegalArgumentException("Only RSA keys are currently supported");
        }
        try {
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(DEFAULT_PBE_ALGORITHM);
            SecretKey secretKey = secretKeyFactory.generateSecret(new PBEKeySpec(password));
            SecureRandom random = new SecureRandom();
            byte[] saltBytes = new byte[8];
            random.nextBytes(saltBytes);
            PBEParameterSpec paramSpec = new PBEParameterSpec(saltBytes, 2000);
            Cipher cipher = Cipher.getInstance("PBEWithSHA1AndTripleDES/CBC/PKCS5Padding");
            cipher.init(1, (Key)secretKey, paramSpec);
            PrivateKeyInfo pki = new PrivateKeyInfo("privateKeyInfo");
            pki.decode(privateKey.getEncoded());
            byte[] plaintext = pki.encode();
            byte[] ciphertext = cipher.doFinal(plaintext);
            PKCS12PBEParams params = new PKCS12PBEParams("pkcs12PBEParams");
            params.getSalt().setValue(saltBytes);
            params.getIterations().setValue(AsnInteger.makeValue(2000));
            this.mEPKI.getEncryptionAlgorithm().getParameters().setActual(params);
            this.mEPKI.getEncryptionAlgorithm().getAlgorithm().copy(AlgorithmMapperKojak.getAlgorithmId(DEFAULT_PBE_ALGORITHM));
            this.mEPKI.getEncryptedData().setValue(ciphertext);
        }
        catch (NoSuchAlgorithmException e) {
            throw new PKIException("Can't find PBE algorithm", e);
        }
        catch (InvalidKeySpecException e) {
            throw new PKIException("SecretKeyFactory doesn't like the PBEKeySpec", e);
        }
        catch (InvalidKeyException e) {
            throw new PKIException("Cipher doesn't like the key from the SecretKeyFactory", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new PKIException("Wrong block size", e);
        }
        catch (NoSuchPaddingException e) {
            throw new PKIException("Can't find PKCS5Padding", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new PKIException("Cipher doesn't like PBEParameterSpec", e);
        }
        catch (BadPaddingException e) {
            throw new PKIException("Problem with padding, this shouldn't be happening on encrypt", e);
        }
        catch (DecodeException e) {
            throw new PKIException("Can't decode encoded bytes of PrivateKey", e);
        }
        catch (EncodeException e) {
            throw new PKIException("Can't encode PrivateKeyInfo", e);
        }
    }

    public PrivateKey getPrivateKey(char[] password) throws PKIException {
        try {
            String algorithm = AlgorithmMapperKojak.getJavaAlgorithm(this.mEPKI.getEncryptionAlgorithm());
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(algorithm);
            SecretKey secretKey = secretKeyFactory.generateSecret(new PBEKeySpec(password));
            PKCS12PBEParams params = (PKCS12PBEParams)this.mEPKI.getEncryptionAlgorithm().getParameters().getActual();
            PBEParameterSpec paramSpec = new PBEParameterSpec((byte[])params.getSalt().getValue(), params.getIterations().getIntValue());
            Cipher cipher = Cipher.getInstance(algorithm + "/CBC/PKCS5Padding");
            cipher.init(2, (Key)secretKey, paramSpec);
            byte[] plaintext = cipher.doFinal((byte[])this.mEPKI.getEncryptedData().getValue());
            PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo("privateKeyInfo");
            privateKeyInfo.decode(plaintext);
            KeyFactory keyFactory = KeyFactory.getInstance(AlgorithmMapperKojak.getJavaAlgorithm(privateKeyInfo.getPrivateKeyAlgorithm()));
            PKCS8EncodedKeySpec encodedKeySpec = new PKCS8EncodedKeySpec(plaintext);
            return keyFactory.generatePrivate(encodedKeySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new PKIException("Unable to find algorithm", e);
        }
        catch (InvalidKeySpecException e) {
            throw new PKIException("KeySpec invalid", e);
        }
        catch (NoSuchPaddingException e) {
            throw new PKIException("Can't find PKCS5Padding", e);
        }
        catch (InvalidKeyException e) {
            throw new PKIException("Cipher not happy with PBE key", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new PKIException("Encrypted data not of multiple of block length", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new PKIException("Cipher not happy with PBEParameterSpec", e);
        }
        catch (BadPaddingException e) {
            throw new PKIException("Encrypted data not padded correctly, the password is most likely incorrect", e);
        }
        catch (DecodeException e) {
            throw new PKIException("Unable to ASN.1 decode plaintext, the password is most likely incorrect", e);
        }
    }

    public EncryptedPrivateKeyInfo getEncryptedPrivateKeyInfo() {
        return this.mEPKI;
    }
}

