/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.pki;

import com.isnetworks.provider.asn1.ObjectIdentifier;
import com.isnetworks.provider.asn1.cms.Identifiers;
import com.isnetworks.provider.asn1.x509.AlgorithmIdentifier;
import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;

public class AlgorithmMapperKojak {
    private static Hashtable ID_TO_STRING = new Hashtable();
    private static Hashtable STRING_TO_ID = new Hashtable();

    private static void addMapping(String name, ObjectIdentifier oid) {
        ID_TO_STRING.put(oid, name);
        STRING_TO_ID.put(name.toUpperCase(), oid);
    }

    private AlgorithmMapperKojak() {
    }

    public static String getJavaAlgorithm(AlgorithmIdentifier digest, AlgorithmIdentifier signature) throws NoSuchAlgorithmException {
        return AlgorithmMapperKojak.getJavaAlgorithm(digest) + "with" + AlgorithmMapperKojak.getJavaAlgorithm(signature);
    }

    public static String getJavaAlgorithm(AlgorithmIdentifier algid) throws NoSuchAlgorithmException {
        return AlgorithmMapperKojak.getJavaAlgorithm(algid.getAlgorithm());
    }

    public static String getJavaAlgorithm(ObjectIdentifier oid) throws NoSuchAlgorithmException {
        String result = (String)ID_TO_STRING.get(oid);
        if (result != null) {
            return result;
        }
        throw new NoSuchAlgorithmException(oid.toString() + "(" + oid.getIdentifier() + ")");
    }

    public static ObjectIdentifier getDigestAlgorithmId(String algorithm) throws NoSuchAlgorithmException {
        try {
            return AlgorithmMapperKojak.getAlgorithmId(algorithm.substring(0, algorithm.indexOf("with")));
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchAlgorithmException("Can't find digest algorithm for " + algorithm);
        }
    }

    public static ObjectIdentifier getEncryptionAlgorithmId(String algorithm) throws NoSuchAlgorithmException {
        try {
            return AlgorithmMapperKojak.getAlgorithmId(algorithm.substring(algorithm.indexOf("with") + "with".length()));
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchAlgorithmException("Can't find encryption algorithm for " + algorithm);
        }
    }

    public static ObjectIdentifier getAlgorithmId(String algorithm) throws NoSuchAlgorithmException {
        ObjectIdentifier oid = (ObjectIdentifier)STRING_TO_ID.get(algorithm.toUpperCase());
        if (oid != null) {
            return oid;
        }
        throw new NoSuchAlgorithmException(algorithm);
    }

    static {
        AlgorithmMapperKojak.addMapping("SHA1", com.isnetworks.provider.asn1.pkcs1.Identifiers.id_SHA1);
        AlgorithmMapperKojak.addMapping("MD2", com.isnetworks.provider.asn1.pkcs1.Identifiers.md2);
        AlgorithmMapperKojak.addMapping("MD5", com.isnetworks.provider.asn1.pkcs1.Identifiers.md5);
        AlgorithmMapperKojak.addMapping("SHA1withRSA", com.isnetworks.provider.asn1.pkcs1.Identifiers.sha1WithRSAEncryption);
        AlgorithmMapperKojak.addMapping("MD2withRSA", com.isnetworks.provider.asn1.pkcs1.Identifiers.md2WithRSAEncryption);
        AlgorithmMapperKojak.addMapping("MD5withRSA", com.isnetworks.provider.asn1.pkcs1.Identifiers.md5WithRSAEncryption);
        AlgorithmMapperKojak.addMapping("RSA", com.isnetworks.provider.asn1.pkcs1.Identifiers.rsaEncryption);
        AlgorithmMapperKojak.addMapping("TripleDES", Identifiers.des_ede3_cbc);
        AlgorithmMapperKojak.addMapping("DESede", Identifiers.des_ede3_cbc);
        AlgorithmMapperKojak.addMapping("DSA", Identifiers.dsa);
        AlgorithmMapperKojak.addMapping("DSAwithSHA1", Identifiers.id_dsa_with_sha1);
        AlgorithmMapperKojak.addMapping("RC2", Identifiers.rc2_cbc);
        AlgorithmMapperKojak.addMapping("DES", com.isnetworks.provider.asn1.pkcs7.Identifiers.desCBC);
        AlgorithmMapperKojak.addMapping("PBEWithSHA1AndTripleDES", com.isnetworks.provider.asn1.pkcs12.Identifiers.pbeWithSHAAnd3_KeyTripleDES_CBC);
        AlgorithmMapperKojak.addMapping("PBEWithSHA1And40BitRC2", com.isnetworks.provider.asn1.pkcs12.Identifiers.pbewithSHAAnd40BitRC2_CBC);
    }
}

