/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.pkcs7;

import com.isnetworks.provider.asn1.AbstractAsnObject;
import com.isnetworks.provider.asn1.AsnInteger;
import com.isnetworks.provider.asn1.DecodeException;
import com.isnetworks.provider.asn1.EncodeException;
import com.isnetworks.provider.asn1.ObjectIdentifier;
import com.isnetworks.provider.asn1.TypeMapper;
import com.isnetworks.provider.asn1.pkcs12.PKCS12PBEParams;
import com.isnetworks.provider.asn1.pkcs7.ContentEncryptionAlgorithmIdentifier;
import com.isnetworks.provider.asn1.pkcs7.ContentInfo;
import com.isnetworks.provider.asn1.pkcs7.EncryptedContentInfo;
import com.isnetworks.provider.asn1.pkcs7.EncryptedData;
import com.isnetworks.provider.asn1.pkcs7.Identifiers;
import com.isnetworks.provider.pki.AlgorithmMapperKojak;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class EncryptedDataContentInfo {
    private ContentInfo mContentInfo;
    private EncryptedData mEncryptedData;
    private static final int DEFAULT_ITERATION_COUNT = 2000;
    private static final String DEFAULT_PBE_ALGORITHM = "PBEWithSHA1AndTripleDES";

    public EncryptedDataContentInfo() {
        this.mEncryptedData = new EncryptedData("encryptedData");
        this.mEncryptedData.getVersion().setValue(AsnInteger.makeValue(0));
        this.mEncryptedData.getEncryptedContentInfo().getContentType().setValue(Identifiers.data.getValue());
        this.mContentInfo = new ContentInfo("contentInfo");
        this.mContentInfo.getContentType().copy(Identifiers.encryptedData);
        this.mContentInfo.getContent().setActual(this.mEncryptedData);
    }

    public EncryptedDataContentInfo(ContentInfo contentInfo) {
        this.mContentInfo = contentInfo;
        this.mEncryptedData = (EncryptedData)contentInfo.getContent().getActual();
    }

    public void setData(byte[] plaintext, char[] password) throws EncodeException {
        this.setData(plaintext, password, DEFAULT_PBE_ALGORITHM, 2000);
    }

    public void setData(byte[] plaintext, char[] password, String algorithmName, int iterationCount) throws EncodeException {
        SecureRandom random = new SecureRandom();
        byte[] salt = new byte[8];
        random.nextBytes(salt);
        EncryptedContentInfo encryptedContentInfo = this.mEncryptedData.getEncryptedContentInfo();
        encryptedContentInfo.getContentType().copy(Identifiers.data);
        PKCS12PBEParams parameters = new PKCS12PBEParams("PKCS12PBEParams");
        parameters.getSalt().setValue(salt);
        parameters.getIterations().setValue(AsnInteger.makeValue(iterationCount));
        ContentEncryptionAlgorithmIdentifier algId = encryptedContentInfo.getContentEncryptionAlgorithm();
        algId.getParameters().setActual(parameters);
        try {
            algId.getAlgorithm().copy(AlgorithmMapperKojak.getAlgorithmId(algorithmName));
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(algorithmName);
            SecretKey secretKey = keyFactory.generateSecret(new PBEKeySpec(password));
            PBEParameterSpec paramSpec = new PBEParameterSpec(salt, iterationCount);
            Cipher cipher = Cipher.getInstance(algorithmName + "/CBC/PKCS5Padding");
            cipher.init(1, (Key)secretKey, paramSpec);
            byte[] ciphertext = cipher.doFinal(plaintext);
            encryptedContentInfo.getEncryptedContent().setValue(ciphertext);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncodeException("Could not find necessary algorithm - PBEWithSHA1AndTripleDES", e);
        }
        catch (InvalidKeySpecException e) {
            throw new EncodeException("Problem with SecretKeyFactory", e);
        }
        catch (InvalidKeyException e) {
            throw new EncodeException("Key generated by SecretKeyFactory is not compatible with Cipher", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new EncodeException("Problem with padding in cipher", e);
        }
        catch (NoSuchPaddingException e) {
            throw new EncodeException("Unable to find PKCS5Padding", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new EncodeException("Cipher doesn't want to play with PBEParameterSpec", e);
        }
        catch (BadPaddingException e) {
            throw new EncodeException("Problem with padding in cipher", e);
        }
    }

    public byte[] getData(char[] password) throws DecodeException {
        EncryptedContentInfo encryptedContentInfo = this.mEncryptedData.getEncryptedContentInfo();
        ContentEncryptionAlgorithmIdentifier algId = encryptedContentInfo.getContentEncryptionAlgorithm();
        PKCS12PBEParams parameters = (PKCS12PBEParams)algId.getParameters().getActual();
        PBEParameterSpec paramSpec = new PBEParameterSpec((byte[])parameters.getSalt().getValue(), parameters.getIterations().getIntValue());
        byte[] ciphertext = (byte[])encryptedContentInfo.getEncryptedContent().getValue();
        try {
            String algorithmName = AlgorithmMapperKojak.getJavaAlgorithm(algId);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(algorithmName);
            SecretKey secretKey = keyFactory.generateSecret(new PBEKeySpec(password));
            Cipher cipher = Cipher.getInstance(algorithmName + "/CBC/PKCS5Padding");
            cipher.init(2, (Key)secretKey, paramSpec);
            return cipher.doFinal(ciphertext);
        }
        catch (NoSuchAlgorithmException e) {
            throw new DecodeException("Unable to find algorithm specified in ASN object", e);
        }
        catch (InvalidKeySpecException e) {
            throw new DecodeException("Problem with SecretKeyFactory", e);
        }
        catch (InvalidKeyException e) {
            throw new DecodeException("Key generated by SecretKeyFactory is not compatible with Cipher", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new DecodeException("Problem with padding in cipher", e);
        }
        catch (NoSuchPaddingException e) {
            throw new DecodeException("Unable to find PKCS5Padding", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new DecodeException("Cipher doesn't want to play with PBEParameterSpec", e);
        }
        catch (BadPaddingException e) {
            throw new DecodeException("Problem with padding in cipher", e);
        }
    }

    public void decode(byte[] data) throws DecodeException {
        this.decode(data, false);
    }

    public void decode(byte[] data, boolean trace) throws DecodeException {
        this.decode(data, null, trace);
    }

    public void decode(byte[] data, TypeMapper clientTypeMapper, boolean trace) throws DecodeException {
        AuthAttrTypeMapper authTypeMapper = new AuthAttrTypeMapper(clientTypeMapper);
        this.mContentInfo = new ContentInfo("contentInfo");
        this.mContentInfo.setAuthenticatedTypeMapper(authTypeMapper);
        AbstractAsnObject.setTraceEnable(trace);
        AbstractAsnObject.setTracePrefix(trace ? " < " : " ");
        this.mContentInfo.decode(data);
        if (!Identifiers.encryptedData.equals(this.mContentInfo.getContentType())) {
            this.mEncryptedData = null;
            throw new DecodeException("contentType of decoded PKCS#7 message must be encryptedData");
        }
        this.mEncryptedData = (EncryptedData)this.mContentInfo.getContent().getActual();
    }

    public byte[] encode() throws EncodeException {
        return this.encode(false);
    }

    public byte[] encode(boolean traceEnable) throws EncodeException {
        AbstractAsnObject.setTraceEnable(traceEnable);
        AbstractAsnObject.setTracePrefix(traceEnable ? " > " : " ");
        return this.mContentInfo.encode();
    }

    public ContentInfo getContentInfo() {
        return this.mContentInfo;
    }

    public class AuthAttrTypeMapper
    implements TypeMapper {
        private TypeMapper mClientTypeMapper;
        static /* synthetic */ Class class$com$isnetworks$provider$asn1$pkcs7$ContentType;

        public AuthAttrTypeMapper() {
            this(null);
        }

        public AuthAttrTypeMapper(TypeMapper clientTypeMapper) {
            this.mClientTypeMapper = clientTypeMapper;
        }

        public Class getActualClass(ObjectIdentifier oid) {
            Class actualClass = null;
            if (this.mClientTypeMapper != null) {
                actualClass = this.mClientTypeMapper.getActualClass(oid);
            }
            if (actualClass == null && oid.equals(com.isnetworks.provider.asn1.pkcs9.Identifiers.contentType)) {
                actualClass = class$com$isnetworks$provider$asn1$pkcs7$ContentType == null ? (class$com$isnetworks$provider$asn1$pkcs7$ContentType = AuthAttrTypeMapper.class$("com.isnetworks.provider.asn1.pkcs7.ContentType")) : class$com$isnetworks$provider$asn1$pkcs7$ContentType;
            }
            return actualClass;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

