/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.pbe;

import com.isnetworks.provider.pbe.AbstractPBEKeyConvertor;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.spec.PBEParameterSpec;

public class PKCS5_2KeyConvertor
extends AbstractPBEKeyConvertor {
    public PKCS5_2KeyConvertor(String hashAlgorithm, int keySizeInBytes) {
        super(hashAlgorithm, keySizeInBytes, 0);
    }

    public byte[] getKeyBytes(Key key, PBEParameterSpec paramSpec) {
        int l = (int)Math.ceil((double)this.mKeySizeInBytes / (double)this.mHashSizeInBytes);
        int r = this.mKeySizeInBytes - (l - 1) * this.mHashSizeInBytes;
        byte[] keyMaterial = new byte[]{};
        int i = 1;
        while (i <= l) {
            keyMaterial = this.concat(keyMaterial, this.F(key.getEncoded(), paramSpec.getSalt(), paramSpec.getIterationCount(), i));
            ++i;
        }
        byte[] result = new byte[this.mKeySizeInBytes];
        System.arraycopy(keyMaterial, 0, result, 0, this.mKeySizeInBytes);
        return result;
    }

    public byte[] getIVBytes(Key key, PBEParameterSpec paramSpec) {
        throw new UnsupportedOperationException("PBES2 doesn't define anything for IVs");
    }

    public byte[] getMACBytes(Key key, PBEParameterSpec paramSpec) {
        throw new UnsupportedOperationException();
    }

    private byte[] F(byte[] password, byte[] salt, int iterationCount, int i) {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance(this.mHashAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Can't find hash algorithm: " + this.mHashAlgorithm);
        }
        digest.update(password);
        digest.update(salt);
        digest.update((byte)(i >> 24 & 0xFF));
        digest.update((byte)(i >> 16 & 0xFF));
        digest.update((byte)(i >> 8 & 0xFF));
        digest.update((byte)(i >> 0 & 0xFF));
        byte[] result = digest.digest();
        int j = 1;
        while (j < iterationCount) {
            digest.update(password);
            result = this.xor(result, digest.digest(result));
            ++j;
        }
        return result;
    }

    private byte[] xor(byte[] a, byte[] b) {
        byte[] result = new byte[a.length];
        int i = 0;
        while (i < a.length) {
            result[i] = (byte)(a[i] ^ b[i]);
            ++i;
        }
        return result;
    }
}

