/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.pbe;

import com.isnetworks.provider.pbe.AbstractPBEKeyConvertor;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.spec.PBEParameterSpec;

public class PKCS5_1KeyConvertor
extends AbstractPBEKeyConvertor {
    public PKCS5_1KeyConvertor(String hashAlgorithm) {
        super(hashAlgorithm, 8, 8);
    }

    public byte[] getKeyBytes(Key key, PBEParameterSpec paramSpec) {
        byte[] bytes = this.convert(key, paramSpec);
        byte[] keyBytes = new byte[this.mKeySizeInBytes];
        System.arraycopy(bytes, 0, keyBytes, 0, this.mKeySizeInBytes);
        return keyBytes;
    }

    public byte[] getIVBytes(Key key, PBEParameterSpec paramSpec) {
        byte[] bytes = this.convert(key, paramSpec);
        byte[] ivBytes = new byte[this.mIVSizeInBytes];
        System.arraycopy(bytes, this.mKeySizeInBytes, ivBytes, 0, this.mIVSizeInBytes);
        return ivBytes;
    }

    public byte[] getMACBytes(Key key, PBEParameterSpec paramSpec) {
        throw new UnsupportedOperationException();
    }

    private byte[] convert(Key key, PBEParameterSpec paramSpec) {
        byte[] input = this.concat(key.getEncoded(), paramSpec.getSalt());
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance(this.mHashAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Can't find hash algorithm: " + this.mHashAlgorithm);
        }
        int i = 0;
        while (i < paramSpec.getIterationCount()) {
            input = digest.digest(input);
            ++i;
        }
        byte[] result = new byte[16];
        System.arraycopy(input, 0, result, 0, 16);
        return result;
    }
}

