/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.pbe;

import com.isnetworks.provider.pbe.AbstractPBEKeyConvertor;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.spec.PBEParameterSpec;

public class PKCS12KeyConvertor
extends AbstractPBEKeyConvertor {
    private static final byte KEY_MATERIAL = 1;
    private static final byte IV = 2;
    private static final byte MAC = 3;

    public PKCS12KeyConvertor(String hashAlgorithm, int keySizeInBytes, int ivSizeInBytes) {
        super(hashAlgorithm, keySizeInBytes, ivSizeInBytes);
    }

    public byte[] getKeyBytes(Key key, PBEParameterSpec paramSpec) {
        return this.convert(key, paramSpec, (byte)1, this.mKeySizeInBytes);
    }

    public byte[] getIVBytes(Key key, PBEParameterSpec paramSpec) {
        return this.convert(key, paramSpec, (byte)2, this.mIVSizeInBytes);
    }

    public byte[] getMACBytes(Key key, PBEParameterSpec paramSpec) {
        return this.convert(key, paramSpec, (byte)3, 20);
    }

    private byte[] convert(Key key, PBEParameterSpec paramSpec, byte id, int byteOutputCount) {
        int r = paramSpec.getIterationCount();
        byte[] d = new byte[64];
        int i = 0;
        while (i < d.length) {
            d[i] = id;
            ++i;
        }
        byte[] salt = paramSpec.getSalt();
        byte[] saltConcatenated = this.concatToLength(salt, (int)Math.ceil((double)salt.length / 64.0) * 64);
        byte[] keyBytes = key.getEncoded();
        byte[] keyConcatenated = this.concatToLength(keyBytes, (int)Math.ceil((double)keyBytes.length / 64.0) * 64);
        byte[] i2 = this.concat(saltConcatenated, keyConcatenated);
        int c = (int)Math.ceil((double)byteOutputCount / (double)this.mHashSizeInBytes);
        byte[][] a = new byte[c][];
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance(this.mHashAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Can't find hash algorithm: " + this.mHashAlgorithm);
        }
        int j = 0;
        while (j < c) {
            byte[] input = this.concat(d, i2);
            int k = 0;
            while (k < r) {
                input = digest.digest(input);
                ++k;
            }
            a[j] = input;
            byte[] b = this.concatToLength(input, 64);
            int k2 = 0;
            while (k2 < i2.length / 64) {
                int aOff = k2 * 64;
                int x = this.fixByte(b[b.length - 1]) + this.fixByte(i2[aOff + b.length - 1]) + 1;
                i2[aOff + b.length - 1] = (byte)x;
                x >>>= 8;
                int l = b.length - 2;
                while (l >= 0) {
                    i2[aOff + l] = (byte)(x += this.fixByte(b[l]) + this.fixByte(i2[aOff + l]));
                    x >>>= 8;
                    --l;
                }
                ++k2;
            }
            ++j;
        }
        byte[] randomBytes = new byte[]{};
        int j2 = 0;
        while (j2 < c) {
            randomBytes = this.concat(randomBytes, a[j2]);
            ++j2;
        }
        byte[] result = new byte[byteOutputCount];
        int x = 0;
        while (x < randomBytes.length) {
            ++x;
        }
        System.arraycopy(randomBytes, 0, result, 0, byteOutputCount);
        return result;
    }
}

