/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.pbe;

import com.isnetworks.provider.Util;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class PBKeyDerivation2 {
    private Mac mHMac;

    public PBKeyDerivation2() {
        try {
            this.mHMac = Mac.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError("No SHA-1 HMac installed");
        }
    }

    public byte[] generateKey(byte[] password, byte[] salt, int iterationCount, int dkLen) throws InvalidKeyException {
        int hLen = this.mHMac.getMacLength();
        int numBlocks = (dkLen + hLen - 1) / hLen;
        byte[] workingBlock = new byte[numBlocks * hLen];
        int i = 1;
        while (i <= numBlocks) {
            byte[] temp = this.F(password, salt, iterationCount, i);
            System.arraycopy(temp, 0, workingBlock, (i - 1) * hLen, temp.length);
            ++i;
        }
        byte[] result = new byte[dkLen];
        System.arraycopy(workingBlock, 0, result, 0, result.length);
        return result;
    }

    private byte[] F(byte[] password, byte[] salt, int iterationCount, int i) throws InvalidKeyException {
        byte[] iBytes = Util.intToBytes(i);
        SecretKeySpec key = new SecretKeySpec(password, "HMac");
        this.mHMac.init(key);
        this.mHMac.update(salt);
        this.mHMac.update(iBytes);
        byte[] workingBuffer = this.mHMac.doFinal();
        byte[] u = new byte[workingBuffer.length];
        System.arraycopy(workingBuffer, 0, u, 0, workingBuffer.length);
        int iteration = 2;
        while (iteration <= iterationCount) {
            this.mHMac.init(key);
            this.mHMac.update(u);
            byte[] newU = this.mHMac.doFinal();
            int j = 0;
            while (j < workingBuffer.length) {
                int n = j;
                workingBuffer[n] = (byte)(workingBuffer[n] ^ newU[j]);
                ++j;
            }
            System.arraycopy(newU, 0, u, 0, newU.length);
            ++iteration;
        }
        return workingBuffer;
    }
}

