/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.pbe;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class PBKeyDerivation1 {
    private MessageDigest mDigest;

    public PBKeyDerivation1(String messageDigestAlgorithm) throws NoSuchAlgorithmException {
        this.mDigest = MessageDigest.getInstance(messageDigestAlgorithm);
    }

    public byte[] generateKey(byte[] password, byte[] salt, int iterationCount, int dkLen) {
        if (dkLen > this.mDigest.getDigestLength()) {
            throw new IllegalArgumentException("Keysize must be less than or equal to the hash length");
        }
        this.mDigest.reset();
        byte[] workingHash = new byte[password.length + salt.length];
        System.arraycopy(password, 0, workingHash, 0, password.length);
        System.arraycopy(salt, 0, workingHash, password.length, salt.length);
        int i = 0;
        while (i < iterationCount) {
            workingHash = this.mDigest.digest(workingHash);
            ++i;
        }
        byte[] result = new byte[dkLen];
        System.arraycopy(workingHash, 0, result, 0, result.length);
        return result;
    }
}

