/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.pbe;

import com.isnetworks.provider.pbe.PBEKeyConvertor;
import java.security.Key;
import javax.crypto.spec.PBEParameterSpec;

public abstract class AbstractPBEKeyConvertor
implements PBEKeyConvertor {
    protected static final int BLOCK_SIZE = 64;
    protected String mHashAlgorithm;
    protected int mKeySizeInBytes;
    protected int mHashSizeInBytes;
    protected int mIVSizeInBytes;

    public AbstractPBEKeyConvertor(String hashAlgorithm, int keySizeInBytes, int ivSizeInBytes) {
        this.mHashAlgorithm = hashAlgorithm;
        this.mKeySizeInBytes = keySizeInBytes;
        this.mIVSizeInBytes = ivSizeInBytes;
        if (hashAlgorithm.equals("MD5")) {
            this.mHashSizeInBytes = 16;
        } else if (hashAlgorithm.equals("SHA1")) {
            this.mHashSizeInBytes = 20;
        } else {
            throw new IllegalArgumentException("Unknown hash algorithm: " + hashAlgorithm);
        }
    }

    protected int fixByte(byte b) {
        if (b >= 0) {
            return b;
        }
        return b + 256;
    }

    protected byte[] concatToLength(byte[] b, int length) {
        byte[] result = new byte[length];
        int offset = 0;
        while (offset < result.length) {
            System.arraycopy(b, 0, result, offset, Math.min(b.length, result.length - offset));
            offset += b.length;
        }
        return result;
    }

    protected byte[] concat(byte[] a, byte[] b) {
        byte[] result = new byte[a.length + b.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }

    public abstract byte[] getMACBytes(Key var1, PBEParameterSpec var2);

    public abstract byte[] getIVBytes(Key var1, PBEParameterSpec var2);

    public abstract byte[] getKeyBytes(Key var1, PBEParameterSpec var2);
}

