/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.mac;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public abstract class HmacKeyGenerator
extends KeyGeneratorSpi {
    private SecureRandom mRandom;
    private int mKeySize;
    private int mMinimumKeySize;
    private String mAlgorithmName;

    public HmacKeyGenerator(int keySize, String algorithmName) {
        this.mKeySize = keySize;
        this.mMinimumKeySize = keySize;
        this.mAlgorithmName = algorithmName;
        this.mRandom = new SecureRandom();
    }

    protected SecretKey engineGenerateKey() {
        byte[] keyBytes = new byte[this.mKeySize / 8];
        this.mRandom.nextBytes(keyBytes);
        return new SecretKeySpec(keyBytes, this.mAlgorithmName);
    }

    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException(this.mAlgorithmName + " does not accept an AlgorithmParameterSpec");
        }
        this.mRandom = random;
    }

    protected void engineInit(int keySize, SecureRandom random) throws InvalidParameterException {
        this.mRandom = random;
        if (keySize < this.mMinimumKeySize) {
            throw new InvalidParameterException(this.mAlgorithmName + " keys must be at least " + this.mMinimumKeySize + " bits in length.");
        }
        this.mKeySize = keySize;
    }

    protected void engineInit(SecureRandom random) {
        this.mRandom = random;
    }
}

