/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.mac;

import com.isnetworks.provider.pbe.PBEKeyConvertor;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;
import javax.crypto.spec.PBEParameterSpec;

public class HMac
extends MacSpi {
    private static final String DEFAULT_DIGEST_ALGORITHM = "SHA";
    private static final int BLOCKSIZE = 64;
    private static final byte IPAD = 54;
    private static final byte OPAD = 92;
    private MessageDigest mDigest;
    private byte[] mOuterPad;
    private PBEKeyConvertor mKeyConvertor = null;

    public HMac(String digestName, PBEKeyConvertor keyConvertor) {
        this(digestName);
        this.mKeyConvertor = keyConvertor;
    }

    public HMac(String digestName) {
        try {
            this.mDigest = MessageDigest.getInstance(digestName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError("No Digest Algorithm: " + digestName);
        }
    }

    public HMac() {
        try {
            this.mDigest = MessageDigest.getInstance(DEFAULT_DIGEST_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError("No Digest Algorithm: SHA");
        }
    }

    protected int engineGetMacLength() {
        return this.mDigest.getDigestLength();
    }

    protected void engineReset() {
        this.mDigest.reset();
    }

    protected void engineInit(Key key, AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        byte[] keyBytes = key.getEncoded();
        if (this.mKeyConvertor != null) {
            if (!(params instanceof PBEParameterSpec)) {
                throw new IllegalArgumentException("PBE MACs must be initialized with a PBEParameterSpec");
            }
            keyBytes = this.mKeyConvertor.getMACBytes(key, (PBEParameterSpec)params);
        } else if (params != null) {
            throw new InvalidParameterException("HMAC does not accept an AlgorithmParameterSpec");
        }
        this.mDigest.reset();
        this.mOuterPad = new byte[64];
        byte[] innerPad = new byte[64];
        if (keyBytes.length > 64) {
            keyBytes = this.mDigest.digest(keyBytes);
        }
        System.arraycopy(keyBytes, 0, innerPad, 0, keyBytes.length);
        System.arraycopy(keyBytes, 0, this.mOuterPad, 0, keyBytes.length);
        int i = 0;
        while (i < 64) {
            int n = i;
            innerPad[n] = (byte)(innerPad[n] ^ 0x36);
            int n2 = i++;
            this.mOuterPad[n2] = (byte)(this.mOuterPad[n2] ^ 0x5C);
        }
        this.mDigest.update(innerPad);
    }

    protected void engineUpdate(byte input) {
        this.mDigest.update(input);
    }

    protected void engineUpdate(byte[] input, int offset, int length) {
        this.mDigest.update(input, offset, length);
    }

    protected byte[] engineDoFinal() {
        byte[] innerHash = this.mDigest.digest();
        this.mDigest.update(this.mOuterPad);
        return this.mDigest.digest(innerHash);
    }
}

