/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.keystore;

import com.isnetworks.provider.pki.PKCS12Wrapper;
import com.isnetworks.provider.pki.PKIException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class PKCS12KeyStore
extends KeyStoreSpi {
    private PKCS12Wrapper m_wrapper;
    private char[] m_password;
    private static final String ALIAS = "default";

    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (this.engineContainsAlias(alias)) {
            try {
                return this.m_wrapper.getPrivateKey(password);
            }
            catch (PKIException e) {
                throw new UnrecoverableKeyException("Could not get key: " + e.getMessage());
            }
        }
        return null;
    }

    public boolean engineContainsAlias(String alias) {
        return this.m_wrapper != null && ALIAS.equals(alias);
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        if (certificate.equals(this.engineGetCertificate(ALIAS))) {
            return ALIAS;
        }
        return null;
    }

    public void engineLoad(InputStream in, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.m_password = password;
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        byte[] buffer = new byte[2048];
        int bytesRead = 0;
        while ((bytesRead = in.read(buffer)) != -1) {
            bOut.write(buffer, 0, bytesRead);
        }
        in.close();
        try {
            this.m_wrapper = new PKCS12Wrapper(bOut.toByteArray());
            if (this.m_wrapper.hasMAC() && password != null && !this.m_wrapper.verifyMAC(password)) {
                throw new IOException("KeyStore integrity not validated - may be using incorrect password");
            }
        }
        catch (PKIException e) {
            throw new IOException("Unable to load KeyStore");
        }
    }

    public void engineSetKeyEntry(String alias, Key key, char[] values, Certificate[] certificate) throws KeyStoreException {
        throw new UnsupportedOperationException("PKCS12 KeyStore implementation is read-only at this time");
    }

    public void engineSetKeyEntry(String alias, byte[] values, Certificate[] certificate) throws KeyStoreException {
        throw new UnsupportedOperationException("PKCS12 KeyStore implementation is read-only at this time");
    }

    public int engineSize() {
        if (this.m_wrapper != null) {
            return 1;
        }
        return 0;
    }

    public Date engineGetCreationDate(String str) {
        return new Date();
    }

    public void engineSetCertificateEntry(String alias, Certificate certificate) {
        throw new UnsupportedOperationException("PKCS12 KeyStore implementation is read-only at this time");
    }

    public Certificate[] engineGetCertificateChain(String alias) {
        Certificate cert = this.engineGetCertificate(alias);
        if (cert == null) {
            return null;
        }
        Certificate[] result = new Certificate[]{cert};
        return result;
    }

    public Certificate engineGetCertificate(String alias) {
        Certificate result = null;
        if (this.engineContainsAlias(alias)) {
            try {
                result = this.m_wrapper.getCertificate();
            }
            catch (PKIException e) {
                e.printStackTrace();
            }
            if (result == null) {
                try {
                    result = this.m_wrapper.getCertificate(this.m_password);
                }
                catch (PKIException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public Enumeration engineAliases() {
        Vector<String> v = new Vector<String>();
        if (this.m_wrapper != null) {
            v.addElement(ALIAS);
        }
        return v.elements();
    }

    public void engineStore(OutputStream out, char[] password) {
        throw new UnsupportedOperationException("PKCS12 KeyStore implementation is read-only at this time");
    }

    public void engineDeleteEntry(String alias) throws KeyStoreException {
        throw new UnsupportedOperationException("PKCS12 KeyStore implementation is read-only at this time");
    }

    public boolean engineIsCertificateEntry(String alias) {
        return false;
    }

    public boolean engineIsKeyEntry(String alias) {
        return this.m_wrapper != null && ALIAS.equals(alias);
    }
}

