/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.asn1.x520;

import com.isnetworks.provider.asn1.ObjectIdentifier;
import java.util.Hashtable;

public class Identifiers {
    public static final ObjectIdentifier commonName = new ObjectIdentifier("commonName");
    public static final ObjectIdentifier surName = new ObjectIdentifier("surName");
    public static final ObjectIdentifier givenName = new ObjectIdentifier("givenName");
    public static final ObjectIdentifier initials = new ObjectIdentifier("initials");
    public static final ObjectIdentifier countryName = new ObjectIdentifier("countryName");
    public static final ObjectIdentifier localityName = new ObjectIdentifier("localityName");
    public static final ObjectIdentifier stateOrProvinceName = new ObjectIdentifier("stateOrProvinceName");
    public static final ObjectIdentifier streetAddress = new ObjectIdentifier("streetAddress");
    public static final ObjectIdentifier organizationName = new ObjectIdentifier("organizationName");
    public static final ObjectIdentifier organizationalUnitName = new ObjectIdentifier("organizationalUnitName");
    public static final ObjectIdentifier title = new ObjectIdentifier("title");
    public static final ObjectIdentifier telephoneNumber = new ObjectIdentifier("telephoneNumber");
    public static final ObjectIdentifier facsimileTelephoneNumber = new ObjectIdentifier("facsimileTelephoneNumber");
    public static final ObjectIdentifier rsaEmailAddr = new ObjectIdentifier("rsaEmailAddr");
    private static Hashtable mIdentifiers = new Hashtable();
    private static Hashtable mAbbreviations = new Hashtable();

    public static void addAbbreviation(String abbreviation, ObjectIdentifier oid) {
        mAbbreviations.put(oid, abbreviation);
        mIdentifiers.put(abbreviation, oid);
    }

    public static void touch() {
    }

    public static ObjectIdentifier getIdentifier(String abbreviation) {
        return (ObjectIdentifier)mIdentifiers.get(abbreviation);
    }

    public static String getAbbreviation(ObjectIdentifier oid) {
        return (String)mAbbreviations.get(oid);
    }

    static {
        commonName.setValue("2.5.4.3");
        surName.setValue("2.5.4.4");
        givenName.setValue("2.5.4.42");
        initials.setValue("2.5.4.43");
        countryName.setValue("2.5.4.6");
        localityName.setValue("2.5.4.7");
        stateOrProvinceName.setValue("2.5.4.8");
        streetAddress.setValue("2.5.4.9");
        organizationName.setValue("2.5.4.10");
        organizationalUnitName.setValue("2.5.4.11");
        title.setValue("2.5.4.12");
        telephoneNumber.setValue("2.5.4.20");
        facsimileTelephoneNumber.setValue("2.5.4.23");
        rsaEmailAddr.setValue("1.2.840.113549.1.9.1");
        Identifiers.addAbbreviation("CN", commonName);
        Identifiers.addAbbreviation("L", localityName);
        Identifiers.addAbbreviation("O", organizationName);
        Identifiers.addAbbreviation("OU", organizationalUnitName);
        Identifiers.addAbbreviation("E", rsaEmailAddr);
        Identifiers.addAbbreviation("C", countryName);
        Identifiers.addAbbreviation("S", stateOrProvinceName);
        Identifiers.addAbbreviation("ST", stateOrProvinceName);
        Identifiers.addAbbreviation("STREET", streetAddress);
        Identifiers.addAbbreviation("T", title);
        Identifiers.addAbbreviation("G", givenName);
        Identifiers.addAbbreviation("I", initials);
        Identifiers.addAbbreviation("SN", surName);
    }
}

