/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.asn1.x509;

import com.isnetworks.provider.asn1.ObjectIdentifier;
import com.isnetworks.provider.asn1.SequenceOf;
import com.isnetworks.provider.asn1.x509.AttributeTypeAndValue;
import com.isnetworks.provider.asn1.x509.RelativeDistinguishedName;
import com.isnetworks.provider.asn1.x520.Identifiers;
import java.io.Serializable;

public class RDNSequence_1
extends SequenceOf
implements Serializable {
    static /* synthetic */ Class class$com$isnetworks$provider$asn1$x509$RelativeDistinguishedName;
    static /* synthetic */ Class class$com$isnetworks$provider$asn1$x509$AttributeTypeAndValue;

    public RDNSequence_1() {
        this.setComponentClass(class$com$isnetworks$provider$asn1$x509$RelativeDistinguishedName == null ? (class$com$isnetworks$provider$asn1$x509$RelativeDistinguishedName = RDNSequence_1.class$("com.isnetworks.provider.asn1.x509.RelativeDistinguishedName")) : class$com$isnetworks$provider$asn1$x509$RelativeDistinguishedName);
    }

    public RDNSequence_1(String identifier) {
        this();
        this.setIdentifier(identifier);
    }

    public RelativeDistinguishedName getRelativeDistinguishedName(int index) {
        return (RelativeDistinguishedName)this.getComponent(index);
    }

    public String getAttributeValue(ObjectIdentifier attributeType) {
        int i = 0;
        while (i < this.getComponentCount()) {
            String attributeValue = this.getRelativeDistinguishedName(i).getAttributeValue(attributeType);
            if (attributeValue != null) {
                return attributeValue;
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = this.getComponentCount() - 1;
        while (i >= 0) {
            if (i < this.getComponentCount() - 1) {
                sb.append(", ");
            }
            sb.append(this.getComponent(i).toString());
            --i;
        }
        return sb.toString();
    }

    public String getRDNValue(String name) {
        int i = 0;
        while (i < this.getComponentCount()) {
            RelativeDistinguishedName rdn = (RelativeDistinguishedName)this.getComponent(i);
            AttributeTypeAndValue typeAndValue = (AttributeTypeAndValue)rdn.getComponent(0);
            ObjectIdentifier oid = Identifiers.getIdentifier(name);
            if (typeAndValue.getAttributeType().equals(oid)) {
                return (String)typeAndValue.getAttributeValue().getActual().getValue();
            }
            ++i;
        }
        return null;
    }

    public void addRDN(String name, String value) {
        RelativeDistinguishedName rdn = new RelativeDistinguishedName(name + "RDN");
        AttributeTypeAndValue typeAndValue = new AttributeTypeAndValue(name + "TypeAndValue");
        typeAndValue.getAttributeType().copy(Identifiers.getIdentifier(name));
        typeAndValue.getAttributeValue().setActual(typeAndValue.getAttributeValue().getPrintableString());
        typeAndValue.getAttributeValue().getPrintableString().setValue(value);
        rdn.addComponent(typeAndValue, class$com$isnetworks$provider$asn1$x509$AttributeTypeAndValue == null ? (class$com$isnetworks$provider$asn1$x509$AttributeTypeAndValue = RDNSequence_1.class$("com.isnetworks.provider.asn1.x509.AttributeTypeAndValue")) : class$com$isnetworks$provider$asn1$x509$AttributeTypeAndValue);
        this.addComponent(rdn, class$com$isnetworks$provider$asn1$x509$RelativeDistinguishedName == null ? (class$com$isnetworks$provider$asn1$x509$RelativeDistinguishedName = RDNSequence_1.class$("com.isnetworks.provider.asn1.x509.RelativeDistinguishedName")) : class$com$isnetworks$provider$asn1$x509$RelativeDistinguishedName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

