/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.asn1.x509;

import com.isnetworks.provider.asn1.BitString;

public class KeyUsage
extends BitString {
    public KeyUsage() {
    }

    public KeyUsage(String identifier) {
        this();
        this.setIdentifier(identifier);
    }

    public void setDigitalSignature(boolean enable) {
        this.setBit(0, enable);
    }

    public boolean isDigitalSignature() {
        return this.getBit(0);
    }

    public void setNonRepudiation(boolean enable) {
        this.setBit(1, enable);
    }

    public boolean isNonRepudiation() {
        return this.getBit(1);
    }

    public void setKeyEncipherment(boolean enable) {
        this.setBit(2, enable);
    }

    public boolean isKeyEncipherment() {
        return this.getBit(2);
    }

    public void setDataEncipherment(boolean enable) {
        this.setBit(3, enable);
    }

    public boolean isDataEncipherment() {
        return this.getBit(3);
    }

    public void setKeyAgreement(boolean enable) {
        this.setBit(4, enable);
    }

    public boolean isKeyAgreement() {
        return this.getBit(4);
    }

    public void setKeyCertSign(boolean enable) {
        this.setBit(5, enable);
    }

    public boolean isKeyCertSign() {
        return this.getBit(5);
    }

    public void setCRLSign(boolean enable) {
        this.setBit(6, enable);
    }

    public boolean isCRLSign() {
        return this.getBit(6);
    }

    public void setEncipherOnly(boolean enable) {
        this.setBit(7, enable);
    }

    public boolean isEncipherOnly() {
        return this.getBit(7);
    }

    public void setDecipherOnly(boolean enable) {
        this.setBit(8, enable);
    }

    public boolean isDecipherOnly() {
        if (this.getBitCount() > 8) {
            return this.getBit(8);
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.isDigitalSignature()) {
            sb.append("DigitalSignature ");
        }
        if (this.isNonRepudiation()) {
            sb.append("NonRepudiation ");
        }
        if (this.isKeyEncipherment()) {
            sb.append("KeyEncipherment ");
        }
        if (this.isDataEncipherment()) {
            sb.append("DataEncipherment ");
        }
        if (this.isKeyAgreement()) {
            sb.append("KeyAgreement ");
        }
        if (this.isKeyCertSign()) {
            sb.append("KeyCertSign ");
        }
        if (this.isCRLSign()) {
            sb.append("CRLSign ");
        }
        if (this.isEncipherOnly()) {
            sb.append("EncipherOnly ");
        }
        if (this.isDecipherOnly()) {
            sb.append("DecipherOnly ");
        }
        sb.append("(");
        sb.append(super.toString());
        sb.append(")");
        return sb.toString();
    }
}

