/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.asn1.x509;

import com.isnetworks.provider.asn1.AsnBoolean;
import com.isnetworks.provider.asn1.AsnObject;
import com.isnetworks.provider.asn1.EncodeException;
import com.isnetworks.provider.asn1.ObjectIdentifier;
import com.isnetworks.provider.asn1.OctetString;
import com.isnetworks.provider.asn1.Sequence;

public class Extension
extends Sequence {
    private ObjectIdentifier mExtnID = new ObjectIdentifier("extnID");
    private AsnBoolean mCritical;
    private OctetString mExtnValue;

    public Extension() {
        this.addComponent(this.mExtnID);
        this.mCritical = new AsnBoolean("critical");
        this.mCritical.setOptional(true);
        this.mCritical.setDefaultValue(new Boolean(false));
        this.addComponent(this.mCritical);
        this.mExtnValue = new OctetString("extnValue");
        this.addComponent(this.mExtnValue);
    }

    public Extension(String identifier) {
        this();
        this.setIdentifier(identifier);
    }

    public ObjectIdentifier getExtnID() {
        return this.mExtnID;
    }

    public AsnBoolean getCritical() {
        return this.mCritical;
    }

    public Boolean getCriticalValue() {
        return (Boolean)this.mCritical.getValue();
    }

    public OctetString getExtnValue() {
        return this.mExtnValue;
    }

    public byte[] getExtnValueValue() {
        return (byte[])this.mExtnValue.getValue();
    }

    public void setExtnAsnObjectValue(AsnObject o) throws EncodeException {
        byte[] encodedObject = o.encode();
        OctetString octetString = new OctetString("extensionAsnObjectValue");
        octetString.setValue(encodedObject);
        this.getExtnValue().copy(octetString);
    }
}

