/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.asn1.x509;

import com.isnetworks.provider.asn1.AsnObject;
import com.isnetworks.provider.asn1.ObjectIdentifier;
import com.isnetworks.provider.asn1.Sequence;
import com.isnetworks.provider.asn1.x509.AlgorithmIdentifier;
import com.isnetworks.provider.asn1.x509.CertificateSerialNumber;
import com.isnetworks.provider.asn1.x509.Extensions;
import com.isnetworks.provider.asn1.x509.Name;
import com.isnetworks.provider.asn1.x509.SIGNED;
import com.isnetworks.provider.asn1.x509.SubjectPublicKeyInfo;
import com.isnetworks.provider.asn1.x509.UniqueIdentifier;
import com.isnetworks.provider.asn1.x509.Validity;
import com.isnetworks.provider.asn1.x509.Version;
import com.isnetworks.provider.asn1.x520.Identifiers;
import java.util.Date;

public class Certificate
extends SIGNED {
    public Certificate() {
        this.setToBeSigned(new ToBeSigned("tbs"));
    }

    public Certificate(String identifier) {
        this();
        this.setIdentifier(identifier);
    }

    public void setAlgorithmIdentifierValues(ObjectIdentifier algid, AsnObject params) {
        super.setAlgorithmIdentifierValues(algid, params);
        this.getToBeSignedSignature().getAlgorithm().copy(algid);
        this.getToBeSignedSignature().getParameters().setActual(params);
    }

    public Version getVersion() {
        return ((ToBeSigned)this.getToBeSigned()).mVersion;
    }

    public CertificateSerialNumber getSerialNumber() {
        return ((ToBeSigned)this.getToBeSigned()).mSerialNumber;
    }

    public AlgorithmIdentifier getToBeSignedSignature() {
        return ((ToBeSigned)this.getToBeSigned()).mSignature;
    }

    public Name getIssuer() {
        return ((ToBeSigned)this.getToBeSigned()).mIssuer;
    }

    public Validity getValidity() {
        return ((ToBeSigned)this.getToBeSigned()).mValidity;
    }

    public Name getSubject() {
        return ((ToBeSigned)this.getToBeSigned()).mSubject;
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return ((ToBeSigned)this.getToBeSigned()).mSubjectPublicKeyInfo;
    }

    public UniqueIdentifier getIssuerUniqueID() {
        return ((ToBeSigned)this.getToBeSigned()).mIssuerUniqueID;
    }

    public UniqueIdentifier getSubjectUniqueID() {
        return ((ToBeSigned)this.getToBeSigned()).mSubjectUniqueID;
    }

    public Extensions getExtensions() {
        return ((ToBeSigned)this.getToBeSigned()).mExtensions;
    }

    public String getSubjectCommonName() {
        Identifiers.touch();
        return this.getSubject().getAttributeValue(Identifiers.commonName);
    }

    public String getSubjectEmailAddress() {
        Identifiers.touch();
        return this.getSubject().getAttributeValue(Identifiers.rsaEmailAddr);
    }

    public String getIssuerCommonName() {
        Identifiers.touch();
        return this.getIssuer().getAttributeValue(Identifiers.commonName);
    }

    public Date getValidFromValue() {
        return (Date)this.getValidity().getNotBefore().getValue();
    }

    public Date getValidToValue() {
        return (Date)this.getValidity().getNotAfter().getValue();
    }

    public class ToBeSigned
    extends Sequence {
        private Version mVersion = new Version("version");
        private CertificateSerialNumber mSerialNumber;
        private AlgorithmIdentifier mSignature;
        private Name mIssuer;
        private Validity mValidity;
        private Name mSubject;
        private SubjectPublicKeyInfo mSubjectPublicKeyInfo;
        private UniqueIdentifier mIssuerUniqueID;
        private UniqueIdentifier mSubjectUniqueID;
        private Extensions mExtensions;

        public ToBeSigned() {
            this.mVersion.setTag(128, 0, 2, true);
            this.mVersion.setDefaultValue(Version.v1);
            this.addComponent(this.mVersion);
            this.mSerialNumber = new CertificateSerialNumber("serialNumber");
            this.addComponent(this.mSerialNumber);
            this.mSignature = new AlgorithmIdentifier("signature");
            this.addComponent(this.mSignature);
            this.mIssuer = new Name("issuer");
            this.addComponent(this.mIssuer);
            this.mValidity = new Validity("validity");
            this.addComponent(this.mValidity);
            this.mSubject = new Name("subject");
            this.addComponent(this.mSubject);
            this.mSubjectPublicKeyInfo = new SubjectPublicKeyInfo("subjectPublicKeyInfo");
            this.addComponent(this.mSubjectPublicKeyInfo);
            this.mIssuerUniqueID = new UniqueIdentifier("issuerUniqueID");
            this.mIssuerUniqueID.setTag(128, 1, 1, true);
            this.addComponent(this.mIssuerUniqueID);
            this.mSubjectUniqueID = new UniqueIdentifier("subjectUniqueID");
            this.mSubjectUniqueID.setTag(128, 2, 1, true);
            this.addComponent(this.mSubjectUniqueID);
            this.mExtensions = new Extensions("extensions");
            this.mExtensions.setTag(128, 3, 2, true);
            this.addComponent(this.mExtensions);
        }

        public ToBeSigned(String identifier) {
            this();
            this.setIdentifier(identifier);
        }
    }
}

