/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.asn1.x509;

import com.isnetworks.provider.asn1.Any;
import com.isnetworks.provider.asn1.AsnObject;
import com.isnetworks.provider.asn1.DecodeListener;
import com.isnetworks.provider.asn1.Null;
import com.isnetworks.provider.asn1.ObjectIdentifier;
import com.isnetworks.provider.asn1.Sequence;
import com.isnetworks.provider.asn1.cms.IV;
import com.isnetworks.provider.asn1.cms.Identifiers;
import com.isnetworks.provider.asn1.cms.RC2CBCParameter;
import com.isnetworks.provider.asn1.pkcs12.PKCS12PBEParams;
import com.isnetworks.provider.asn1.x509.DSSParms;

public class AlgorithmIdentifier
extends Sequence {
    private ObjectIdentifier mAlgorithm = new ObjectIdentifier("algorithm");
    private Any mParameters;

    public AlgorithmIdentifier() {
        this.addComponent(this.mAlgorithm);
        this.mParameters = new Any("parameters");
        this.mParameters.setOptional(true);
        this.addComponent(this.mParameters);
        this.mAlgorithm.addDecodeListener(new DecodeListener(){

            public void objectDecoded(AsnObject object) {
                AlgorithmIdentifier.this.chooseParameters();
            }
        });
    }

    public AlgorithmIdentifier(String identifier) {
        this();
        this.setIdentifier(identifier);
    }

    public ObjectIdentifier getAlgorithm() {
        return this.mAlgorithm;
    }

    public Any getParameters() {
        return this.mParameters;
    }

    public void chooseParameters() {
        if (this.getAlgorithm().equals(Identifiers.rc2_cbc)) {
            this.mParameters.setActual(new RC2CBCParameter("rc2cbcParameter"));
        } else if (this.getAlgorithm().equals(Identifiers.des_ede3_cbc)) {
            this.mParameters.setActual(new IV("iv"));
        } else if (this.getAlgorithm().equals(Identifiers.des_cbc)) {
            this.mParameters.setActual(new IV("iv"));
        } else if (this.getAlgorithm().equals(Identifiers.dsa)) {
            this.mParameters.setActual(new DSSParms("dssParms"));
        } else if (this.getAlgorithm().equals(Identifiers.id_dsa_with_sha1)) {
            this.mParameters.setActual(null);
        } else if (this.getAlgorithm().equals(com.isnetworks.provider.asn1.pkcs12.Identifiers.pbeWithSHAAnd128BitRC4)) {
            this.mParameters.setActual(new PKCS12PBEParams("pkcs-12PbeParams"));
        } else if (this.getAlgorithm().equals(com.isnetworks.provider.asn1.pkcs12.Identifiers.pbeWithSHAAnd40BitRC4)) {
            this.mParameters.setActual(new PKCS12PBEParams("pkcs-12PbeParams"));
        } else if (this.getAlgorithm().equals(com.isnetworks.provider.asn1.pkcs12.Identifiers.pbeWithSHAAnd3_KeyTripleDES_CBC)) {
            this.mParameters.setActual(new PKCS12PBEParams("pkcs-12PbeParams"));
        } else if (this.getAlgorithm().equals(com.isnetworks.provider.asn1.pkcs12.Identifiers.pbeWithSHAAnd2_KeyTripleDES_CBC)) {
            this.mParameters.setActual(new PKCS12PBEParams("pkcs-12PbeParams"));
        } else if (this.getAlgorithm().equals(com.isnetworks.provider.asn1.pkcs12.Identifiers.pbeWithSHAAnd128BitRC2_CBC)) {
            this.mParameters.setActual(new PKCS12PBEParams("pkcs-12PbeParams"));
        } else if (this.getAlgorithm().equals(com.isnetworks.provider.asn1.pkcs12.Identifiers.pbewithSHAAnd40BitRC2_CBC)) {
            this.mParameters.setActual(new PKCS12PBEParams("pkcs-12PbeParams"));
        } else {
            this.mParameters.setActual(new Null("null"));
        }
    }
}

