/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.asn1.pkcs7;

import com.isnetworks.provider.asn1.Sequence;
import com.isnetworks.provider.asn1.TypeMapper;
import com.isnetworks.provider.asn1.pkcs7.Attributes;
import com.isnetworks.provider.asn1.pkcs7.DigestAlgorithmIdentifier;
import com.isnetworks.provider.asn1.pkcs7.DigestEncryptionAlgorithmIdentifier;
import com.isnetworks.provider.asn1.pkcs7.EncryptedDigest;
import com.isnetworks.provider.asn1.pkcs7.IssuerAndSerialNumber;
import com.isnetworks.provider.asn1.pkcs7.Version;

public class SignerInfo
extends Sequence {
    private Version mVersion = new Version("version");
    private IssuerAndSerialNumber mIssuerAndSerialNumber;
    private DigestAlgorithmIdentifier mDigestAlgorithm;
    private Attributes mAuthenticatedAttributes;
    private DigestEncryptionAlgorithmIdentifier mDigestEncryptionAlgorithm;
    private EncryptedDigest mEncryptedDigest;
    private Attributes mUnauthenticatedAttributes;

    public SignerInfo() {
        this.addComponent(this.mVersion);
        this.mIssuerAndSerialNumber = new IssuerAndSerialNumber("issuerAndSerialNumber");
        this.addComponent(this.mIssuerAndSerialNumber);
        this.mDigestAlgorithm = new DigestAlgorithmIdentifier("digestAlgorithm");
        this.addComponent(this.mDigestAlgorithm);
        this.mAuthenticatedAttributes = new Attributes("authenticatedAttributes");
        this.mAuthenticatedAttributes.setTag(128, 0, 1, true);
        this.addComponent(this.mAuthenticatedAttributes);
        this.mDigestEncryptionAlgorithm = new DigestEncryptionAlgorithmIdentifier("digestEncryptionAlgorithm");
        this.addComponent(this.mDigestEncryptionAlgorithm);
        this.mEncryptedDigest = new EncryptedDigest("encryptedDigest");
        this.addComponent(this.mEncryptedDigest);
        this.mUnauthenticatedAttributes = new Attributes("unauthenticatedAttributes");
        this.mUnauthenticatedAttributes.setTag(128, 1, 1, true);
        this.addComponent(this.mUnauthenticatedAttributes);
    }

    public SignerInfo(String identifier) {
        this();
        this.setIdentifier(identifier);
    }

    public void setAuthenticatedTypeMapper(TypeMapper mapper) {
        this.mAuthenticatedAttributes.setTypeMapper(mapper);
    }

    public Version getVersion() {
        return this.mVersion;
    }

    public IssuerAndSerialNumber getIssuerAndSerialNumber() {
        return this.mIssuerAndSerialNumber;
    }

    public DigestAlgorithmIdentifier getDigestAlgorithm() {
        return this.mDigestAlgorithm;
    }

    public Attributes getAuthenticatedAttributes() {
        return this.mAuthenticatedAttributes;
    }

    public DigestEncryptionAlgorithmIdentifier getDigestEncryptionAlgorithm() {
        return this.mDigestEncryptionAlgorithm;
    }

    public EncryptedDigest getEncryptedDigest() {
        return this.mEncryptedDigest;
    }

    public Attributes getUnauthenticatedAttributes() {
        return this.mUnauthenticatedAttributes;
    }
}

