/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.provider.asn1.pkcs7;

import com.isnetworks.provider.asn1.Sequence;
import com.isnetworks.provider.asn1.TypeMapper;
import com.isnetworks.provider.asn1.pem2.CertificateRevocationList;
import com.isnetworks.provider.asn1.pkcs7.CertificateRevocationLists;
import com.isnetworks.provider.asn1.pkcs7.ContentInfo;
import com.isnetworks.provider.asn1.pkcs7.DigestAlgorithmIdentifiers;
import com.isnetworks.provider.asn1.pkcs7.ExtendedCertificatesAndCertificates;
import com.isnetworks.provider.asn1.pkcs7.SignerInfo;
import com.isnetworks.provider.asn1.pkcs7.SignerInfos;
import com.isnetworks.provider.asn1.pkcs7.Version;

public class SignedData
extends Sequence {
    private Version mVersion = new Version("version");
    private DigestAlgorithmIdentifiers mDigestAlgorithms;
    private ContentInfo mContentInfo;
    private ExtendedCertificatesAndCertificates mCertificates;
    private CertificateRevocationLists mCrls;
    private SignerInfos mSignerInfos;

    public SignedData() {
        this.addComponent(this.mVersion);
        this.mDigestAlgorithms = new DigestAlgorithmIdentifiers("digestAlgorithms");
        this.addComponent(this.mDigestAlgorithms);
        this.mContentInfo = new ContentInfo("contentInfo");
        this.addComponent(this.mContentInfo);
        this.mCertificates = new ExtendedCertificatesAndCertificates("certificates");
        this.mCertificates.setTag(128, 0, 1, true);
        this.addComponent(this.mCertificates);
        this.mCrls = new CertificateRevocationLists("crls");
        this.mCrls.setTag(128, 1, 1, true);
        this.addComponent(this.mCrls);
        this.mSignerInfos = new SignerInfos("signerInfos");
        this.addComponent(this.mSignerInfos);
    }

    public SignedData(String identifier) {
        this();
        this.setIdentifier(identifier);
    }

    public void setAuthenticatedTypeMapper(TypeMapper mapper) {
        this.mSignerInfos.setAuthenticatedTypeMapper(mapper);
    }

    public Version getVersion() {
        return this.mVersion;
    }

    public DigestAlgorithmIdentifiers getDigestAlgorithms() {
        return this.mDigestAlgorithms;
    }

    public ContentInfo getContentInfo() {
        return this.mContentInfo;
    }

    public ExtendedCertificatesAndCertificates getCertificates() {
        return this.mCertificates;
    }

    public CertificateRevocationLists getCrls() {
        return this.mCrls;
    }

    public int getCrlCount() {
        return this.mCrls.getComponentCount();
    }

    public CertificateRevocationList getCrl(int index) {
        return this.mCrls.getCrl(index);
    }

    public void addCrl(CertificateRevocationList crl) {
        this.mCrls.addComponent(crl);
    }

    public SignerInfos getSignerInfos() {
        return this.mSignerInfos;
    }

    public int getSignerCount() {
        return this.mSignerInfos.getComponentCount();
    }

    public SignerInfo getSignerInfo(int index) {
        return this.mSignerInfos.getSignerInfo(index);
    }
}

